/*
 * Decompiled with CFR 0.152.
 */
package org.hsql143;

import java.sql.SQLException;
import org.hsql143.Expression;
import org.hsql143.Index;
import org.hsql143.Node;
import org.hsql143.Table;
import org.hsql143.Trace;

class TableFilter {
    private Table tTable;
    private String sAlias;
    private Index iIndex;
    private Node nCurrent;
    private Object[] oEmptyData;
    private Expression eStart;
    private Expression eEnd;
    private Expression eAnd;
    private boolean bOuterJoin;
    Object[] oCurrentData;

    TableFilter(Table t, String alias, boolean outerjoin) {
        this.tTable = t;
        this.iIndex = null;
        this.sAlias = alias != null ? alias : t.getName();
        this.bOuterJoin = outerjoin;
        this.oEmptyData = this.tTable.getNewRow();
    }

    String getName() {
        return this.sAlias;
    }

    Table getTable() {
        return this.tTable;
    }

    void setCondition(Expression e) throws SQLException {
        int candidate;
        int type = e.getType();
        Expression e1 = e.getArg();
        Expression e2 = e.getArg2();
        if (type == 28) {
            this.setCondition(e1);
            this.setCondition(e2);
            return;
        }
        switch (type) {
            case 26: 
            case 27: 
            case 30: {
                candidate = 0;
                break;
            }
            case 21: {
                candidate = 1;
                break;
            }
            case 22: 
            case 23: {
                candidate = 2;
                break;
            }
            case 24: 
            case 25: {
                candidate = 3;
                break;
            }
            default: {
                return;
            }
        }
        if (e1.getFilter() != this) {
            if (e2.getFilter() == this && candidate != 0) {
                e.swapCondition();
                this.setCondition(e);
                return;
            }
            return;
        }
        Trace.Assert(e1.getFilter() == this, "setCondition");
        if (!e2.isResolved()) {
            return;
        }
        if (candidate == 0) {
            this.addAndCondition(e);
            return;
        }
        int i = e1.getColumnNr();
        Index index = this.tTable.getIndexForColumn(i);
        if (index == null || this.iIndex != index && this.iIndex != null) {
            this.addAndCondition(e);
            return;
        }
        this.iIndex = index;
        if (candidate == 1) {
            if (this.eStart != null || this.eEnd != null) {
                this.addAndCondition(e);
                return;
            }
            this.eEnd = this.eStart = new Expression(e);
        } else if (candidate == 2) {
            if (this.eStart != null) {
                this.addAndCondition(e);
                return;
            }
            this.eStart = new Expression(e);
        } else if (candidate == 3) {
            if (this.eEnd != null) {
                this.addAndCondition(e);
                return;
            }
            this.eEnd = new Expression(e);
        }
        e.setTrue();
    }

    boolean findFirst() throws SQLException {
        if (this.iIndex == null) {
            this.iIndex = this.tTable.getPrimaryIndex();
        }
        if (this.eStart == null) {
            this.nCurrent = this.iIndex.first();
        } else {
            int type = this.eStart.getArg().getDataType();
            Object o = this.eStart.getArg2().getValue(type);
            this.nCurrent = this.iIndex.findFirst(o, this.eStart.getType());
        }
        while (this.nCurrent != null) {
            this.oCurrentData = this.nCurrent.getData();
            if (!this.test(this.eEnd)) break;
            if (this.test(this.eAnd)) {
                return true;
            }
            this.nCurrent = this.iIndex.next(this.nCurrent);
        }
        this.oCurrentData = this.oEmptyData;
        return this.bOuterJoin;
    }

    boolean next() throws SQLException {
        if (this.bOuterJoin && this.nCurrent == null) {
            return false;
        }
        this.nCurrent = this.iIndex.next(this.nCurrent);
        while (this.nCurrent != null) {
            this.oCurrentData = this.nCurrent.getData();
            if (!this.test(this.eEnd)) break;
            if (this.test(this.eAnd)) {
                return true;
            }
            this.nCurrent = this.iIndex.next(this.nCurrent);
        }
        this.oCurrentData = this.oEmptyData;
        return false;
    }

    private void addAndCondition(Expression e) {
        Expression and;
        Expression e2 = new Expression(e);
        this.eAnd = this.eAnd == null ? e2 : (and = new Expression(28, this.eAnd, e2));
        e.setTrue();
    }

    private boolean test(Expression e) throws SQLException {
        if (e == null) {
            return true;
        }
        return e.test();
    }
}

