/*
 * Decompiled with CFR 0.152.
 */
package org.hsql143;

import java.sql.SQLException;
import java.util.Vector;
import org.hsql143.Cache;
import org.hsql143.Channel;
import org.hsql143.Column;
import org.hsql143.Constraint;
import org.hsql143.Database;
import org.hsql143.Index;
import org.hsql143.Log;
import org.hsql143.Node;
import org.hsql143.Record;
import org.hsql143.Result;
import org.hsql143.Row;
import org.hsql143.Trace;

class Table {
    private String sName;
    private Vector vColumn;
    private Vector vIndex;
    private int iVisibleColumns;
    private int iColumnCount;
    private int iPrimaryKey;
    private boolean bCached;
    private Database dDatabase;
    private Log lLog;
    private int iIndexCount;
    private int iIdentityColumn;
    private int iIdentityId;
    private Vector vConstraint;
    private int iConstraintCount;
    Cache cCache;

    Table(Database db, boolean log, String name, boolean cached) {
        this.dDatabase = db;
        Log log2 = this.lLog = log ? db.getLog() : null;
        if (cached) {
            this.cCache = this.lLog.cCache;
            this.bCached = true;
        }
        this.sName = name;
        this.iPrimaryKey = -1;
        this.iIdentityColumn = -1;
        this.vColumn = new Vector();
        this.vIndex = new Vector();
        this.vConstraint = new Vector();
    }

    void addConstraint(Constraint c) {
        this.vConstraint.addElement(c);
        ++this.iConstraintCount;
    }

    Vector getConstraints() {
        return this.vConstraint;
    }

    void addColumn(String name, int type) throws SQLException {
        this.addColumn(name, type, true, false);
    }

    void addColumn(Column c) throws SQLException {
        this.addColumn(c.sName, c.iType, c.isNullable(), c.isIdentity());
    }

    void addColumn(String name, int type, boolean nullable, boolean identity) throws SQLException {
        if (identity) {
            Trace.check(type == 4, 15, name);
            Trace.check(this.iIdentityColumn == -1, 23, name);
            this.iIdentityColumn = this.iColumnCount;
        }
        Trace.Assert(this.iPrimaryKey == -1, "Table.addColumn");
        this.vColumn.addElement(new Column(name, nullable, type, identity));
        ++this.iColumnCount;
    }

    void addColumns(Result result) throws SQLException {
        int i = 0;
        while (i < result.getColumnCount()) {
            this.addColumn(result.sLabel[i], result.iType[i], true, false);
            ++i;
        }
    }

    String getName() {
        return this.sName;
    }

    int getInternalColumnCount() {
        return this.iColumnCount;
    }

    Table moveDefinition(String withoutindex) throws SQLException {
        Table tn = new Table(this.dDatabase, true, this.getName(), this.isCached());
        int i = 0;
        while (i < this.getColumnCount()) {
            tn.addColumn(this.getColumn(i));
            ++i;
        }
        if (this.iVisibleColumns < this.iColumnCount) {
            tn.createPrimaryKey();
        } else {
            tn.createPrimaryKey(this.getPrimaryIndex().getColumns()[0]);
        }
        Index idx = null;
        while ((idx = this.getNextIndex(idx)) != null) {
            if (withoutindex != null && idx.getName().equals(withoutindex) || idx == this.getPrimaryIndex()) continue;
            tn.createIndex(idx);
        }
        int i2 = 0;
        while (i2 < this.iConstraintCount) {
            Constraint c = (Constraint)this.vConstraint.elementAt(i2);
            c.replaceTable(this, tn);
            ++i2;
        }
        tn.vConstraint = this.vConstraint;
        return tn;
    }

    int getColumnCount() {
        return this.iVisibleColumns;
    }

    int getIndexCount() {
        return this.iIndexCount;
    }

    int getIdentityColumn() {
        return this.iIdentityColumn;
    }

    int getColumnNr(String c) throws SQLException {
        int i = this.searchColumn(c);
        if (i == -1) {
            throw Trace.error(27, c);
        }
        return i;
    }

    int searchColumn(String c) {
        int i = 0;
        while (i < this.iColumnCount) {
            if (c.equals(((Column)this.vColumn.elementAt((int)i)).sName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    String getColumnName(int i) {
        return this.getColumn((int)i).sName;
    }

    int getColumnType(int i) {
        return this.getColumn((int)i).iType;
    }

    boolean getColumnIsNullable(int i) {
        return this.getColumn(i).isNullable();
    }

    Index getPrimaryIndex() throws SQLException {
        if (this.iPrimaryKey == -1) {
            return null;
        }
        return this.getIndex(0);
    }

    Index getIndexForColumn(int column) throws SQLException {
        int i = 0;
        while (i < this.iIndexCount) {
            Index h = this.getIndex(i);
            if (h.getColumns()[0] == column) {
                return h;
            }
            ++i;
        }
        return null;
    }

    Index getIndexForColumns(int[] col) throws SQLException {
        int i = 0;
        while (i < this.iIndexCount) {
            Index h = this.getIndex(i);
            int[] icol = h.getColumns();
            int j = 0;
            while (j < col.length) {
                if (j >= icol.length || icol[j] != col[j]) break;
                ++j;
            }
            if (j == col.length) {
                return h;
            }
            ++i;
        }
        return null;
    }

    String getIndexRoots() throws SQLException {
        Trace.Assert(this.bCached, "Table.getIndexRootData");
        String s = "";
        int i = 0;
        while (i < this.iIndexCount) {
            Node f = this.getIndex(i).getRoot();
            s = f != null ? String.valueOf(s) + f.getKey() + " " : String.valueOf(s) + "-1 ";
            ++i;
        }
        s = String.valueOf(s) + this.iIdentityId;
        return s;
    }

    void setIndexRoots(String s) throws SQLException {
        Trace.check(this.bCached, 21);
        int j = 0;
        int i = 0;
        while (i < this.iIndexCount) {
            int n = s.indexOf(32, j);
            int p = Integer.parseInt(s.substring(j, n));
            if (p != -1) {
                Row r = this.cCache.getRow(p, this);
                Node f = r.getNode(i);
                this.getIndex(i).setRoot(f);
            }
            j = n + 1;
            ++i;
        }
        this.iIdentityId = Integer.parseInt(s.substring(j));
    }

    Index getNextIndex(Index index) {
        int i = 0;
        if (index != null) {
            while (i < this.iIndexCount && this.getIndex(i) != index) {
                ++i;
            }
            ++i;
        }
        if (i < this.iIndexCount) {
            return this.getIndex(i);
        }
        return null;
    }

    int getType(int i) {
        return this.getColumn((int)i).iType;
    }

    void createPrimaryKey(int column) throws SQLException {
        Trace.Assert(this.iPrimaryKey == -1, "Table.createPrimaryKey(column)");
        this.iVisibleColumns = this.iColumnCount;
        this.iPrimaryKey = column;
        int[] col = new int[]{column};
        this.createIndex(col, "SYSTEM_PK", true);
    }

    void createPrimaryKey() throws SQLException {
        Trace.Assert(this.iPrimaryKey == -1, "Table.createPrimaryKey");
        this.addColumn("SYSTEM_ID", 4, true, true);
        this.createPrimaryKey(this.iColumnCount - 1);
        this.iVisibleColumns = this.iColumnCount - 1;
    }

    void createIndex(Index index) throws SQLException {
        this.createIndex(index.getColumns(), index.getName(), index.isUnique());
    }

    void createIndex(int[] column, String name, boolean unique) throws SQLException {
        Trace.Assert(this.iPrimaryKey != -1, "createIndex");
        int i = 0;
        while (i < this.iIndexCount) {
            Index index = this.getIndex(i);
            if (name.equals(index.getName())) {
                throw Trace.error(22);
            }
            ++i;
        }
        int s = column.length;
        int[] col = new int[unique ? s : s + 1];
        int[] type = new int[unique ? s : s + 1];
        int j = 0;
        while (j < s) {
            col[j] = column[j];
            type[j] = this.getColumn((int)col[j]).iType;
            ++j;
        }
        if (!unique) {
            col[s] = this.iPrimaryKey;
            type[s] = this.getColumn((int)this.iPrimaryKey).iType;
        }
        Index index = new Index(name, col, type, unique);
        if (this.iIndexCount != 0) {
            Trace.Assert(this.isEmpty(), "createIndex");
        }
        this.vIndex.addElement(index);
        ++this.iIndexCount;
    }

    void checkDropIndex(String index) throws SQLException {
        int i = 0;
        while (i < this.iIndexCount) {
            if (index.equals(this.getIndex(i).getName())) {
                Trace.check(i != 0, 24);
                return;
            }
            ++i;
        }
        throw Trace.error(25, index);
    }

    boolean isEmpty() {
        return this.getIndex(0).getRoot() == null;
    }

    Object[] getNewRow() {
        return new Object[this.iColumnCount];
    }

    void moveData(Table from) throws SQLException {
        Object[] o;
        Index index = from.getPrimaryIndex();
        Node n = index.first();
        while (n != null) {
            o = n.getData();
            this.insertNoCheck(o, null);
            n = index.next(n);
        }
        index = this.getPrimaryIndex();
        n = index.first();
        while (n != null) {
            o = n.getData();
            from.deleteNoCheck(o, null);
            n = index.next(n);
        }
    }

    void checkUpdate(int[] col, Result deleted, Result inserted) throws SQLException {
        if (this.dDatabase.isReferentialIntegrity()) {
            int i = 0;
            while (i < this.iConstraintCount) {
                Constraint v = (Constraint)this.vConstraint.elementAt(i);
                v.checkUpdate(col, deleted, inserted);
                ++i;
            }
        }
    }

    void insert(Result result, Channel c) throws SQLException {
        Record r = result.rRoot;
        int len = result.getColumnCount();
        while (r != null) {
            Object[] row = this.getNewRow();
            int i = 0;
            while (i < len) {
                row[i] = r.data[i];
                ++i;
            }
            this.insert(row, c);
            r = r.next;
        }
    }

    void insert(Object[] row, Channel c) throws SQLException {
        if (this.dDatabase.isReferentialIntegrity()) {
            int i = 0;
            while (i < this.iConstraintCount) {
                ((Constraint)this.vConstraint.elementAt(i)).checkInsert(row);
                ++i;
            }
        }
        this.insertNoCheck(row, c);
    }

    void insertNoCheck(Object[] row, Channel c) throws SQLException {
        this.insertNoCheck(row, c, true);
    }

    /*
     * Unable to fully structure code
     */
    void insertNoCheck(Object[] row, Channel c, boolean log) throws SQLException {
        block14: {
            if (this.iIdentityColumn != -1) {
                id = (Integer)row[this.iIdentityColumn];
                if (id == null) {
                    if (c != null) {
                        c.setLastIdentity(this.iIdentityId);
                    }
                    row[this.iIdentityColumn] = new Integer(this.iIdentityId++);
                } else {
                    i = id;
                    if (this.iIdentityId <= i) {
                        if (c != null) {
                            c.setLastIdentity(i);
                        }
                        this.iIdentityId = i + 1;
                    }
                }
            }
            i = 0;
            while (i < this.iColumnCount) {
                if (row[i] == null && !this.getColumn(i).isNullable()) {
                    throw Trace.error(9);
                }
                ++i;
            }
            i = 0;
            try {
                r = new Row(this, row);
                while (i < this.iIndexCount) {
                    n = r.getNode(i);
                    this.getIndex(i).insert(n);
                    ++i;
                }
                break block14;
            }
            catch (SQLException e) {
                --i;
                ** while (i >= 0)
            }
lbl-1000:
            // 1 sources

            {
                this.getIndex(i).delete(row, i == 0);
                --i;
                continue;
            }
lbl34:
            // 1 sources

            throw e;
        }
        if (c != null) {
            c.addTransactionInsert(this, row);
        }
        if (this.lLog != null) {
            this.lLog.write(c, this.getInsertStatement(row));
        }
    }

    void delete(Object[] row, Channel c) throws SQLException {
        if (this.dDatabase.isReferentialIntegrity()) {
            int i = 0;
            while (i < this.iConstraintCount) {
                ((Constraint)this.vConstraint.elementAt(i)).checkDelete(row);
                ++i;
            }
        }
        this.deleteNoCheck(row, c);
    }

    void deleteNoCheck(Object[] row, Channel c) throws SQLException {
        this.deleteNoCheck(row, c, true);
    }

    void deleteNoCheck(Object[] row, Channel c, boolean log) throws SQLException {
        int i = 1;
        while (i < this.iIndexCount) {
            this.getIndex(i).delete(row, false);
            ++i;
        }
        this.getIndex(0).delete(row, true);
        if (c != null) {
            c.addTransactionDelete(this, row);
        }
        if (this.lLog != null) {
            this.lLog.write(c, this.getDeleteStatement(row));
        }
    }

    String getInsertStatement(Object[] row) throws SQLException {
        StringBuffer a = new StringBuffer("INSERT INTO ");
        a.append(this.getName());
        a.append(" VALUES(");
        int i = 0;
        while (i < this.iVisibleColumns) {
            a.append(Column.createString(row[i], this.getColumn((int)i).iType));
            a.append(',');
            ++i;
        }
        a.setCharAt(a.length() - 1, ')');
        return a.toString();
    }

    boolean isCached() {
        return this.bCached;
    }

    Index getIndex(String s) {
        int i = 0;
        while (i < this.iIndexCount) {
            Index h = this.getIndex(i);
            if (s.equals(h.getName())) {
                return h;
            }
            ++i;
        }
        return null;
    }

    Column getColumn(int i) {
        return (Column)this.vColumn.elementAt(i);
    }

    private Index getIndex(int i) {
        return (Index)this.vIndex.elementAt(i);
    }

    private String getDeleteStatement(Object[] row) throws SQLException {
        StringBuffer a = new StringBuffer("DELETE FROM ");
        a.append(this.sName);
        a.append(" WHERE ");
        if (this.iVisibleColumns < this.iColumnCount) {
            int i = 0;
            while (i < this.iVisibleColumns) {
                a.append(this.getColumn((int)i).sName);
                a.append('=');
                a.append(Column.createString(row[i], this.getColumn((int)i).iType));
                if (i < this.iVisibleColumns - 1) {
                    a.append(" AND ");
                }
                ++i;
            }
        } else {
            a.append(this.getColumn((int)this.iPrimaryKey).sName);
            a.append("=");
            a.append(Column.createString(row[this.iPrimaryKey], this.getColumn((int)this.iPrimaryKey).iType));
        }
        return a.toString();
    }
}

