/*
 * Decompiled with CFR 0.152.
 */
package org.hsql143;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.sql.SQLException;
import org.hsql143.Channel;
import org.hsql143.Database;
import org.hsql143.Result;
import org.hsql143.Server;

class ServerConnection
extends Thread {
    private Database mDatabase;
    private Socket mSocket;
    private Server mServer;
    private DataInputStream mInput;
    private DataOutputStream mOutput;
    private static int mCurrentThread = 0;
    private int mThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerConnection(Socket socket, Server server) {
        this.mSocket = socket;
        this.mDatabase = server.mDatabase;
        this.mServer = server;
        ServerConnection serverConnection = this;
        synchronized (serverConnection) {
            this.mThread = mCurrentThread++;
        }
    }

    private Channel init() {
        try {
            this.mSocket.setTcpNoDelay(true);
            this.mInput = new DataInputStream(new BufferedInputStream(this.mSocket.getInputStream()));
            this.mOutput = new DataOutputStream(new BufferedOutputStream(this.mSocket.getOutputStream()));
            String user = this.mInput.readUTF();
            String password = this.mInput.readUTF();
            try {
                this.mServer.trace(String.valueOf(this.mThread) + ":trying to connect user " + user);
                return this.mDatabase.connect(user, password);
            }
            catch (SQLException e) {
                this.write(new Result(e.getMessage()).getBytes());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void run() {
        Channel c = this.init();
        if (c != null) {
            try {
                while (true) {
                    String sql = this.mInput.readUTF();
                    this.mServer.trace(String.valueOf(this.mThread) + ":" + sql);
                    if (sql != null) {
                        this.write(this.mDatabase.execute(sql, c).getBytes());
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.mSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.mDatabase.isShutdown()) {
            System.out.println("The database is shutdown");
            System.exit(0);
        }
    }

    void write(byte[] b) throws IOException {
        this.mOutput.writeInt(b.length);
        this.mOutput.write(b);
        this.mOutput.flush();
    }
}

