/*
 * Decompiled with CFR 0.152.
 */
package org.hsql143;

import java.sql.SQLException;
import org.hsql143.Column;
import org.hsql143.Expression;
import org.hsql143.Record;
import org.hsql143.Result;
import org.hsql143.TableFilter;
import org.hsql143.Trace;

class Select {
    boolean bDistinct;
    TableFilter[] tFilter;
    Expression eCondition;
    Expression[] eColumn;
    int iResultLen;
    int iGroupLen;
    int iOrderLen;
    Select sUnion;
    String sIntoTable;
    int iUnionType;
    static final int UNION = 1;
    static final int UNIONALL = 2;
    static final int INTERSECT = 3;
    static final int EXCEPT = 4;

    Select() {
    }

    void resolve() throws SQLException {
        int len = this.tFilter.length;
        int i = 0;
        while (i < len) {
            this.resolve(this.tFilter[i], true);
            ++i;
        }
    }

    void resolve(TableFilter f, boolean ownfilter) throws SQLException {
        if (this.eCondition != null) {
            this.eCondition.resolve(f);
            if (f != null && ownfilter) {
                f.setCondition(this.eCondition);
            }
        }
        int len = this.eColumn.length;
        int i = 0;
        while (i < len) {
            this.eColumn[i].resolve(f);
            ++i;
        }
    }

    void checkResolved() throws SQLException {
        if (this.eCondition != null) {
            this.eCondition.checkResolved();
        }
        int len = this.eColumn.length;
        int i = 0;
        while (i < len) {
            this.eColumn[i].checkResolved();
            ++i;
        }
    }

    Object getValue(int type) throws SQLException {
        this.resolve();
        Result r = this.getResult(2);
        int size = r.getSize();
        int len = r.getColumnCount();
        Trace.check(size == 1 && len == 1, 16);
        Object o = r.rRoot.data[0];
        if (r.iType[0] == type) {
            return o;
        }
        String s = Column.convertObject(o);
        return Column.convertString(s, type);
    }

    Result getResult(int maxrows) throws SQLException {
        int[] order;
        this.resolve();
        this.checkResolved();
        if (this.sUnion != null && this.sUnion.iResultLen != this.iResultLen) {
            throw Trace.error(4);
        }
        int len = this.eColumn.length;
        Result r = new Result(len);
        boolean aggregated = false;
        boolean grouped = false;
        int i = 0;
        while (i < len) {
            Expression e = this.eColumn[i];
            r.iType[i] = e.getDataType();
            if (e.isAggregate()) {
                aggregated = true;
            }
            ++i;
        }
        Object[] agg = null;
        if (aggregated) {
            agg = new Object[len];
        }
        if (this.iGroupLen > 0) {
            grouped = true;
        }
        boolean simple_maxrows = false;
        simple_maxrows = maxrows != 0 && !grouped && this.sUnion == null && this.iOrderLen == 0;
        int count = 0;
        int filter = this.tFilter.length;
        boolean[] first = new boolean[filter];
        int level = 0;
        while (level >= 0) {
            boolean found;
            TableFilter t = this.tFilter[level];
            first[level] = !first[level] ? (found = t.findFirst()) : (found = t.next());
            if (!found) {
                --level;
                continue;
            }
            if (level < filter - 1) {
                ++level;
                continue;
            }
            if (this.eCondition != null && !this.eCondition.test()) continue;
            Object[] row = new Object[len];
            int i2 = 0;
            while (i2 < len) {
                row[i2] = this.eColumn[i2].getValue();
                ++i2;
            }
            ++count;
            if (aggregated) {
                this.updateAggregateRow(agg, row, len);
                continue;
            }
            r.add(row);
            if (simple_maxrows && count >= maxrows) break;
        }
        if (aggregated && !grouped) {
            this.addAggregateRow(r, agg, len, count);
        } else if (grouped) {
            order = new int[this.iGroupLen];
            int[] way = new int[this.iGroupLen];
            int i3 = this.iResultLen;
            int j = 0;
            while (j < this.iGroupLen) {
                order[j] = i3++;
                way[j] = 1;
                ++j;
            }
            r = Select.sortResult(r, order, way);
            Record n = r.rRoot;
            Result x = new Result(len);
            int i4 = 0;
            while (i4 < len) {
                x.iType[i4] = r.iType[i4];
                ++i4;
            }
            do {
                Object[] row = new Object[len];
                count = 0;
                boolean newgroup = false;
                while (n != null && !newgroup) {
                    ++count;
                    int i5 = 0;
                    while (i5 < this.iGroupLen) {
                        if (n.next == null) {
                            newgroup = true;
                        } else if (Column.compare(n.data[i5], n.next.data[i5], r.iType[i5]) != 0) {
                            newgroup = true;
                        }
                        ++i5;
                    }
                    this.updateAggregateRow(row, n.data, len);
                    n = n.next;
                }
                this.addAggregateRow(x, row, len, count);
            } while (n != null);
            r = x;
        }
        if (this.iOrderLen != 0) {
            order = new int[this.iOrderLen];
            int[] way = new int[this.iOrderLen];
            int i6 = this.iResultLen;
            int j = 0;
            while (j < this.iOrderLen) {
                order[j] = i6;
                way[j] = this.eColumn[i6].isDescending() ? -1 : 1;
                ++i6;
                ++j;
            }
            r = Select.sortResult(r, order, way);
        }
        r.setColumnCount(this.iResultLen);
        if (this.bDistinct) {
            r = Select.removeDuplicates(r);
        }
        int i7 = 0;
        while (i7 < this.iResultLen) {
            Expression e = this.eColumn[i7];
            r.sLabel[i7] = e.getAlias();
            r.sTable[i7] = e.getTableName();
            r.sName[i7] = e.getColumnName();
            ++i7;
        }
        if (this.sUnion != null) {
            Result x = this.sUnion.getResult(0);
            if (this.iUnionType == 1) {
                r.append(x);
                r = Select.removeDuplicates(r);
            } else if (this.iUnionType == 2) {
                r.append(x);
            } else if (this.iUnionType == 3) {
                r = Select.removeDuplicates(r);
                x = Select.removeDuplicates(x);
                r = Select.removeDifferent(r, x);
            } else if (this.iUnionType == 4) {
                r = Select.removeDuplicates(r);
                x = Select.removeDuplicates(x);
                r = Select.removeSecond(r, x);
            }
        }
        if (maxrows > 0 && !simple_maxrows) {
            Select.trimResult(r, maxrows);
        }
        return r;
    }

    private void updateAggregateRow(Object[] row, Object[] n, int len) throws SQLException {
        int i = 0;
        while (i < len) {
            int type = this.eColumn[i].getDataType();
            switch (this.eColumn[i].getType()) {
                case 40: 
                case 41: 
                case 44: {
                    row[i] = Column.sum(row[i], n[i], type);
                    break;
                }
                case 42: {
                    row[i] = Column.min(row[i], n[i], type);
                    break;
                }
                case 43: {
                    row[i] = Column.max(row[i], n[i], type);
                    break;
                }
                default: {
                    row[i] = n[i];
                }
            }
            ++i;
        }
    }

    private void addAggregateRow(Result x, Object[] row, int len, int count) throws SQLException {
        int i = 0;
        while (i < len) {
            int t = this.eColumn[i].getType();
            if (t == 44) {
                row[i] = Column.avg(row[i], this.eColumn[i].getDataType(), count);
            } else if (t == 40 && row[i] == null) {
                row[i] = new Integer(0);
            }
            ++i;
        }
        x.add(row);
    }

    private static Result removeDuplicates(Result r) throws SQLException {
        int len = r.getColumnCount();
        int[] order = new int[len];
        int[] way = new int[len];
        int i = 0;
        while (i < len) {
            order[i] = i;
            way[i] = 1;
            ++i;
        }
        r = Select.sortResult(r, order, way);
        Record n = r.rRoot;
        while (n != null) {
            Record next = n.next;
            if (next == null) break;
            if (Select.compareRecord(n.data, next.data, r, len) == 0) {
                n.next = next.next;
                continue;
            }
            n = n.next;
        }
        return r;
    }

    private static Result removeSecond(Result r, Result minus) throws SQLException {
        int len = r.getColumnCount();
        Record n = r.rRoot;
        Record last = r.rRoot;
        boolean rootr = true;
        Record n2 = minus.rRoot;
        int i = 0;
        while (n != null && n2 != null) {
            i = Select.compareRecord(n.data, n2.data, r, len);
            if (i == 0) {
                if (rootr) {
                    r.rRoot = n.next;
                } else {
                    last.next = n.next;
                }
                n = n.next;
                continue;
            }
            if (i > 0) {
                n2 = n2.next;
                continue;
            }
            last = n;
            rootr = false;
            n = n.next;
        }
        return r;
    }

    private static Result removeDifferent(Result r, Result r2) throws SQLException {
        int len = r.getColumnCount();
        Record n = r.rRoot;
        Record last = r.rRoot;
        boolean rootr = true;
        Record n2 = r2.rRoot;
        int i = 0;
        while (n != null && n2 != null) {
            i = Select.compareRecord(n.data, n2.data, r, len);
            if (i == 0) {
                if (rootr) {
                    r.rRoot = n;
                } else {
                    last.next = n;
                }
                rootr = false;
                last = n;
                n = n.next;
                n2 = n2.next;
                continue;
            }
            if (i > 0) {
                n2 = n2.next;
                continue;
            }
            n = n.next;
        }
        if (rootr) {
            r.rRoot = null;
        } else {
            last.next = null;
        }
        return r;
    }

    private static Result sortResult(Result r, int[] order, int[] way) throws SQLException {
        if (r.rRoot == null || r.rRoot.next == null) {
            return r;
        }
        Record[] target = new Record[2];
        Record[] targetlast = new Record[2];
        int dest = 0;
        Record n = r.rRoot;
        while (n != null) {
            Record next = n.next;
            n.next = target[dest];
            target[dest] = n;
            n = next;
            dest ^= 1;
        }
        int blocksize = 1;
        while (target[1] != null) {
            Record source0 = target[0];
            Record source1 = target[1];
            targetlast[1] = null;
            targetlast[0] = null;
            target[1] = null;
            target[0] = null;
            dest = 0;
            while (source0 != null) {
                int n0 = blocksize;
                int n1 = blocksize;
                while (true) {
                    if (n0 == 0 || source0 == null) {
                        if (n1 == 0 || source1 == null) break;
                        n = source1;
                        source1 = source1.next;
                        --n1;
                    } else if (n1 == 0 || source1 == null) {
                        n = source0;
                        source0 = source0.next;
                        --n0;
                    } else if (Select.compareRecord(source0.data, source1.data, r, order, way) > 0) {
                        n = source1;
                        source1 = source1.next;
                        --n1;
                    } else {
                        n = source0;
                        source0 = source0.next;
                        --n0;
                    }
                    if (target[dest] == null) {
                        target[dest] = n;
                    } else {
                        targetlast[dest].next = n;
                    }
                    targetlast[dest] = n;
                    n.next = null;
                }
                dest ^= 1;
            }
            blocksize <<= 1;
        }
        r.rRoot = target[0];
        return r;
    }

    /*
     * Unable to fully structure code
     */
    private static void trimResult(Result r, int maxrows) {
        n = r.rRoot;
        if (n != null) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            n = n.next;
            if (n != null) continue;
            return;
lbl7:
            // 2 sources

            ** while (--maxrows > 0)
        }
lbl8:
        // 1 sources

        n.next = null;
    }

    private static int compareRecord(Object[] a, Object[] b, Result r, int[] order, int[] way) throws SQLException {
        int i = Column.compare(a[order[0]], b[order[0]], r.iType[order[0]]);
        if (i == 0) {
            int j = 1;
            while (j < order.length) {
                i = Column.compare(a[order[j]], b[order[j]], r.iType[order[j]]);
                if (i != 0) {
                    return i * way[j];
                }
                ++j;
            }
        }
        return i * way[0];
    }

    private static int compareRecord(Object[] a, Object[] b, Result r, int len) throws SQLException {
        int j = 0;
        while (j < len) {
            int i = Column.compare(a[j], b[j], r.iType[j]);
            if (i != 0) {
                return i;
            }
            ++j;
        }
        return 0;
    }
}

