/*
 * Decompiled with CFR 0.152.
 */
package org.hsql143;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import org.hsql143.Column;
import org.hsql143.Node;
import org.hsql143.Table;
import org.hsql143.Trace;

class Row {
    private Object[] oData;
    private Table tTable;
    static int iCurrentAccess = 0;
    int iLastAccess;
    Row rLast;
    Row rNext;
    int iPos;
    int iSize;
    boolean bChanged;
    private Node nFirstIndex;

    Row(Table t, Object[] o) throws SQLException {
        this.tTable = t;
        int index = this.tTable.getIndexCount();
        Node n = this.nFirstIndex = new Node(this, 0);
        int i = 1;
        while (i < index) {
            n = n.nNext = new Node(this, i);
            ++i;
        }
        this.oData = o;
        if (this.tTable != null && this.tTable.cCache != null) {
            this.iLastAccess = iCurrentAccess++;
            this.iSize = 8 + Column.getSize(o, this.tTable) + 32 * this.tTable.getIndexCount();
            this.iSize = (this.iSize + 7) / 8 * 8;
            this.tTable.cCache.add(this);
        }
        this.bChanged = true;
    }

    void cleanUpCache() throws SQLException {
        if (this.tTable != null && this.tTable.cCache != null) {
            this.iLastAccess = iCurrentAccess++;
            this.tTable.cCache.cleanUp();
        }
    }

    void changed() {
        this.bChanged = true;
        this.iLastAccess = iCurrentAccess++;
    }

    Node getNode(int pos, int index) throws SQLException {
        Row r = this.tTable.cCache.getRow(pos, this.tTable);
        r.iLastAccess = iCurrentAccess++;
        return r.getNode(index);
    }

    private Row getRow(int pos) throws SQLException {
        return this.tTable.cCache.getRow(pos, this.tTable);
    }

    Node getNode(int index) {
        Node n = this.nFirstIndex;
        while (index-- > 0) {
            n = n.nNext;
        }
        return n;
    }

    Object[] getData() {
        this.iLastAccess = iCurrentAccess++;
        return this.oData;
    }

    Row(Table t, DataInput in, int pos, Row before) throws IOException, SQLException {
        this.tTable = t;
        int index = this.tTable.getIndexCount();
        this.iPos = pos;
        Node n = this.nFirstIndex = new Node(this, in, 0);
        int i = 1;
        while (i < index) {
            n = n.nNext = new Node(this, in, i);
            ++i;
        }
        int l = this.tTable.getInternalColumnCount();
        this.oData = Column.readData(in, l);
        Trace.check(in.readInt() == this.iPos, 32);
        this.insert(before);
        this.iLastAccess = iCurrentAccess++;
    }

    void insert(Row before) {
        if (before == null) {
            this.rNext = this;
            this.rLast = this;
        } else {
            this.rNext = before;
            this.rLast = before.rLast;
            before.rLast = this;
            this.rLast.rNext = this;
        }
    }

    boolean canRemove() throws SQLException {
        Node n = this.nFirstIndex;
        while (n != null) {
            if (n.iParent == 0 && n.nParent == null) {
                return true;
            }
            n = n.nNext;
        }
        return false;
    }

    byte[] write() throws IOException, SQLException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(this.iSize);
        DataOutputStream out = new DataOutputStream(bout);
        out.writeInt(this.iSize);
        this.nFirstIndex.write(out);
        Column.writeData(out, this.oData, this.tTable);
        out.writeInt(this.iPos);
        this.bChanged = false;
        return bout.toByteArray();
    }

    void delete() throws SQLException {
        if (this.tTable != null && this.tTable.cCache != null) {
            this.bChanged = false;
            this.tTable.cCache.free(this, this.iPos, this.iSize);
        }
    }

    void free() throws SQLException {
        this.rLast.rNext = this.rNext;
        this.rNext.rLast = this.rLast;
        if (this.rNext == this) {
            this.rLast = null;
            this.rNext = null;
        }
    }
}

