/*
 * Decompiled with CFR 0.152.
 */
package org.hsql143;

import java.util.Enumeration;
import java.util.Hashtable;

public class Profile {
    static Profile main = new Profile();
    static final int TOP = 20;
    static final int VISIT = 0;
    static final int TIME = 1;
    static final int PERCALL = 2;
    Hashtable hash = new Hashtable();
    boolean bVisited;
    boolean bStop;
    File fLastFile;
    int iLastLine;
    long lLastTime = System.currentTimeMillis();

    public static void visit(String file, int line, int maxline) {
        main.m_visit(file, line, maxline);
    }

    public static void listUnvisited() {
        main.m_listUnvisited();
    }

    void m_visit(String file, int line, int maxline) {
        if (this.bStop) {
            return;
        }
        this.bVisited = true;
        File f = (File)this.hash.get(file);
        if (f == null) {
            f = new File(file, maxline);
            this.hash.put(file, f);
        }
        f.visit(line);
    }

    void m_listUnvisited() {
        this.bStop = true;
        if (!this.bVisited) {
            return;
        }
        Enumeration e = this.hash.keys();
        this.printline('=');
        this.print("UNVISITED");
        this.printline('-');
        int total = 0;
        int unvisited = 0;
        while (e.hasMoreElements()) {
            String file = (String)e.nextElement();
            File f = (File)this.hash.get(file);
            int maxline = f.iMaxLine;
            total += maxline;
            int l = 0;
            while (l < maxline) {
                if (f.val[l][0] == 0L) {
                    int lto = l + 1;
                    while (lto < maxline) {
                        ++unvisited;
                        if (f.val[lto][0] != 0L) break;
                        ++lto;
                    }
                    if (l == lto - 1) {
                        this.print(String.valueOf(file) + " " + l);
                    } else {
                        this.print(String.valueOf(file) + " " + l + " - " + (lto - 1));
                    }
                    l = lto;
                } else {
                    f.val[l][2] = f.val[l][1] / f.val[l][0];
                }
                ++l;
            }
        }
        this.printline('-');
        this.print("Total    : " + total);
        this.print("Unvisited: " + 100 * unvisited / total + " %");
        this.printTimePerFile();
        this.printHigh("MOST VISITS", 0);
        this.printHigh("LONGEST RUN", 1);
        this.printHigh("LONGEST PER CALL", 2);
        this.printline('=');
    }

    void printTimePerFile() {
        Enumeration e = this.hash.keys();
        this.printline('-');
        this.print("TIME PER FILE");
        this.printline('-');
        int total = 0;
        while (e.hasMoreElements()) {
            String file = (String)e.nextElement();
            File f = (File)this.hash.get(file);
            int time = 0;
            int maxline = f.iMaxLine;
            int l = 0;
            while (l < maxline) {
                time = (int)((long)time + f.val[l][1]);
                ++l;
            }
            this.print(String.valueOf(time) + "\t" + file);
            total += time;
        }
        this.printline('-');
        this.print("Total time: " + total);
    }

    void printHigh(String name, int type) {
        this.printline('-');
        this.print(name);
        this.printline('-');
        int i = 0;
        while (i < 20) {
            File topfile = null;
            int topline = -1;
            long top = -1L;
            Enumeration e = this.hash.keys();
            while (e.hasMoreElements()) {
                String file = (String)e.nextElement();
                File f = (File)this.hash.get(file);
                int maxline = f.iMaxLine;
                int l = 0;
                while (l < maxline) {
                    long v = f.val[l][type];
                    if (v > top) {
                        topfile = f;
                        topline = l;
                        top = v;
                    }
                    ++l;
                }
            }
            this.print(String.valueOf(top) + "\t" + topline + "\t" + topfile.sName);
            topfile.val[topline][type] = -1L;
            ++i;
        }
    }

    void print(String s) {
        System.out.println(s);
    }

    void printline(char c) {
        int i = 0;
        while (i < 60) {
            System.out.print(c);
            ++i;
        }
        this.print("");
    }

    class File {
        String sName;
        int iMaxLine;
        long[][] val;

        File(String name, int max) {
            this.sName = name;
            this.iMaxLine = max;
            this.val = new long[this.iMaxLine][3];
        }

        void visit(int line) {
            long[] lArray = this.val[line];
            lArray[0] = lArray[0] + 1L;
            long time = System.currentTimeMillis();
            if (Profile.this.fLastFile != null) {
                long[] lArray2 = Profile.this.fLastFile.val[Profile.this.iLastLine];
                lArray2[1] = lArray2[1] + (time - Profile.this.lLastTime);
            }
            Profile.this.fLastFile = this;
            Profile.this.iLastLine = line;
            Profile.this.lLastTime = time;
        }
    }
}

