/*
 * Decompiled with CFR 0.152.
 */
package org.hsql143;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import org.hsql143.Row;

class Node {
    int iBalance;
    int iLeft;
    int iRight;
    int iParent;
    Node nLeft;
    Node nRight;
    Node nParent;
    private int iId;
    Node nNext;
    Row rData;

    Node(Row r, DataInput in, int id) throws IOException, SQLException {
        this.iId = id;
        this.rData = r;
        this.iBalance = in.readInt();
        this.iLeft = in.readInt();
        this.iRight = in.readInt();
        this.iParent = in.readInt();
    }

    Node(Row r, int id) {
        this.iId = id;
        this.rData = r;
    }

    void delete() {
        this.iBalance = -2;
        this.nParent = null;
        this.nRight = null;
        this.nLeft = null;
        this.iParent = 0;
        this.iRight = 0;
        this.iLeft = 0;
    }

    int getKey() {
        return this.rData.iPos;
    }

    Node getLeft() throws SQLException {
        if (this.iLeft == 0) {
            return this.nLeft;
        }
        return this.rData.getNode(this.iLeft, this.iId);
    }

    void setLeft(Node n) throws SQLException {
        this.rData.changed();
        if (n == null) {
            this.iLeft = 0;
            this.nLeft = null;
        } else if (n.rData.iPos != 0) {
            this.iLeft = n.rData.iPos;
        } else {
            this.nLeft = n;
        }
    }

    Node getRight() throws SQLException {
        if (this.iRight == 0) {
            return this.nRight;
        }
        return this.rData.getNode(this.iRight, this.iId);
    }

    void setRight(Node n) throws SQLException {
        this.rData.changed();
        if (n == null) {
            this.iRight = 0;
            this.nRight = null;
        } else if (n.rData.iPos != 0) {
            this.iRight = n.rData.iPos;
        } else {
            this.nRight = n;
        }
    }

    Node getParent() throws SQLException {
        if (this.iParent == 0) {
            return this.nParent;
        }
        return this.rData.getNode(this.iParent, this.iId);
    }

    void setParent(Node n) throws SQLException {
        this.rData.changed();
        if (n == null) {
            this.iParent = 0;
            this.nParent = null;
        } else if (n.rData.iPos != 0) {
            this.iParent = n.rData.iPos;
        } else {
            this.nParent = n;
        }
    }

    int getBalance() throws SQLException {
        return this.iBalance;
    }

    void setBalance(int b) throws SQLException {
        if (this.iBalance != b) {
            this.rData.changed();
            this.iBalance = b;
        }
    }

    public Object[] getData() throws SQLException {
        return this.rData.getData();
    }

    boolean equals(Node n) throws SQLException {
        return n == this;
    }

    void write(DataOutput out) throws IOException, SQLException {
        out.writeInt(this.iBalance);
        out.writeInt(this.iLeft);
        out.writeInt(this.iRight);
        out.writeInt(this.iParent);
        if (this.nNext != null) {
            this.nNext.write(out);
        }
    }
}

