/*
 * Decompiled with CFR 0.152.
 */
package org.hsql143;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Vector;
import org.hsql143.Channel;
import org.hsql143.Database;
import org.hsql143.Index;
import org.hsql143.Node;
import org.hsql143.Record;
import org.hsql143.Result;
import org.hsql143.StringConverter;
import org.hsql143.Table;
import org.hsql143.Trace;

class LogM {
    private Database dDatabase;
    public Channel cSystem;

    public LogM(Database db, Channel system) throws SQLException {
        this.dDatabase = db;
        this.cSystem = system;
    }

    String scriptToString(boolean full) throws SQLException {
        Database db = this.dDatabase;
        Channel channel = this.cSystem;
        StringWriter w = new StringWriter();
        try {
            long time = System.currentTimeMillis();
            Result r = full ? db.getScript(false, false, false, channel) : db.getScript(false, false, true, channel);
            Record n = r.rRoot;
            while (n != null) {
                LogM.writeLine(w, (String)n.data[0]);
                n = n.next;
            }
            Vector tables = db.getTables();
            int i = 0;
            while (i < tables.size()) {
                Table t = (Table)tables.elementAt(i);
                if (full || !t.isCached()) {
                    Index primary = t.getPrimaryIndex();
                    Node x = primary.first();
                    while (x != null) {
                        LogM.writeLine(w, t.getInsertStatement(x.getData()));
                        x = primary.next(x);
                    }
                }
                ++i;
            }
            w.close();
            time = System.currentTimeMillis() - time;
        }
        catch (IOException e) {
            Trace.error(28, e.getMessage());
        }
        return w.toString();
    }

    public void ImportFromString(String source) throws SQLException {
        StringReader sr = new StringReader(source);
        this.dDatabase.setReferentialIntegrity(false);
        Vector<Channel> channel = new Vector<Channel>();
        channel.addElement(this.cSystem);
        Channel current = this.cSystem;
        int size = 1;
        try {
            String s;
            long time = System.currentTimeMillis();
            LineNumberReader r = new LineNumberReader(sr);
            while ((s = LogM.readLine(r)) != null) {
                int id;
                if (s.startsWith("/*C")) {
                    id = Integer.parseInt(s.substring(3, s.indexOf(42, 4)));
                    if (id >= size) {
                        channel.setSize(id + 1);
                    }
                    if ((current = (Channel)channel.elementAt(id)) == null) {
                        current = new Channel(this.cSystem, id);
                        channel.setElementAt(current, id);
                        this.dDatabase.registerChannel(current);
                    }
                    s = s.substring(s.indexOf(47, 1) + 1);
                }
                if (!s.equals("")) {
                    try {
                        this.dDatabase.execute(s, current);
                    }
                    catch (Exception e) {
                        System.out.println("\u9519\u8bef\uff1a" + e.getMessage());
                    }
                }
                if (!s.equals("DISCONNECT")) continue;
                id = current.getId();
                current = new Channel(this.cSystem, id);
                channel.setElementAt(current, id);
            }
            r.close();
            int i = 0;
            while (i < size) {
                current = (Channel)channel.elementAt(i);
                if (current != null) {
                    current.rollback();
                }
                ++i;
            }
            time = System.currentTimeMillis() - time;
        }
        catch (IOException e) {
            throw Trace.error(28, e.getMessage());
        }
        this.dDatabase.setReferentialIntegrity(true);
    }

    private static void writeLine(Writer w, String s) throws IOException {
        w.write(String.valueOf(StringConverter.unicodeToAscii(s)) + "\r\n");
    }

    private static String readLine(LineNumberReader r) throws IOException {
        String s = r.readLine();
        return StringConverter.asciiToUnicode(s);
    }
}

