/*
 * Decompiled with CFR 0.152.
 */
package org.hsql143;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Random;

class Library {
    static final String[] sNumeric = new String[]{"ABS", "java.lang.Math.abs", "ACOS", "java.lang.Math.acos", "ASIN", "java.lang.Math.asin", "ATAN", "java.lang.Math.atan", "ATAN2", "java.lang.Math.atan2", "CEILING", "java.lang.Math.ceil", "COS", "java.lang.Math.cos", "COT", "org.hsql.Library.cot", "DEGREES", "java.lang.Math.toDegrees", "EXP", "java.lang.Math.exp", "FLOOR", "java.lang.Math.floor", "LOG", "java.lang.Math.log", "LOG10", "org.hsql.Library.log10", "MOD", "org.hsql.Library.mod", "PI", "org.hsql.Library.pi", "POWER", "java.lang.Math.pow", "RADIANS", "java.lang.Math.toRadians", "RAND", "java.lang.Math.random", "ROUND", "org.hsql.Library.round", "SIGN", "org.hsql.Library.sign", "SIN", "java.lang.Math.sin", "SQRT", "java.lang.Math.sqrt", "TAN", "java.lang.Math.tan", "TRUNCATE", "org.hsql.Library.truncate", "BITAND", "org.hsql.Library.bitand", "BITOR", "org.hsql.Library.bitor", "ROUNDMAGIC", "org.hsql.Library.roundMagic"};
    static final String[] sString = new String[]{"ASCII", "org.hsql.Library.ascii", "CHAR", "org.hsql.Library.character", "CONCAT", "org.hsql.Library.concat", "DIFFERENCE", "org.hsql.Library.difference", "INSERT", "org.hsql.Library.insert", "LCASE", "org.hsql.Library.lcase", "LEFT", "org.hsql.Library.left", "LENGTH", "org.hsql.Library.length", "LOCATE", "org.hsql.Library.locate", "LTRIM", "org.hsql.Library.ltrim", "REPEAT", "org.hsql.Library.repeat", "REPLACE", "org.hsql.Library.replace", "RIGHT", "org.hsql.Library.right", "RTRIM", "org.hsql.Library.rtrim", "SOUNDEX", "org.hsql.Library.soundex", "SPACE", "org.hsql.Library.space", "SUBSTRING", "org.hsql.Library.substring", "UCASE", "org.hsql.Library.ucase", "LOWER", "org.hsql.Library.lcase", "UPPER", "org.hsql.Library.ucase"};
    static final String[] sTimeDate = new String[]{"CURDATE", "org.hsql.Library.curdate", "CURTIME", "org.hsql.Library.curtime", "DAYNAME", "org.hsql.Library.dayname", "DAYOFMONTH", "org.hsql.Library.dayofmonth", "DAYOFWEEK", "org.hsql.Library.dayofweek", "DAYOFYEAR", "org.hsql.Library.dayofyear", "HOUR", "org.hsql.Library.hour", "MINUTE", "org.hsql.Library.minute", "MONTH", "org.hsql.Library.month", "MONTHNAME", "org.hsql.Library.monthname", "NOW", "org.hsql.Library.now", "QUARTER", "org.hsql.Library.quarter", "SECOND", "org.hsql.Library.second", "WEEK", "org.hsql.Library.week", "YEAR", "org.hsql.Library.year"};
    static final String[] sSystem = new String[]{"DATABASE", "org.hsql.Library.database", "USER", "org.hsql.Library.user", "IDENTITY", "org.hsql.Library.identity"};
    static Random rRandom = new Random();
    static double LOG10_FACTOR = 0.4342944819032518;

    Library() {
    }

    static void register(Hashtable h) {
        Library.register(h, sNumeric);
        Library.register(h, sString);
        Library.register(h, sTimeDate);
        Library.register(h, sSystem);
    }

    private static void register(Hashtable h, String[] s) {
        int i = 0;
        while (i < s.length) {
            h.put(s[i], s[i + 1]);
            i += 2;
        }
    }

    public static double rand(Integer i) {
        if (i != null) {
            rRandom.setSeed(i.intValue());
        }
        return rRandom.nextDouble();
    }

    public static double log10(double x) {
        return Library.roundMagic(Math.log(x) * LOG10_FACTOR);
    }

    public static double roundMagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuffer s = new StringBuffer();
        s.append(d);
        int len = s.length();
        if (len < 16) {
            return d;
        }
        char cx = s.charAt(len - 1);
        char c1 = s.charAt(len - 2);
        char c2 = s.charAt(len - 3);
        char c3 = s.charAt(len - 4);
        if (c1 == '0' && c2 == '0' && c3 == '0' && cx != '.') {
            s.setCharAt(len - 1, '0');
        } else if (c1 == '9' && c2 == '9' && c3 == '9' && cx != '.') {
            s.setCharAt(len - 1, '9');
            s.append('9');
            s.append('9');
        }
        return new Double(s.toString());
    }

    public static double cot(double d) {
        return 1.0 / Math.tan(d);
    }

    public static int mod(int i1, int i2) {
        return i1 % i2;
    }

    public static double pi() {
        return Math.PI;
    }

    public static double round(double d, int p) {
        double f = Math.pow(10.0, p);
        return (double)Math.round(d * f) / f;
    }

    public static int sign(double d) {
        return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
    }

    public static double truncate(double d, int p) {
        double f = Math.pow(10.0, p);
        double g = d * f;
        return (d < 0.0 ? Math.ceil(g) : Math.floor(g)) / f;
    }

    public static int bitand(int i, int j) {
        return i & j;
    }

    public static int bitor(int i, int j) {
        return i | j;
    }

    public static Integer ascii(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        return new Integer(s.charAt(0));
    }

    public static String character(int code) {
        return "" + (char)code;
    }

    public static String concat(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return null;
            }
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        return String.valueOf(s1) + s2;
    }

    public static int difference(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return 0;
        }
        s1 = Library.soundex(s1);
        s2 = Library.soundex(s2);
        int len1 = s1.length();
        int len2 = s2.length();
        int e = 0;
        int i = 0;
        while (i < 4) {
            if (i >= len1 || i >= len2 || s1.charAt(i) != s2.charAt(i)) {
                ++e;
            }
            ++i;
        }
        return e;
    }

    public static String insert(String s1, int start, int length, String s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        if (--start < 0 || length <= 0 || len2 == 0 || start > len1) {
            return s1;
        }
        if (start + length > len1) {
            length = len1 - start;
        }
        return String.valueOf(s1.substring(0, start)) + s2 + s1.substring(start + length);
    }

    public static String lcase(String s) {
        return s == null ? null : s.toLowerCase();
    }

    public static String left(String s, int i) {
        return s == null ? null : s.substring(0, i < 0 ? 0 : (i < s.length() ? i : s.length()));
    }

    public static int length(String s) {
        return s == null || s.length() < 1 ? 0 : s.length();
    }

    public static int locate(String search, String s, Integer start) {
        if (s == null || search == null) {
            return 0;
        }
        int i = start == null ? 0 : start - 1;
        return s.indexOf(search, i < 0 ? 0 : i) + 1;
    }

    public static String ltrim(String s) {
        if (s == null) {
            return s;
        }
        int len = s.length();
        int i = 0;
        while (i < len && s.charAt(i) <= ' ') {
            ++i;
        }
        return i == 0 ? s : s.substring(i);
    }

    public static String repeat(String s, int i) {
        if (s == null) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        while (i-- > 0) {
            b.append(s);
        }
        return b.toString();
    }

    public static String replace(String s, String replace, String with) {
        if (s == null || replace == null) {
            return s;
        }
        if (with == null) {
            with = "";
        }
        StringBuffer b = new StringBuffer();
        int start = 0;
        int lenreplace = replace.length();
        while (true) {
            int i;
            if ((i = s.indexOf(replace, start)) == -1) break;
            b.append(s.substring(start, i - start));
            b.append(with);
            start = i + lenreplace;
        }
        b.append(s.substring(start));
        return b.toString();
    }

    public static String right(String s, int i) {
        if (s == null) {
            return null;
        }
        i = s.length() - i;
        return s.substring(i < 0 ? 0 : (i < s.length() ? i : s.length()));
    }

    public static String rtrim(String s) {
        if (s == null) {
            return s;
        }
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) <= ' ') {
            --i;
        }
        return i == s.length() ? s : s.substring(0, i + 1);
    }

    public static String soundex(String s) {
        if (s == null) {
            return s;
        }
        s = s.toUpperCase();
        int len = s.length();
        char[] b = new char[4];
        b[0] = s.charAt(0);
        int j = 1;
        int i = 1;
        while (i < len && j < 4) {
            char c = s.charAt(i);
            if ("BFPV".indexOf(c) != -1) {
                b[j++] = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                b[j++] = 50;
            } else if (c == 'D' || c == 'T') {
                b[j++] = 51;
            } else if (c == 'L') {
                b[j++] = 52;
            } else if (c == 'M' || c == 'N') {
                b[j++] = 53;
            } else if (c == 'R') {
                b[j++] = 54;
            }
            ++i;
        }
        return new String(b, 0, j);
    }

    public static String space(int i) {
        if (i < 0) {
            return null;
        }
        char[] c = new char[i];
        while (i > 0) {
            c[--i] = 32;
        }
        return new String(c);
    }

    public static String substring(String s, int start, Integer length) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        int n = start = --start > len ? len : start;
        if (length == null) {
            return s.substring(start);
        }
        int l = length;
        return s.substring(start, start + l > len ? len : l);
    }

    public static String ucase(String s) {
        return s == null ? null : s.toUpperCase();
    }

    public static java.sql.Date curdate() {
        return new java.sql.Date(System.currentTimeMillis());
    }

    public static Time curtime() {
        return new Time(System.currentTimeMillis());
    }

    public static String dayname(java.sql.Date d) {
        SimpleDateFormat f = new SimpleDateFormat("EEEE");
        return f.format(d).toString();
    }

    private static int getDateTimePart(Date d, int part) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(d);
        return c.get(part);
    }

    private static int getTimePart(Time t, int part) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(t);
        return c.get(part);
    }

    public static int dayofmonth(java.sql.Date d) {
        return Library.getDateTimePart(d, 5);
    }

    public static int dayofweek(java.sql.Date d) {
        return Library.getDateTimePart(d, 7);
    }

    public static int dayofyear(java.sql.Date d) {
        return Library.getDateTimePart(d, 6);
    }

    public static int hour(Time t) {
        return Library.getDateTimePart(t, 10);
    }

    public static int minute(Time t) {
        return Library.getDateTimePart(t, 12);
    }

    public static int month(java.sql.Date d) {
        return Library.getDateTimePart(d, 2);
    }

    public static String monthname(java.sql.Date d) {
        SimpleDateFormat f = new SimpleDateFormat("MMMM");
        return f.format(d).toString();
    }

    public static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static int quarter(java.sql.Date d) {
        return Library.getDateTimePart(d, 2) / 3 + 1;
    }

    public static int second(java.sql.Date d) {
        return Library.getDateTimePart(d, 13);
    }

    public static int week(java.sql.Date d) {
        return Library.getDateTimePart(d, 3);
    }

    public static int year(java.sql.Date d) {
        return Library.getDateTimePart(d, 1);
    }

    public static String database(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        String s = "SELECT Value FROM SYSTEM_CONNECTIONINFO WHERE KEY='DATABASE'";
        ResultSet r = stat.executeQuery(s);
        r.next();
        return r.getString(1);
    }

    public static String user(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        String s = "SELECT Value FROM SYSTEM_CONNECTIONINFO WHERE KEY='USER'";
        ResultSet r = stat.executeQuery(s);
        r.next();
        return r.getString(1);
    }

    public static int identity(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        String s = "SELECT VALUE FROM SYSTEM_CONNECTIONINFO WHERE KEY='IDENTITY'";
        ResultSet r = stat.executeQuery(s);
        r.next();
        return r.getInt(1);
    }
}

