/*
 * Decompiled with CFR 0.152.
 */
package org.hsql143;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hsql143.Access;
import org.hsql143.Channel;
import org.hsql143.Column;
import org.hsql143.Constraint;
import org.hsql143.Database;
import org.hsql143.Index;
import org.hsql143.Node;
import org.hsql143.Result;
import org.hsql143.Table;
import org.hsql143.User;

class DatabaseInformation {
    private Database dDatabase;
    private Access aAccess;
    private Vector tTable;
    static final String META_SCHEM = "SCHEM";
    static final String META_CAT = "CAT";
    static final String META_COLUMN_SIZE = "COLUMN_SIZE";
    static final String META_BUFFER_LENGTH = "BUFFER_LENGTH";
    static final String META_DECIMAL_DIGITS = "DECIMAL_DIGITS";
    static final String META_NUM_PREC_RADIX = "NUM_PREC_RADIX";
    static final String META_FIXED_PREC_SCALE = "FIXED_PREC_SCALE";
    static final String META_ORDINAL_POSITON = "ORDINAL_POSITON";
    static final String META_ASC_OR_DESC = "ASC_OR_DESC";

    DatabaseInformation(Database db, Vector tables, Access access) {
        this.dDatabase = db;
        this.tTable = tables;
        this.aAccess = access;
    }

    Table getSystemTable(String name, Channel channel) throws SQLException {
        if (name.equals("SYSTEM_PROCEDURES")) {
            Table t = this.createTable(name);
            t.addColumn("PROCEDURE_CAT", 12);
            t.addColumn("PROCEDURE_SCHEM", 12);
            t.addColumn("PROCEDURE_NAME", 12);
            t.addColumn("NUM_INPUT_PARAMS", 4);
            t.addColumn("NUM_OUTPUT_PARAMS", 4);
            t.addColumn("NUM_RESULT_SETS", 4);
            t.addColumn("REMARKS", 12);
            t.addColumn("PROCEDURE_TYPE", 5);
            t.createPrimaryKey();
            return t;
        }
        if (name.equals("SYSTEM_PROCEDURECOLUMNS")) {
            Table t = this.createTable(name);
            t.addColumn("PROCEDURE_CAT", 12);
            t.addColumn("PROCEDURE_SCHEM", 12);
            t.addColumn("PROCEDURE_NAME", 12);
            t.addColumn("COLUMN_NAME", 12);
            t.addColumn("COLUMN_TYPE", 5);
            t.addColumn("DATA_TYPE", 5);
            t.addColumn("TYPE_NAME", 12);
            t.addColumn("PRECISION", 4);
            t.addColumn("LENGTH", 4);
            t.addColumn("SCALE", 5);
            t.addColumn("RADIX", 5);
            t.addColumn("NULLABLE", 5);
            t.addColumn("REMARKS", 12);
            t.createPrimaryKey();
            return t;
        }
        if (name.equals("SYSTEM_TABLES")) {
            Table t = this.createTable(name);
            t.addColumn("TABLE_CAT", 12);
            t.addColumn("TABLE_SCHEM", 12);
            t.addColumn("TABLE_NAME", 12);
            t.addColumn("TABLE_TYPE", 12);
            t.addColumn("REMARKS", 12);
            t.createPrimaryKey();
            int i = 0;
            while (i < this.tTable.size()) {
                Table table = (Table)this.tTable.elementAt(i);
                Object[] o = t.getNewRow();
                o[2] = table.getName();
                o[3] = "TABLE";
                t.insert(o, null);
                ++i;
            }
            return t;
        }
        if (name.equals("SYSTEM_SCHEMAS")) {
            Table t = this.createTable(name);
            t.addColumn("TABLE_SCHEM", 12);
            t.createPrimaryKey();
            return t;
        }
        if (name.equals("SYSTEM_CATALOGS")) {
            Table t = this.createTable(name);
            t.addColumn("TABLE_CAT", 12);
            t.createPrimaryKey();
            return t;
        }
        if (name.equals("SYSTEM_TABLETYPES")) {
            Table t = this.createTable(name);
            t.addColumn("TABLE_TYPE", 12);
            t.createPrimaryKey();
            Object[] o = t.getNewRow();
            o[0] = "TABLE";
            t.insert(o, null);
            return t;
        }
        if (name.equals("SYSTEM_COLUMNS")) {
            Table t = this.createTable(name);
            t.addColumn("TABLE_CAT", 12);
            t.addColumn("TABLE_SCHEM", 12);
            t.addColumn("TABLE_NAME", 12);
            t.addColumn("COLUMN_NAME", 12);
            t.addColumn("DATA_TYPE", 5);
            t.addColumn("TYPE_NAME", 12);
            t.addColumn(META_COLUMN_SIZE, 4);
            t.addColumn(META_BUFFER_LENGTH, 4);
            t.addColumn(META_DECIMAL_DIGITS, 4);
            t.addColumn(META_NUM_PREC_RADIX, 4);
            t.addColumn("NULLABLE", 4);
            t.addColumn("REMARKS", 12);
            t.addColumn("COLUMN_DEF", 12);
            t.addColumn("SQL_DATA_TYPE", 12);
            t.addColumn("SQL_DATETIME_SUB", 4);
            t.addColumn("CHAR_OCTET_LENGTH", 4);
            t.addColumn("ORDINAL_POSITION", 12);
            t.addColumn("IS_NULLABLE", 12);
            t.createPrimaryKey();
            int i = 0;
            while (i < this.tTable.size()) {
                Table table = (Table)this.tTable.elementAt(i);
                int columns = table.getColumnCount();
                int j = 0;
                while (j < columns) {
                    Object[] o = t.getNewRow();
                    o[2] = table.getName();
                    o[3] = table.getColumnName(j);
                    o[4] = new Short((short)table.getColumnType(j));
                    o[5] = Column.getType(table.getColumnType(j));
                    int nullable = table.getColumnIsNullable(j) ? 1 : 0;
                    o[10] = new Integer(nullable);
                    if (table.getIdentityColumn() == j) {
                        o[11] = "IDENDITY";
                    }
                    t.insert(o, null);
                    ++j;
                }
                ++i;
            }
            return t;
        }
        if (name.equals("SYSTEM_COLUMNPRIVILEGES")) {
            Table t = this.createTable(name);
            t.addColumn("TABLE_CAT", 12);
            t.addColumn("TABLE_SCHEM", 12);
            t.addColumn("TABLE_NAME", 12);
            t.addColumn("COLUMN_NAME", 12);
            t.addColumn("GRANTOR", 12);
            t.addColumn("GRANTEE", 12);
            t.addColumn("PRIVILEGE", 12);
            t.addColumn("IS_GRANTABLE", 12);
            t.createPrimaryKey();
            return t;
        }
        if (name.equals("SYSTEM_TABLEPRIVILEGES")) {
            Table t = this.createTable(name);
            t.addColumn("TABLE_CAT", 12);
            t.addColumn("TABLE_SCHEM", 12);
            t.addColumn("TABLE_NAME", 12);
            t.addColumn("GRANTOR", 12);
            t.addColumn("GRANTEE", 12);
            t.addColumn("PRIVILEGE", 12);
            t.addColumn("IS_GRANTABLE", 12);
            t.createPrimaryKey();
            int i = 0;
            while (i < this.tTable.size()) {
                Table table = (Table)this.tTable.elementAt(i);
                Object[] o = t.getNewRow();
                o[2] = table.getName();
                o[3] = "sa";
                o[5] = "FULL";
                t.insert(o, null);
                ++i;
            }
            return t;
        }
        if (name.equals("SYSTEM_BESTROWIDENTIFIER")) {
            Table t = this.createTable(name);
            t.addColumn("SCOPE", 5);
            t.addColumn("COLUMN_NAME", 12);
            t.addColumn("DATA_TYPE", 5);
            t.addColumn("TYPE_NAME", 12);
            t.addColumn(META_COLUMN_SIZE, 4);
            t.addColumn(META_BUFFER_LENGTH, 4);
            t.addColumn(META_DECIMAL_DIGITS, 5);
            t.addColumn("PSEUDO_COLUMN", 5);
            t.createPrimaryKey();
            return t;
        }
        if (name.equals("SYSTEM_VERSIONCOLUMNS")) {
            Table t = this.createTable(name);
            t.addColumn("SCOPE", 4);
            t.addColumn("COLUMN_NAME", 12);
            t.addColumn("DATA_TYPE", 5);
            t.addColumn("TYPE_NAME", 12);
            t.addColumn(META_COLUMN_SIZE, 5);
            t.addColumn(META_BUFFER_LENGTH, 4);
            t.addColumn(META_DECIMAL_DIGITS, 5);
            t.addColumn("PSEUDO_COLUMN", 5);
            t.createPrimaryKey();
            return t;
        }
        if (name.equals("SYSTEM_PRIMARYKEYS")) {
            Table t = this.createTable(name);
            t.addColumn("TABLE_CAT", 12);
            t.addColumn("TABLE_SCHEM", 12);
            t.addColumn("TABLE_NAME", 12);
            t.addColumn("COLUMN_NAME", 12);
            t.addColumn("KEY_SEQ", 5);
            t.addColumn("PK_NAME", 12);
            t.createPrimaryKey();
            int i = 0;
            while (i < this.tTable.size()) {
                Table table = (Table)this.tTable.elementAt(i);
                Index index = table.getIndex("SYSTEM_PK");
                int[] cols = index.getColumns();
                int len = cols.length;
                int j = 0;
                while (j < len) {
                    Object[] o = t.getNewRow();
                    o[2] = table.getName();
                    o[3] = table.getColumnName(cols[j]);
                    o[4] = new Short((short)(j + 1));
                    o[5] = "SYSTEM_PK";
                    t.insert(o, null);
                    ++j;
                }
                ++i;
            }
            return t;
        }
        if (name.equals("SYSTEM_IMPORTEDKEYS")) {
            Table t = this.createTable(name);
            t.addColumn("PKTABLE_CAT", 12);
            t.addColumn("PKTABLE_SCHEM", 12);
            t.addColumn("PKTABLE_NAME", 12);
            t.addColumn("PKCOLUMN_NAME", 12);
            t.addColumn("FKTABLE_CAT", 12);
            t.addColumn("FKTABLE_SCHEM", 12);
            t.addColumn("FKTABLE_NAME", 12);
            t.addColumn("FKCOLUMN_NAME", 12);
            t.addColumn("KEY_SEQ", 5);
            t.addColumn("UPDATE_RULE", 5);
            t.addColumn("DELETE_RULE", 5);
            t.addColumn("FK_NAME", 12);
            t.addColumn("PK_NAME", 12);
            t.addColumn("DEFERRABILITY", 5);
            t.createPrimaryKey();
            return t;
        }
        if (name.equals("SYSTEM_EXPORTEDKEYS")) {
            Table t = this.createTable(name);
            t.addColumn("PKTABLE_CAT", 12);
            t.addColumn("PKTABLE_SCHEM", 12);
            t.addColumn("PKTABLE_NAME", 12);
            t.addColumn("PKCOLUMN_NAME", 12);
            t.addColumn("FKTABLE_CAT", 12);
            t.addColumn("FKTABLE_SCHEM", 12);
            t.addColumn("FKTABLE_NAME", 12);
            t.addColumn("FKCOLUMN_NAME", 12);
            t.addColumn("KEY_SEQ", 5);
            t.addColumn("UPDATE_RULE", 5);
            t.addColumn("DELETE_RULE", 5);
            t.addColumn("FK_NAME", 12);
            t.addColumn("PK_NAME", 12);
            t.addColumn("DEFERRABILITY", 5);
            t.createPrimaryKey();
            return t;
        }
        if (name.equals("SYSTEM_CROSSREFERENCE")) {
            Table t = this.createTable(name);
            t.addColumn("PKTABLE_CAT", 12);
            t.addColumn("PKTABLE_SCHEM", 12);
            t.addColumn("PKTABLE_NAME", 12);
            t.addColumn("PKCOLUMN_NAME", 12);
            t.addColumn("FKTABLE_CAT", 12);
            t.addColumn("FKTABLE_SCHEM", 12);
            t.addColumn("FKTABLE_NAME", 12);
            t.addColumn("FKCOLUMN_NAME", 12);
            t.addColumn("KEY_SEQ", 4);
            t.addColumn("UPDATE_RULE", 5);
            t.addColumn("DELETE_RULE", 5);
            t.addColumn("FK_NAME", 12);
            t.addColumn("PK_NAME", 12);
            t.addColumn("DEFERRABILITY", 5);
            t.createPrimaryKey();
            return t;
        }
        if (name.equals("SYSTEM_TYPEINFO")) {
            Table t = this.createTable(name);
            t.addColumn("TYPE_NAME", 12);
            t.addColumn("DATA_TYPE", 5);
            t.addColumn("PRECISION", 4);
            t.addColumn("LITERAL_PREFIX", 12);
            t.addColumn("LITERAL_SUFFIX", 12);
            t.addColumn("CREATE_PARAMS", 12);
            t.addColumn("NULLABLE", 5);
            t.addColumn("CASE_SENSITIVE", 12);
            t.addColumn("SEARCHABLE", 5);
            t.addColumn("UNSIGNED_ATTRIBUTE", -7);
            t.addColumn(META_FIXED_PREC_SCALE, -7);
            t.addColumn("AUTO_INCREMENT", -7);
            t.addColumn("LOCAL_TYPE_NAME", 12);
            t.addColumn("MINIMUM_SCALE", 5);
            t.addColumn("MAXIMUM_SCALE", 5);
            t.addColumn("SQL_DATE_TYPE", 4);
            t.addColumn("SQL_DATETIME_SUB", 4);
            t.addColumn(META_NUM_PREC_RADIX, 4);
            t.createPrimaryKey();
            int i = 0;
            while (i < Column.TYPES.length) {
                Object[] o = t.getNewRow();
                int type = Column.TYPES[i];
                o[0] = Column.getType(type);
                o[1] = new Short((short)type);
                o[2] = new Integer(0);
                o[6] = new Short(1);
                o[7] = new Boolean(true);
                o[8] = new Short(3);
                o[9] = new Boolean(false);
                o[10] = new Boolean(type == 2 || type == 3);
                o[11] = new Boolean(type == 4);
                o[12] = o[0];
                o[13] = new Short(0);
                o[14] = new Short(0);
                o[15] = new Integer(0);
                o[16] = o[15];
                o[17] = new Integer(10);
                t.insert(o, null);
                ++i;
            }
            return t;
        }
        if (name.equals("SYSTEM_INDEXINFO")) {
            Table t = this.createTable(name);
            t.addColumn("TABLE_CAT", 12);
            t.addColumn("TABLE_SCHEM", 12);
            t.addColumn("TABLE_NAME", 12);
            t.addColumn("NON_UNIQUE", -7);
            t.addColumn("INDEX_QUALIFIER", 12);
            t.addColumn("INDEX_NAME", 12);
            t.addColumn("TYPE", 5);
            t.addColumn(META_ORDINAL_POSITON, 5);
            t.addColumn("COLUMN_NAME", 12);
            t.addColumn(META_ASC_OR_DESC, 12);
            t.addColumn("CARDINALITY", 4);
            t.addColumn("PAGES", 4);
            t.addColumn("FILTER_CONDITION", 12);
            t.createPrimaryKey();
            int i = 0;
            while (i < this.tTable.size()) {
                Table table = (Table)this.tTable.elementAt(i);
                Index index = null;
                while ((index = table.getNextIndex(index)) != null) {
                    int[] cols = index.getColumns();
                    int len = cols.length;
                    if (!index.isUnique()) {
                        --len;
                    }
                    int j = 0;
                    while (j < len) {
                        Object[] o = t.getNewRow();
                        o[2] = table.getName();
                        o[3] = new Boolean(!index.isUnique());
                        o[5] = index.getName();
                        o[6] = new Short(3);
                        o[7] = new Short((short)(j + 1));
                        o[8] = table.getColumnName(cols[j]);
                        o[9] = "A";
                        t.insert(o, null);
                        ++j;
                    }
                }
                ++i;
            }
            return t;
        }
        if (name.equals("SYSTEM_UDTS")) {
            Table t = this.createTable(name);
            t.addColumn("TYPE_CAT", 12);
            t.addColumn("TYPE_SCHEM", 12);
            t.addColumn("TYPE_NAME", 12);
            t.addColumn("CLASS_NAME", -7);
            t.addColumn("DATA_TYPE", 12);
            t.addColumn("REMARKS", 12);
            t.createPrimaryKey();
            return t;
        }
        if (name.equals("SYSTEM_CONNECTIONINFO")) {
            Table t = this.createTable(name);
            t.addColumn("KEY", 12);
            t.addColumn("VALUE", 12);
            t.createPrimaryKey();
            Object[] o = t.getNewRow();
            o[0] = "USER";
            o[1] = channel.getUsername();
            t.insert(o, null);
            o = t.getNewRow();
            o[0] = "READONLY";
            o[1] = channel.isReadOnly() ? "TRUE" : "FALSE";
            t.insert(o, null);
            o = t.getNewRow();
            o[0] = "MAXROWS";
            o[1] = "" + channel.getMaxRows();
            t.insert(o, null);
            o = t.getNewRow();
            o[0] = "DATABASE";
            o[1] = channel.getDatabase().getName();
            t.insert(o, null);
            o = t.getNewRow();
            o[0] = "IDENTITY";
            o[1] = "" + channel.getLastIdentity();
            t.insert(o, null);
            return t;
        }
        if (name.equals("SYSTEM_USERS")) {
            Table t = this.createTable(name);
            t.addColumn("USER", 12);
            t.addColumn("ADMIN", -7);
            t.createPrimaryKey();
            Vector v = this.aAccess.getUsers();
            int i = 0;
            while (i < v.size()) {
                String user;
                User u = (User)v.elementAt(i);
                if (u != null && !(user = u.getName()).equals("PUBLIC")) {
                    Object[] o = t.getNewRow();
                    o[0] = user;
                    o[1] = new Boolean(u.isAdmin());
                    t.insert(o, null);
                }
                ++i;
            }
            return t;
        }
        return null;
    }

    Result getScript(boolean bDrop, boolean bInsert, boolean bCached, Channel channel) throws SQLException {
        StringBuffer a;
        channel.checkAdmin();
        Result r = new Result(1);
        r.iType[0] = 12;
        r.sTable[0] = "SYSTEM_SCRIPT";
        r.sLabel[0] = "COMMAND";
        r.sName[0] = "COMMAND";
        int i = 0;
        while (i < this.tTable.size()) {
            int[] col;
            Table t = (Table)this.tTable.elementAt(i);
            if (bDrop) {
                this.addRow(r, "DROP TABLE " + t.getName());
            }
            a = new StringBuffer("CREATE ");
            if (t.isCached()) {
                a.append("CACHED ");
            }
            a.append("TABLE ");
            a.append(t.getName());
            a.append('(');
            int columns = t.getColumnCount();
            Index pki = t.getIndex("SYSTEM_PK");
            int pk = pki == null ? -1 : pki.getColumns()[0];
            int j = 0;
            while (j < columns) {
                a.append(t.getColumnName(j));
                a.append(' ');
                a.append(Column.getType(t.getType(j)));
                if (!t.getColumnIsNullable(j)) {
                    a.append(" NOT NULL");
                }
                if (j == t.getIdentityColumn()) {
                    a.append(" IDENTITY");
                }
                if (j == pk) {
                    a.append(" PRIMARY KEY");
                }
                if (j < columns - 1) {
                    a.append(',');
                }
                ++j;
            }
            Vector v = t.getConstraints();
            int j2 = 0;
            while (j2 < v.size()) {
                Constraint c = (Constraint)v.elementAt(j2);
                if (c.getType() == 0) {
                    a.append(",FOREIGN KEY");
                    col = c.getRefColumns();
                    a.append(this.getColumnList(c.getRef(), col, col.length));
                    a.append("REFERENCES ");
                    a.append(c.getMain().getName());
                    col = c.getMainColumns();
                    a.append(this.getColumnList(c.getMain(), col, col.length));
                } else if (c.getType() == 2) {
                    a.append(",UNIQUE");
                    col = c.getMainColumns();
                    a.append(this.getColumnList(c.getMain(), col, col.length));
                }
                ++j2;
            }
            a.append(')');
            this.addRow(r, a.toString());
            Index index = null;
            while ((index = t.getNextIndex(index)) != null) {
                String indexname = index.getName();
                if (indexname.equals("SYSTEM_PK") || indexname.startsWith("SYSTEM_FOREIGN_KEY") || indexname.startsWith("SYSTEM_CONSTRAINT")) continue;
                a = new StringBuffer("CREATE ");
                if (index.isUnique()) {
                    a.append("UNIQUE ");
                }
                a.append("INDEX ");
                a.append(indexname);
                a.append(" ON ");
                a.append(t.getName());
                col = index.getColumns();
                int len = col.length;
                if (!index.isUnique()) {
                    --len;
                }
                a.append(this.getColumnList(t, col, len));
                this.addRow(r, a.toString());
            }
            if (bInsert) {
                Index primary = t.getPrimaryIndex();
                Node x = primary.first();
                boolean integrity = true;
                if (x != null) {
                    integrity = false;
                    this.addRow(r, "SET REFERENTIAL_INTEGRITY FALSE");
                }
                while (x != null) {
                    this.addRow(r, t.getInsertStatement(x.getData()));
                    x = primary.next(x);
                }
                if (!integrity) {
                    this.addRow(r, "SET REFERENTIAL_INTEGRITY TRUE");
                }
            }
            if (bCached && t.isCached()) {
                a = new StringBuffer("SET TABLE ");
                a.append(t.getName());
                a.append(" INDEX '");
                a.append(t.getIndexRoots());
                a.append("'");
                this.addRow(r, a.toString());
            }
            ++i;
        }
        Vector v = this.aAccess.getUsers();
        int i2 = 0;
        while (i2 < v.size()) {
            User u = (User)v.elementAt(i2);
            if (u != null) {
                Hashtable rights;
                String name = u.getName();
                if (!name.equals("PUBLIC")) {
                    a = new StringBuffer("CREATE USER ");
                    a.append(name);
                    a.append(" PASSWORD ");
                    a.append("\"" + u.getPassword() + "\"");
                    if (u.isAdmin()) {
                        a.append(" ADMIN");
                    }
                    this.addRow(r, a.toString());
                }
                if ((rights = u.getRights()) != null) {
                    Enumeration e = rights.keys();
                    while (e.hasMoreElements()) {
                        String object = (String)e.nextElement();
                        int right = (Integer)rights.get(object);
                        if (right == 0) continue;
                        a = new StringBuffer("GRANT ");
                        a.append(Access.getRight(right));
                        a.append(" ON ");
                        a.append(object);
                        a.append(" TO ");
                        a.append(u.getName());
                        this.addRow(r, a.toString());
                    }
                }
            }
            ++i2;
        }
        if (this.dDatabase.isIgnoreCase()) {
            this.addRow(r, "SET IGNORECASE TRUE");
        }
        Hashtable h = this.dDatabase.getAlias();
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String alias = (String)e.nextElement();
            String java = (String)h.get(alias);
            this.addRow(r, "CREATE ALIAS " + alias + " FOR \"" + java + "\"");
        }
        return r;
    }

    private String getColumnList(Table t, int[] col, int len) {
        StringBuffer a = new StringBuffer("(");
        int i = 0;
        while (i < len) {
            a.append(t.getColumnName(col[i]));
            if (i < len - 1) {
                a.append(',');
            }
            ++i;
        }
        return a.append(')').toString();
    }

    private void addRow(Result r, String sql) {
        Object[] s = new String[]{sql};
        r.add(s);
    }

    private Table createTable(String name) {
        return new Table(this.dDatabase, false, name, false);
    }
}

