/*
 * Decompiled with CFR 0.152.
 */
package org.hsql143;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import org.hsql143.ByteArray;
import org.hsql143.Table;
import org.hsql143.Trace;

class Column {
    private static Hashtable hTypes;
    static final int BIT = -7;
    static final int TINYINT = -6;
    static final int BIGINT = -5;
    static final int LONGVARBINARY = -4;
    static final int VARBINARY = -3;
    static final int BINARY = -2;
    static final int LONGVARCHAR = -1;
    static final int CHAR = 1;
    static final int NUMERIC = 2;
    static final int DECIMAL = 3;
    static final int INTEGER = 4;
    static final int SMALLINT = 5;
    static final int FLOAT = 6;
    static final int REAL = 7;
    static final int DOUBLE = 8;
    static final int VARCHAR = 12;
    static final int DATE = 91;
    static final int TIME = 92;
    static final int TIMESTAMP = 93;
    static final int OTHER = 1111;
    static final int NULL = 0;
    static final int VARCHAR_IGNORECASE = 100;
    static final int[] TYPES;
    String sName;
    int iType;
    private boolean bNullable;
    private boolean bIdentity;

    static {
        TYPES = new int[]{-7, -6, -5, -4, -3, -2, -1, 1, 2, 3, 4, 5, 6, 7, 8, 12, 91, 92, 93, 1111};
        hTypes = new Hashtable();
        Column.addTypes(4, "INTEGER", "int", "java.lang.Integer");
        Column.addType(4, "INT");
        Column.addTypes(8, "DOUBLE", "double", "java.lang.Double");
        Column.addType(6, "FLOAT");
        Column.addTypes(12, "VARCHAR", "java.lang.String", null);
        Column.addTypes(1, "CHAR", "CHARACTER", null);
        Column.addType(-1, "LONGVARCHAR");
        Column.addType(-1, "TEXT");
        Column.addType(100, "VARCHAR_IGNORECASE");
        Column.addTypes(91, "DATE", "java.sql.Date", null);
        Column.addTypes(92, "TIME", "java.sql.Time", null);
        Column.addTypes(93, "TIMESTAMP", "java.sql.Timestamp", "DATETIME");
        Column.addTypes(3, "DECIMAL", "java.math.BigDecimal", null);
        Column.addType(2, "NUMERIC");
        Column.addTypes(-7, "BIT", "java.lang.Boolean", "boolean");
        Column.addTypes(-6, "TINYINT", "java.lang.Short", "short");
        Column.addType(5, "SMALLINT");
        Column.addTypes(-5, "BIGINT", "java.lang.Long", "long");
        Column.addTypes(7, "REAL", "java.lang.Float", "float");
        Column.addTypes(-2, "BINARY", "byte[]", null);
        Column.addType(-3, "VARBINARY");
        Column.addType(-4, "LONGVARBINARY");
        Column.addTypes(1111, "OTHER", "java.lang.Object", "OBJECT");
    }

    private static void addTypes(int type, String name, String n2, String n3) {
        Column.addType(type, name);
        Column.addType(type, n2);
        Column.addType(type, n3);
    }

    private static void addType(int type, String name) {
        if (name != null) {
            hTypes.put(name, new Integer(type));
        }
    }

    Column(String name, boolean nullable, int type, boolean identity) {
        this.sName = name;
        this.bNullable = nullable;
        this.iType = type;
        this.bIdentity = identity;
    }

    boolean isIdentity() {
        return this.bIdentity;
    }

    static int getTypeNr(String type) throws SQLException {
        Integer i = (Integer)hTypes.get(type);
        Trace.check(i != null, 15, type);
        return i;
    }

    static String getType(int type) throws SQLException {
        switch (type) {
            case 0: {
                return "NULL";
            }
            case 4: {
                return "INTEGER";
            }
            case 8: {
                return "DOUBLE";
            }
            case 100: {
                return "VARCHAR_IGNORECASE";
            }
            case 12: {
                return "VARCHAR";
            }
            case 1: {
                return "CHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 3: {
                return "DECIMAL";
            }
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case -5: {
                return "BIGINT";
            }
            case 7: {
                return "REAL";
            }
            case 6: {
                return "FLOAT";
            }
            case 2: {
                return "NUMERIC";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 1111: {
                return "OBJECT";
            }
        }
        throw Trace.error(15, type);
    }

    boolean isNullable() {
        return this.bNullable;
    }

    static Object add(Object a, Object b, int type) throws SQLException {
        if (a == null || b == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 4: {
                int ai = (Integer)a;
                int bi = (Integer)b;
                return new Integer(ai + bi);
            }
            case 6: 
            case 8: {
                double ad = (Double)a;
                double bd = (Double)b;
                return new Double(ad + bd);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return String.valueOf((String)a) + (String)b;
            }
            case 2: 
            case 3: {
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                return abd.add(bbd);
            }
            case -6: 
            case 5: {
                short shorta = (Short)a;
                short shortb = (Short)b;
                return new Short((short)(shorta + shortb));
            }
            case -5: {
                long longa = (Long)a;
                long longb = (Long)b;
                return new Long(longa + longb);
            }
            case 7: {
                float floata = ((Float)a).floatValue();
                float floatb = ((Float)b).floatValue();
                return new Float(floata + floatb);
            }
        }
        throw Trace.error(19, type);
    }

    static Object concat(Object a, Object b) throws SQLException {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return String.valueOf(Column.convertObject(a)) + Column.convertObject(b);
    }

    static Object negate(Object a, int type) throws SQLException {
        if (a == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 4: {
                return new Integer(-((Integer)a).intValue());
            }
            case 6: 
            case 8: {
                return new Double(-((Double)a).doubleValue());
            }
            case 2: 
            case 3: {
                return ((BigDecimal)a).negate();
            }
            case -6: 
            case 5: {
                return new Short(-((Short)a).shortValue());
            }
            case -5: {
                return new Long(-((Long)a).longValue());
            }
            case 7: {
                return new Float(-((Float)a).floatValue());
            }
        }
        throw Trace.error(19, type);
    }

    static Object multiply(Object a, Object b, int type) throws SQLException {
        if (a == null || b == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 4: {
                int ai = (Integer)a;
                int bi = (Integer)b;
                return new Integer(ai * bi);
            }
            case 6: 
            case 8: {
                double ad = (Double)a;
                double bd = (Double)b;
                return new Double(ad * bd);
            }
            case 2: 
            case 3: {
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                return abd.multiply(bbd);
            }
            case -6: 
            case 5: {
                short shorta = (Short)a;
                short shortb = (Short)b;
                return new Short((short)(shorta * shortb));
            }
            case -5: {
                long longa = (Long)a;
                long longb = (Long)b;
                return new Long(longa * longb);
            }
            case 7: {
                float floata = ((Float)a).floatValue();
                float floatb = ((Float)b).floatValue();
                return new Float(floata * floatb);
            }
        }
        throw Trace.error(19, type);
    }

    static Object divide(Object a, Object b, int type) throws SQLException {
        if (a == null || b == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 4: {
                int ai = (Integer)a;
                int bi = (Integer)b;
                Trace.check(bi != 0, 5);
                return new Integer(ai / bi);
            }
            case 6: 
            case 8: {
                double ad = (Double)a;
                double bd = (Double)b;
                return bd == 0.0 ? null : new Double(ad / bd);
            }
            case 2: 
            case 3: {
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                return bbd.signum() == 0 ? null : abd.divide(bbd, 5);
            }
            case -6: 
            case 5: {
                short shorta = (Short)a;
                short shortb = (Short)b;
                return shortb == 0 ? null : new Short((short)(shorta / shortb));
            }
            case -5: {
                long longa = (Long)a;
                long longb = (Long)b;
                return longb == 0L ? null : new Long(longa / longb);
            }
            case 7: {
                float floata = ((Float)a).floatValue();
                float floatb = ((Float)b).floatValue();
                return floatb == 0.0f ? null : new Float(floata / floatb);
            }
        }
        throw Trace.error(19, type);
    }

    static Object subtract(Object a, Object b, int type) throws SQLException {
        if (a == null || b == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 4: {
                int ai = (Integer)a;
                int bi = (Integer)b;
                return new Integer(ai - bi);
            }
            case 6: 
            case 8: {
                double ad = (Double)a;
                double bd = (Double)b;
                return new Double(ad - bd);
            }
            case 2: 
            case 3: {
                BigDecimal abd = (BigDecimal)a;
                BigDecimal bbd = (BigDecimal)b;
                return abd.subtract(bbd);
            }
            case -6: 
            case 5: {
                short shorta = (Short)a;
                short shortb = (Short)b;
                return new Short((short)(shorta - shortb));
            }
            case -5: {
                long longa = (Long)a;
                long longb = (Long)b;
                return new Long(longa - longb);
            }
            case 7: {
                float floata = ((Float)a).floatValue();
                float floatb = ((Float)b).floatValue();
                return new Float(floata - floatb);
            }
        }
        throw Trace.error(19, type);
    }

    static Object sum(Object a, Object b, int type) throws SQLException {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 4: {
                return new Integer((Integer)a + (Integer)b);
            }
            case 6: 
            case 8: {
                return new Double((Double)a + (Double)b);
            }
            case 2: 
            case 3: {
                return ((BigDecimal)a).add((BigDecimal)b);
            }
            case -6: 
            case 5: {
                return new Short((short)((Short)a + (Short)b));
            }
            case -5: {
                return new Long((Long)a + (Long)b);
            }
            case 7: {
                return new Float(((Float)a).floatValue() + ((Float)b).floatValue());
            }
        }
        Trace.error(14);
        return null;
    }

    static Object avg(Object a, int type, int count) throws SQLException {
        if (a == null || count == 0) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 4: {
                return new Integer((Integer)a / count);
            }
            case 6: 
            case 8: {
                return new Double((Double)a / (double)count);
            }
            case 2: 
            case 3: {
                return ((BigDecimal)a).divide(new BigDecimal(count), 5);
            }
            case -6: 
            case 5: {
                return new Short((short)((Short)a / count));
            }
            case -5: {
                return new Long((Long)a / (long)count);
            }
            case 7: {
                return new Float(((Float)a).floatValue() / (float)count);
            }
        }
        Trace.error(14);
        return null;
    }

    static Object min(Object a, Object b, int type) throws SQLException {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (Column.compare(a, b, type) < 0) {
            return a;
        }
        return b;
    }

    static Object max(Object a, Object b, int type) throws SQLException {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (Column.compare(a, b, type) > 0) {
            return a;
        }
        return b;
    }

    static int compare(Object a, Object b, int type) throws SQLException {
        int i = 0;
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        switch (type) {
            case 0: {
                return 0;
            }
            case 4: {
                int ai = (Integer)a;
                int bi = (Integer)b;
                return ai > bi ? 1 : (bi > ai ? -1 : 0);
            }
            case 6: 
            case 8: {
                double ad = (Double)a;
                double bd = (Double)b;
                return ad > bd ? 1 : (bd > ad ? -1 : 0);
            }
            case -1: 
            case 1: 
            case 12: {
                i = ((String)a).compareTo((String)b);
                break;
            }
            case 100: {
                i = ((String)a).toUpperCase().compareTo(((String)b).toUpperCase());
                break;
            }
            case 91: {
                if (((Date)a).after((Date)b)) {
                    return 1;
                }
                if (((Date)a).before((Date)b)) {
                    return -1;
                }
                return 0;
            }
            case 92: {
                if (((Time)a).after((Time)b)) {
                    return 1;
                }
                if (((Time)a).before((Time)b)) {
                    return -1;
                }
                return 0;
            }
            case 93: {
                if (((Timestamp)a).after((Timestamp)b)) {
                    return 1;
                }
                if (((Timestamp)a).before((Timestamp)b)) {
                    return -1;
                }
                return 0;
            }
            case 2: 
            case 3: {
                i = ((BigDecimal)a).compareTo((BigDecimal)b);
                break;
            }
            case -7: {
                boolean boola = (Boolean)a;
                boolean boolb = (Boolean)b;
                return boola == boolb ? 0 : (boolb ? -1 : 1);
            }
            case -6: 
            case 5: {
                short shorta = (Short)a;
                short shortb = (Short)b;
                return shorta > shortb ? 1 : (shortb > shorta ? -1 : 0);
            }
            case -5: {
                long longa = (Long)a;
                long longb = (Long)b;
                return longa > longb ? 1 : (longb > longa ? -1 : 0);
            }
            case 7: {
                float floata = ((Float)a).floatValue();
                float floatb = ((Float)b).floatValue();
                return floata > floatb ? 1 : (floatb > floata ? -1 : 0);
            }
            case -4: 
            case -3: 
            case -2: 
            case 1111: {
                i = ((ByteArray)a).compareTo((ByteArray)b);
                break;
            }
            default: {
                throw Trace.error(19, type);
            }
        }
        return i > 0 ? 1 : (i < 0 ? -1 : 0);
    }

    static Object convertString(String s, int type) throws SQLException {
        if (s == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 4: {
                return new Integer(s);
            }
            case 6: 
            case 8: {
                return new Double(s);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return s;
            }
            case 91: {
                return Date.valueOf(s);
            }
            case 92: {
                return Time.valueOf(s);
            }
            case 93: {
                return Timestamp.valueOf(s);
            }
            case 2: 
            case 3: {
                return new BigDecimal(s.trim());
            }
            case -7: {
                return new Boolean(s);
            }
            case -6: 
            case 5: {
                return new Short(s);
            }
            case -5: {
                return new Long(s);
            }
            case 7: {
                return new Float(s);
            }
            case -4: 
            case -3: 
            case -2: 
            case 1111: {
                return new ByteArray(s);
            }
        }
        throw Trace.error(19, type);
    }

    static String convertObject(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    static Object convertObject(Object o, int type) throws SQLException {
        if (o == null) {
            return null;
        }
        return Column.convertString(o.toString(), type);
    }

    static String createString(Object o, int type) throws SQLException {
        if (o == null) {
            return "NULL";
        }
        switch (type) {
            case 0: {
                return "NULL";
            }
            case -4: 
            case -3: 
            case -2: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: {
                return "'" + o.toString() + "'";
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return Column.createString((String)o);
            }
        }
        return o.toString();
    }

    static String createString(String s) {
        StringBuffer b = new StringBuffer().append('\'');
        if (s != null) {
            int i = 0;
            int len = s.length();
            while (i < len) {
                char c = s.charAt(i);
                if (c == '\'') {
                    b.append(c);
                }
                b.append(c);
                ++i;
            }
        }
        return b.append('\'').toString();
    }

    static Object[] readData(DataInput in, int l) throws IOException, SQLException {
        Object[] data = new Object[l];
        int i = 0;
        while (i < l) {
            int type = in.readInt();
            Object o = null;
            switch (type) {
                case 0: {
                    o = null;
                    break;
                }
                case 4: {
                    o = new Integer(in.readInt());
                    break;
                }
                case 6: 
                case 8: {
                    o = new Double(Double.longBitsToDouble(in.readLong()));
                    break;
                }
                case -1: 
                case 1: 
                case 12: 
                case 100: {
                    o = in.readUTF();
                    break;
                }
                case 91: {
                    o = Date.valueOf(in.readUTF());
                    break;
                }
                case 92: {
                    o = Time.valueOf(in.readUTF());
                    break;
                }
                case 93: {
                    o = Timestamp.valueOf(in.readUTF());
                    break;
                }
                case 2: 
                case 3: {
                    o = new BigDecimal(in.readUTF());
                    break;
                }
                case -7: {
                    o = new Boolean(in.readUTF());
                    break;
                }
                case -6: 
                case 5: {
                    o = new Short(in.readUTF());
                    break;
                }
                case -5: {
                    o = new Long(in.readUTF());
                    break;
                }
                case 7: {
                    o = new Float(in.readUTF());
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 1111: {
                    o = new ByteArray(in.readUTF());
                    break;
                }
                default: {
                    throw Trace.error(19, type);
                }
            }
            data[i] = o;
            ++i;
        }
        return data;
    }

    static void writeData(DataOutput out, Object[] data, Table t) throws IOException {
        int len = t.getInternalColumnCount();
        int[] type = new int[len];
        int i = 0;
        while (i < len) {
            type[i] = t.getType(i);
            ++i;
        }
        Column.writeData(out, len, type, data);
    }

    static void writeData(DataOutput out, int l, int[] type, Object[] data) throws IOException {
        int i = 0;
        while (i < l) {
            Object o = data[i];
            if (o == null) {
                out.writeInt(0);
            } else {
                int t = type[i];
                out.writeInt(t);
                switch (t) {
                    case 4: {
                        out.writeInt((Integer)o);
                        break;
                    }
                    case 6: 
                    case 8: {
                        out.writeLong(Double.doubleToLongBits((Double)o));
                        break;
                    }
                    default: {
                        out.writeUTF(o.toString());
                    }
                }
            }
            ++i;
        }
    }

    static int getSize(Object[] data, Table t) {
        int l = data.length;
        int[] type = new int[l];
        int i = 0;
        while (i < l) {
            type[i] = t.getType(i);
            ++i;
        }
        return Column.getSize(data, l, type);
    }

    private static int getSize(Object[] data, int l, int[] type) {
        int s = 0;
        int i = 0;
        while (i < l) {
            Object o = data[i];
            s += 4;
            if (o != null) {
                switch (type[i]) {
                    case 4: {
                        s += 4;
                        break;
                    }
                    case 6: 
                    case 8: {
                        s += 8;
                        break;
                    }
                    default: {
                        s += Column.getUTFsize(o.toString());
                    }
                }
            }
            ++i;
        }
        return s;
    }

    private static int getUTFsize(String s) {
        if (s == null) {
            s = "";
        }
        int len = s.length();
        int l = 2;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            l = c >= '\u0001' && c <= '\u007f' ? ++l : (c > '\u07ff' ? (l += 3) : (l += 2));
            ++i;
        }
        return l;
    }
}

