/*
 * Decompiled with CFR 0.152.
 */
package org.hsql143;

import java.sql.SQLException;
import java.util.Vector;
import org.hsql143.Database;
import org.hsql143.Table;
import org.hsql143.Trace;
import org.hsql143.Transaction;
import org.hsql143.User;

class Channel {
    private Database dDatabase;
    private User uUser;
    private Vector tTransaction;
    private boolean bAutoCommit;
    private boolean bNestedTransaction;
    private boolean bNestedOldAutoCommit;
    private int iNestedOldTransIndex;
    private boolean bReadOnly;
    private int iMaxRows;
    private int iLastIdentity;
    private boolean bClosed;
    private int iId;

    public void finalize() throws SQLException {
        this.disconnect();
    }

    Channel(Channel c, int id) {
        this(c.dDatabase, c.uUser, true, c.bReadOnly, id);
    }

    Channel(Database db, User user, boolean autocommit, boolean readonly, int id) {
        this.iId = id;
        this.dDatabase = db;
        this.uUser = user;
        this.tTransaction = new Vector();
        this.bAutoCommit = autocommit;
        this.bReadOnly = readonly;
    }

    int getId() {
        return this.iId;
    }

    void disconnect() throws SQLException {
        if (this.bClosed) {
            return;
        }
        this.rollback();
        this.dDatabase = null;
        this.uUser = null;
        this.tTransaction = null;
        this.bClosed = true;
    }

    boolean isClosed() {
        return this.bClosed;
    }

    void setLastIdentity(int i) {
        this.iLastIdentity = i;
    }

    int getLastIdentity() {
        return this.iLastIdentity;
    }

    Database getDatabase() {
        return this.dDatabase;
    }

    String getUsername() {
        return this.uUser.getName();
    }

    void setUser(User user) {
        this.uUser = user;
    }

    void checkAdmin() throws SQLException {
        this.uUser.checkAdmin();
    }

    void check(String object, int right) throws SQLException {
        this.uUser.check(object, right);
    }

    void checkReadWrite() throws SQLException {
        Trace.check(!this.bReadOnly, 30);
    }

    void setPassword(String s) {
        this.uUser.setPassword(s);
    }

    void addTransactionDelete(Table table, Object[] row) throws SQLException {
        if (!this.bAutoCommit) {
            Transaction t = new Transaction(true, table, row);
            this.tTransaction.addElement(t);
        }
    }

    void addTransactionInsert(Table table, Object[] row) throws SQLException {
        if (!this.bAutoCommit) {
            Transaction t = new Transaction(false, table, row);
            this.tTransaction.addElement(t);
        }
    }

    void setAutoCommit(boolean autocommit) throws SQLException {
        this.commit();
        this.bAutoCommit = autocommit;
    }

    void commit() throws SQLException {
        this.tTransaction.removeAllElements();
    }

    void rollback() throws SQLException {
        int i = this.tTransaction.size() - 1;
        while (i >= 0) {
            Transaction t = (Transaction)this.tTransaction.elementAt(i);
            t.rollback();
            --i;
        }
        this.tTransaction.removeAllElements();
    }

    void beginNestedTransaction() throws SQLException {
        Trace.Assert(!this.bNestedTransaction, "beginNestedTransaction");
        this.bNestedOldAutoCommit = this.bAutoCommit;
        this.bAutoCommit = false;
        this.iNestedOldTransIndex = this.tTransaction.size();
        this.bNestedTransaction = true;
    }

    void endNestedTransaction(boolean rollback) throws SQLException {
        Trace.Assert(this.bNestedTransaction, "endNestedTransaction");
        int i = this.tTransaction.size() - 1;
        if (rollback) {
            while (i >= this.iNestedOldTransIndex) {
                Transaction t = (Transaction)this.tTransaction.elementAt(i);
                t.rollback();
                --i;
            }
        }
        this.bNestedTransaction = false;
        this.bAutoCommit = this.bNestedOldAutoCommit;
        if (this.bAutoCommit) {
            this.tTransaction.setSize(this.iNestedOldTransIndex);
        }
    }

    void setReadOnly(boolean readonly) {
        this.bReadOnly = readonly;
    }

    boolean isReadOnly() {
        return this.bReadOnly;
    }

    void setMaxRows(int max) {
        this.iMaxRows = max;
    }

    int getMaxRows() {
        return this.iMaxRows;
    }

    boolean isNestedTransaction() {
        return this.bNestedTransaction;
    }
}

