/*
 * Decompiled with CFR 0.152.
 */
package org.hsql.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.LineNumberReader;
import java.util.Vector;

public class CodeSwitcher {
    private Vector vList = new Vector();
    private Vector vSwitchOn = new Vector();
    private Vector vSwitchOff = new Vector();
    private Vector vSwitches = new Vector();
    private boolean bAdd;
    private boolean bRemove;
    private static final int MAX_LINELENGTH = 82;

    public static void main(String[] a) {
        CodeSwitcher s = new CodeSwitcher();
        if (a.length == 0) {
            CodeSwitcher.showUsage();
            return;
        }
        boolean path = false;
        int i = 0;
        while (i < a.length) {
            String p = a[i];
            if (p.startsWith("+")) {
                if (p.length() == 1) {
                    s.bAdd = true;
                } else {
                    s.vSwitchOn.addElement(p.substring(1));
                }
            } else if (p.startsWith("-")) {
                if (p.length() == 1) {
                    s.bRemove = true;
                } else {
                    s.vSwitchOff.addElement(p.substring(1));
                }
            } else {
                s.addDir(p);
                path = true;
            }
            ++i;
        }
        if (!path) {
            CodeSwitcher.printError("no path specified");
            CodeSwitcher.showUsage();
        }
        s.process();
        if (s.vSwitchOff.size() == 0 && s.vSwitchOn.size() == 0) {
            s.printSwitches();
        }
    }

    static void showUsage() {
        System.out.println("Usage: java CodeSwitcher [paths] [labels] [+][-]");
        System.out.println("If no labels are specified then all used");
        System.out.println("labels in the source code are shown.");
        System.out.println("Use +MODE to switch on the things labeld MODE");
        System.out.println("Use -MODE to switch off the things labeld MODE");
        System.out.println("Path: Any number of path or files may be");
        System.out.println("specified. Use . for the current directory");
        System.out.println("(including sub-directories).");
        System.out.println("Example: java CodeSwitcher +JAVA2 .");
        System.out.println("This example switches on code labeled JAVA2");
        System.out.println("in all *.java files in the current directory");
        System.out.println("and all subdirectories.");
        System.out.println("java CodeSwitcher + .");
        System.out.println("Adds test code to the code.");
        System.out.println("java CodeSwitcher - .");
        System.out.println("Removed test code from the code.");
    }

    CodeSwitcher() {
    }

    void process() {
        int len = this.vList.size();
        int i = 0;
        while (i < len) {
            System.out.print(".");
            String file = (String)this.vList.elementAt(i);
            if (this.bAdd || this.bRemove) {
                int maxlen = this.testFile(file);
                if (this.bAdd && !this.bRemove) {
                    this.addTest(file, maxlen);
                } else {
                    this.removeTest(file);
                }
            } else if (!this.processFile(file)) {
                System.out.println("in file " + file + " !");
            }
            ++i;
        }
        System.out.println("");
    }

    void printSwitches() {
        System.out.println("Used labels:");
        int i = 0;
        while (i < this.vSwitches.size()) {
            System.out.println((String)this.vSwitches.elementAt(i));
            ++i;
        }
    }

    void addDir(String path) {
        File f = new File(path);
        if (f.isFile() && path.endsWith(".java")) {
            this.vList.addElement(path);
        } else if (f.isDirectory()) {
            String[] list = f.list();
            int i = 0;
            while (i < list.length) {
                this.addDir(String.valueOf(path) + File.separatorChar + list[i]);
                ++i;
            }
        }
    }

    void removeTest(String name) {
        File f = new File(name);
        File fnew = new File(String.valueOf(name) + ".new");
        try {
            String line;
            LineNumberReader read = new LineNumberReader(new FileReader(f));
            FileWriter write = new FileWriter(fnew);
            while ((line = read.readLine()) != null) {
                if (line.startsWith("Profile.visit(")) {
                    int s = line.indexOf(59);
                    line = line.substring(s + 1);
                }
                write.write(String.valueOf(line) + "\r\n");
            }
            read.close();
            write.flush();
            write.close();
            File fbak = new File(String.valueOf(name) + ".bak");
            fbak.delete();
            f.renameTo(fbak);
            File fcopy = new File(name);
            fnew.renameTo(fcopy);
            fbak.delete();
        }
        catch (Exception e) {
            CodeSwitcher.printError(e.getMessage());
        }
    }

    void addTest(String name, int maxline) {
        File f = new File(name);
        File fnew = new File(String.valueOf(name) + ".new");
        String key = name;
        key = key.replace('\\', '.');
        try {
            String line;
            LineNumberReader read = new LineNumberReader(new FileReader(f));
            FileWriter write = new FileWriter(fnew);
            int l = 0;
            boolean longline = false;
            while ((line = read.readLine()) != null) {
                if (line.startsWith(" ")) {
                    int spaces = 0;
                    while (spaces < line.length()) {
                        if (line.charAt(spaces) != ' ') break;
                        ++spaces;
                    }
                    if (spaces > 3 && this.testLine(line) && !longline) {
                        line = "Profile.visit(\"" + key + "\"," + l + "," + maxline + ");" + line;
                        ++l;
                    } else {
                        longline = this.isLongline(line);
                    }
                }
                write.write(String.valueOf(line) + "\r\n");
            }
            read.close();
            write.flush();
            write.close();
            File fbak = new File(String.valueOf(name) + ".bak");
            fbak.delete();
            f.renameTo(fbak);
            File fcopy = new File(name);
            fnew.renameTo(fcopy);
            fbak.delete();
        }
        catch (Exception e) {
            CodeSwitcher.printError(e.getMessage());
        }
    }

    int testFile(String name) {
        File f = new File(name);
        try {
            String line;
            LineNumberReader read = new LineNumberReader(new FileReader(f));
            int l = 1;
            int maxline = 0;
            boolean longline = false;
            while ((line = read.readLine()) != null) {
                if (line.length() > 82 && !line.startsWith("Profile.")) {
                    System.out.println("long line in " + name + " at line " + l);
                }
                if (line.startsWith(" ")) {
                    int spaces = 0;
                    while (spaces < line.length()) {
                        if (line.charAt(spaces) != ' ') break;
                        ++spaces;
                    }
                    if (spaces > 3 && this.testLine(line) && !longline) {
                        ++maxline;
                    } else {
                        longline = this.isLongline(line);
                    }
                    String s = line.substring(spaces);
                    if (s.startsWith("if(")) {
                        if (!s.endsWith(" {")) {
                            System.out.println("if( without { in " + name + " at line " + l);
                        }
                    } else if (s.startsWith("} else if(")) {
                        if (!s.endsWith(" {")) {
                            System.out.println("} else if without { in " + name + " at line " + l);
                        }
                    } else if (s.startsWith("while(")) {
                        if (!s.endsWith(" {")) {
                            System.out.println("while( without { in " + name + " at line " + l);
                        }
                    } else if (s.startsWith("switch(")) {
                        if (!s.endsWith(" {")) {
                            System.out.println("switch( without { in " + name + " at line " + l);
                        }
                    } else if (s.startsWith("do ") && !s.endsWith(" {")) {
                        System.out.println("do without { in " + name + " at line " + l);
                    }
                }
                ++l;
            }
            read.close();
            return maxline;
        }
        catch (Exception e) {
            CodeSwitcher.printError(e.getMessage());
            return -1;
        }
    }

    boolean testLine(String line) {
        if (!line.endsWith(";")) {
            return false;
        }
        return !line.trim().startsWith("super(");
    }

    boolean isLongline(String s) {
        char c = s.charAt(s.length() - 1);
        return ",(+-&|".indexOf(c) >= 0;
    }

    boolean processFile(String name) {
        File f = new File(name);
        File fnew = new File(String.valueOf(name) + ".new");
        int state = 0;
        boolean switchoff = false;
        boolean working = false;
        try {
            String line;
            LineNumberReader read = new LineNumberReader(new FileReader(f));
            FileWriter write = new FileWriter(fnew);
            while ((line = read.readLine()) != null) {
                if (working && (line.equals("/*") || line.equals("*/"))) continue;
                if (!line.startsWith("//#")) {
                    write.write(String.valueOf(line) + "\r\n");
                    continue;
                }
                if (line.startsWith("//#ifdef ")) {
                    if (state != 0) {
                        CodeSwitcher.printError("'#ifdef' not allowed inside '#ifdef'");
                        return false;
                    }
                    write.write(String.valueOf(line) + "\r\n");
                    state = 1;
                    String s = line.substring(9);
                    if (this.vSwitchOn.indexOf(s) != -1) {
                        working = true;
                        switchoff = false;
                    } else if (this.vSwitchOff.indexOf(s) != -1) {
                        working = true;
                        write.write("/*\r\n");
                        switchoff = true;
                    }
                    if (this.vSwitches.indexOf(s) != -1) continue;
                    this.vSwitches.addElement(s);
                    continue;
                }
                if (line.startsWith("//#else")) {
                    if (state != 1) {
                        CodeSwitcher.printError("'#else' without '#ifdef'");
                        return false;
                    }
                    state = 2;
                    if (!working) {
                        write.write(String.valueOf(line) + "\r\n");
                        continue;
                    }
                    if (switchoff) {
                        write.write("*/\r\n");
                        write.write(String.valueOf(line) + "\r\n");
                        switchoff = false;
                        continue;
                    }
                    write.write(String.valueOf(line) + "\r\n");
                    write.write("/*\r\n");
                    switchoff = true;
                    continue;
                }
                if (line.startsWith("//#endif")) {
                    if (state == 0) {
                        CodeSwitcher.printError("'#endif' without '#ifdef'");
                        return false;
                    }
                    state = 0;
                    if (working && switchoff) {
                        write.write("*/\r\n");
                    }
                    write.write(String.valueOf(line) + "\r\n");
                    working = false;
                    continue;
                }
                write.write(String.valueOf(line) + "\r\n");
            }
            if (state != 0) {
                CodeSwitcher.printError("'#endif' missing");
                return false;
            }
            read.close();
            write.flush();
            write.close();
            File fbak = new File(String.valueOf(name) + ".bak");
            fbak.delete();
            f.renameTo(fbak);
            File fcopy = new File(name);
            fnew.renameTo(fcopy);
            fbak.delete();
            return true;
        }
        catch (Exception e) {
            CodeSwitcher.printError(e.getMessage());
            return false;
        }
    }

    static void printError(String error) {
        System.out.println("");
        System.out.println("ERROR: " + error);
    }
}

