/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol.io;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.io.IoAcceptor;
import org.apache.mina.protocol.ProtocolAcceptor;
import org.apache.mina.protocol.ProtocolFilterChain;
import org.apache.mina.protocol.ProtocolProvider;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.io.IoAdapter;
import org.apache.mina.protocol.io.IoProtocolSessionManagerFilterChain;

public class IoProtocolAcceptor
implements ProtocolAcceptor {
    private final IoAcceptor acceptor;
    private final IoAdapter adapter = new IoAdapter(new IoProtocolSessionManagerFilterChain(this));

    public IoProtocolAcceptor(IoAcceptor acceptor) {
        if (acceptor == null) {
            throw new NullPointerException("acceptor");
        }
        this.acceptor = acceptor;
    }

    public IoAcceptor getIoAcceptor() {
        return this.acceptor;
    }

    public void bind(SocketAddress address, ProtocolProvider provider) throws IOException {
        this.acceptor.bind(address, this.adapter.adapt(provider));
    }

    public void unbind(SocketAddress address) {
        this.acceptor.unbind(address);
    }

    public ProtocolSession newSession(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.adapter.toProtocolSession(this.acceptor.newSession(remoteAddress, localAddress));
    }

    public ProtocolFilterChain getFilterChain() {
        return this.adapter.getFilterChain();
    }

    public ExceptionMonitor getExceptionMonitor() {
        return this.acceptor.getExceptionMonitor();
    }

    public void setExceptionMonitor(ExceptionMonitor monitor) {
        this.acceptor.setExceptionMonitor(monitor);
    }
}

