/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol.io;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.io.IoHandler;
import org.apache.mina.io.IoSession;
import org.apache.mina.protocol.ProtocolCodecFactory;
import org.apache.mina.protocol.ProtocolDecoder;
import org.apache.mina.protocol.ProtocolEncoder;
import org.apache.mina.protocol.ProtocolFilterChain;
import org.apache.mina.protocol.ProtocolHandler;
import org.apache.mina.protocol.ProtocolProvider;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.ProtocolViolationException;
import org.apache.mina.protocol.io.IoProtocolSession;
import org.apache.mina.protocol.io.IoProtocolSessionManagerFilterChain;
import org.apache.mina.util.Queue;

class IoAdapter {
    private static final String KEY = "IoAdapter.ProtocolSession";
    private final IoProtocolSessionManagerFilterChain managerFilterChain;

    IoAdapter(IoProtocolSessionManagerFilterChain filters) {
        this.managerFilterChain = filters;
    }

    public ProtocolFilterChain getFilterChain() {
        return this.managerFilterChain;
    }

    public IoHandler adapt(ProtocolProvider protocolProvider) {
        return new SessionHandlerAdapter(protocolProvider);
    }

    public ProtocolSession toProtocolSession(IoSession session) {
        IoHandler handler = session.getHandler();
        if (handler instanceof SessionHandlerAdapter) {
            SessionHandlerAdapter sha = (SessionHandlerAdapter)handler;
            return sha.getProtocolSession(session);
        }
        throw new IllegalArgumentException("Not adapted from IoAdapter.");
    }

    class SessionHandlerAdapter
    implements IoHandler {
        final ProtocolCodecFactory codecFactory;
        final ProtocolHandler handler;

        public SessionHandlerAdapter(ProtocolProvider protocolProvider) {
            this.codecFactory = protocolProvider.getCodecFactory();
            this.handler = protocolProvider.getHandler();
        }

        public void sessionCreated(IoSession session) throws Exception {
            this.handler.sessionCreated(this.getProtocolSession(session));
        }

        public void sessionOpened(IoSession session) {
            IoAdapter.this.managerFilterChain.sessionOpened(this.getProtocolSession(session));
        }

        public void sessionClosed(IoSession session) {
            IoAdapter.this.managerFilterChain.sessionClosed(this.getProtocolSession(session));
        }

        public void sessionIdle(IoSession session, IdleStatus status) {
            IoAdapter.this.managerFilterChain.sessionIdle(this.getProtocolSession(session), status);
        }

        public void exceptionCaught(IoSession session, Throwable cause) {
            IoAdapter.this.managerFilterChain.exceptionCaught(this.getProtocolSession(session), cause);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataRead(IoSession session, ByteBuffer in) {
            IoProtocolSession psession = this.getProtocolSession(session);
            ProtocolDecoder decoder = psession.decoder;
            try {
                Queue queue;
                ProtocolDecoder protocolDecoder = decoder;
                synchronized (protocolDecoder) {
                    decoder.decode(psession, in, psession.decOut);
                }
                Queue queue2 = queue = psession.decOut.getMessageQueue();
                synchronized (queue2) {
                    if (!queue.isEmpty()) {
                        do {
                            IoAdapter.this.managerFilterChain.messageReceived(psession, queue.pop());
                        } while (!queue.isEmpty());
                    }
                }
            }
            catch (ProtocolViolationException pve) {
                pve.setHexdump(in.getHexDump());
                IoAdapter.this.managerFilterChain.exceptionCaught(psession, pve);
            }
            catch (Throwable t) {
                IoAdapter.this.managerFilterChain.exceptionCaught(psession, t);
            }
        }

        public void dataWritten(IoSession session, Object marker) {
            if (marker == null) {
                return;
            }
            IoAdapter.this.managerFilterChain.messageSent(this.getProtocolSession(session), marker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doWrite(IoSession session) {
            IoProtocolSession psession = this.getProtocolSession(session);
            ProtocolEncoder encoder = psession.encoder;
            Queue writeQueue = psession.writeQueue;
            if (writeQueue.isEmpty()) {
                return;
            }
            try {
                block4: while (true) {
                    if (writeQueue.isEmpty()) return;
                    Queue queue = writeQueue;
                    synchronized (queue) {
                        Object message = writeQueue.pop();
                        if (message == null) {
                            return;
                        }
                        Queue queue2 = psession.encOut.getBufferQueue();
                        encoder.encode(psession, message, psession.encOut);
                        while (true) {
                            ByteBuffer buf;
                            if ((buf = (ByteBuffer)queue2.pop()) == null) {
                                continue block4;
                            }
                            Object marker = queue2.isEmpty() ? message : null;
                            session.write(buf, marker);
                        }
                    }
                    break;
                }
            }
            catch (Throwable t) {
                IoAdapter.this.managerFilterChain.exceptionCaught(psession, t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IoProtocolSession getProtocolSession(IoSession session) {
            IoProtocolSession psession = (IoProtocolSession)session.getAttribute(IoAdapter.KEY);
            if (psession == null) {
                IoSession ioSession = session;
                synchronized (ioSession) {
                    psession = (IoProtocolSession)session.getAttribute(IoAdapter.KEY);
                    if (psession == null) {
                        psession = new IoProtocolSession(IoAdapter.this.managerFilterChain, session, this);
                        session.setAttribute(IoAdapter.KEY, psession);
                    }
                }
            }
            return psession;
        }
    }
}

