/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.sumup;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.examples.sumup.ClientProtocolProvider;
import org.apache.mina.io.filter.IoThreadPoolFilter;
import org.apache.mina.io.socket.SocketConnector;
import org.apache.mina.protocol.ProtocolProvider;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.filter.ProtocolThreadPoolFilter;
import org.apache.mina.protocol.io.IoProtocolConnector;

public class Client {
    private static final String HOSTNAME = "localhost";
    private static final int PORT = 8080;
    private static final int CONNECT_TIMEOUT = 30;

    public static void main(String[] args) throws Throwable {
        ProtocolSession session;
        if (args.length == 0) {
            System.out.println("Please specify the list of any integers");
            return;
        }
        int[] values = new int[args.length];
        for (int i = 0; i < args.length; ++i) {
            values[i] = Integer.parseInt(args[i]);
        }
        IoThreadPoolFilter ioThreadPoolFilter = new IoThreadPoolFilter();
        ProtocolThreadPoolFilter protocolThreadPoolFilter = new ProtocolThreadPoolFilter();
        ioThreadPoolFilter.start();
        protocolThreadPoolFilter.start();
        IoProtocolConnector connector = new IoProtocolConnector(new SocketConnector());
        connector.getIoConnector().getFilterChain().addFirst("threadPool", ioThreadPoolFilter);
        connector.getFilterChain().addFirst("threadPool", protocolThreadPoolFilter);
        ClientProtocolProvider protocolProvider = new ClientProtocolProvider(values);
        while (true) {
            try {
                session = connector.connect((SocketAddress)new InetSocketAddress(HOSTNAME, 8080), 30, (ProtocolProvider)protocolProvider);
            }
            catch (IOException e) {
                System.err.println("Failed to connect.");
                e.printStackTrace();
                Thread.sleep(5000L);
                continue;
            }
            break;
        }
        while (session.isConnected()) {
            Thread.sleep(100L);
        }
        ioThreadPoolFilter.stop();
        protocolThreadPoolFilter.stop();
    }
}

