/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.utils;

import com.sybase.jdbc3.utils.BufferPool;

public class BufferInterval {
    public byte[] _buf;
    public int _offset;
    public int _length;
    private BufferPool _bp;
    protected BufferInterval _prev;
    protected BufferInterval _next;

    public BufferInterval(byte[] byArray, int n, int n2, BufferPool bufferPool) {
        this._buf = byArray;
        this._offset = n;
        this._length = n2;
        this._bp = bufferPool;
        this._next = null;
        this._prev = null;
    }

    public void free() {
        this._bp.put(this);
    }

    public synchronized BufferInterval divide(int n) throws IndexOutOfBoundsException {
        BufferInterval bufferInterval = null;
        if (n > 0) {
            if (this._length == n) {
                throw new IndexOutOfBoundsException("BufferInterval");
            }
            bufferInterval = new BufferInterval(this._buf, this._offset, n, this._bp);
            this._offset += n;
            this._length -= n;
        }
        return bufferInterval;
    }

    protected synchronized boolean merge(BufferInterval bufferInterval, boolean bl) {
        if (this._buf != bufferInterval._buf) {
            return false;
        }
        if (this._offset + this._length == bufferInterval._offset) {
            if (bl) {
                bufferInterval._length += this._length;
                bufferInterval._offset = this._offset;
            } else {
                this._length += bufferInterval._length;
            }
            return true;
        }
        if (bufferInterval._offset + bufferInterval._length == this._offset) {
            if (bl) {
                bufferInterval._length += this._length;
            } else {
                this._length += bufferInterval._length;
                this._offset = bufferInterval._offset;
            }
            return true;
        }
        return false;
    }

    protected void detach() {
        if (this._prev != null) {
            this._prev._next = this._next;
        }
        if (this._next != null) {
            this._next._prev = this._prev;
        }
        this._next = null;
        this._prev = null;
    }

    protected void attachBefore(BufferInterval bufferInterval) {
        this._next = bufferInterval;
        this._prev = bufferInterval._prev;
        if (bufferInterval._prev != null) {
            bufferInterval._prev._next = this;
        }
        bufferInterval._prev = this;
    }

    protected void attachAfter(BufferInterval bufferInterval) {
        this._next = bufferInterval._next;
        this._prev = bufferInterval;
        if (bufferInterval._next != null) {
            bufferInterval._next._prev = this;
        }
        bufferInterval._next = this;
    }
}

