/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.timedio;

import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.SybProperty;
import com.sybase.jdbc3.timedio.Dbio;
import com.sybase.jdbc3.timedio.InStreamMgr;
import com.sybase.jdbc3.utils.AsciiInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.sql.SQLException;

public class RawDbio
extends Dbio
implements Runnable {
    protected Socket _socket = null;
    private Thread _runner = null;
    private long _currentTimeout = 0L;
    private volatile boolean _runAsync = false;
    static final boolean READAHEAD = true;
    private static final String CONNECT = "CONNECT";
    private static final String TERMINATOR = "\r\n";
    private static final String HTTP_VERSION = "HTTP/1.0";
    private static final String USER_AGENT = "User-agent:";
    private static final String JDBC_VERSION = "Sybase jConnect for JDBC (TM) 6.0";
    private static final String SUCCESS_CONNECT = "200";

    public RawDbio(String string, int n, InStreamMgr inStreamMgr, SybProperty sybProperty) throws SQLException {
        super(string, n, inStreamMgr, sybProperty);
    }

    protected void close() {
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._socket = null;
        }
    }

    protected void doConnect(int n) throws IOException {
        for (int i = 0; i < 1000; ++i) {
            try {
                if (this._proxyHost != null) {
                    this._socket = new Socket(this._proxyHost, this._proxyPort);
                    break;
                }
                this._socket = new Socket(this._host, this._port);
                break;
            }
            catch (SocketException socketException) {
                if (socketException.getMessage().startsWith("Address already in use")) {
                    continue;
                }
                throw socketException;
            }
        }
        this.setUpSocket(n);
    }

    protected void setUpSocket(int n) throws IOException {
        this._socket.setTcpNoDelay(true);
        if ((long)n != this._currentTimeout) {
            this._currentTimeout = n;
            this._socket.setSoTimeout(n);
        }
        this._out = this._socket.getOutputStream();
        this._in = this._socket.getInputStream();
        if (this._proxyHost != null) {
            this.sendHTTPConnect(this._in, this._out, this._host + ":" + this._port);
        }
    }

    public boolean startAsync() {
        if (this._runner == null) {
            this._runAsync = true;
            this._runner = new Thread(this);
            this._runner.start();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAsync() {
        if (this._runner != null) {
            try {
                this._runAsync = false;
                this._runner.join(1L);
            }
            catch (Exception exception) {
            }
            finally {
                this._runner = null;
            }
        }
    }

    public void run() {
        while (this._runAsync) {
            try {
                this.doRead(0L);
            }
            catch (IOException iOException) {
                this._lastEx = iOException;
                this._ioMgr.reportError("JZ0T2");
            }
        }
    }

    protected int reallyRead(long l) throws IOException {
        if (l != this._currentTimeout) {
            this._currentTimeout = l;
            this._socket.setSoTimeout((int)l);
        }
        return this._in.read(this._bufIntv._buf, this._bufIntv._offset + this._bRead, this._bufIntv._length - this._bRead);
    }

    private void sendHTTPConnect(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(CONNECT);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(HTTP_VERSION);
        stringBuffer.append(TERMINATOR);
        stringBuffer.append(USER_AGENT);
        stringBuffer.append(" ");
        stringBuffer.append(JDBC_VERSION);
        stringBuffer.append(TERMINATOR);
        stringBuffer.append(TERMINATOR);
        int n = stringBuffer.length();
        byte[] byArray = stringBuffer.toString().getBytes();
        outputStream.write(byArray, 0, n);
        outputStream.flush();
        boolean bl = false;
        String string2 = AsciiInput.readLine(inputStream);
        if (string2 == null) {
            ErrorMessage.raiseIOException("JZ0I7");
        }
        if (string2.indexOf(SUCCESS_CONNECT) == -1) {
            ErrorMessage.raiseIOException("JZ0I8", string2);
        }
        while (string2 != null) {
            string2 = AsciiInput.readLine(inputStream);
        }
    }
}

