/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.Convert;
import com.sybase.jdbc3.jdbc.DateObject;
import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.LimiterInputStream;
import com.sybase.jdbc3.jdbc.Param;
import com.sybase.jdbc3.jdbc.ParamManager;
import com.sybase.jdbc3.jdbc.ProtocolContext;
import com.sybase.jdbc3.jdbc.SybCallableStatement;
import com.sybase.jdbc3.jdbc.SybStatement;
import com.sybase.jdbc3.tds.SybBigDecimal;
import com.sybase.jdbc3.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;

public class SybPreparedStatement
extends SybStatement
implements com.sybase.jdbcx.SybPreparedStatement,
ParameterMetaData {
    private static final int MAX_PARAMETERS = 1000;
    protected static final int BASE_MAX_BATCH_PARAMETERS = 255;
    String _dynStmtName = null;
    int _paramCount = 0;
    Vector _batchParams = null;
    protected String _query = null;
    protected ParamManager _paramMgr;

    SybPreparedStatement(ProtocolContext protocolContext, String string, int n) throws SQLException {
        super(protocolContext);
        this._dynStmtName = "placeholder";
        string = this.doEscapeProcessing(string);
        this._paramMgr = this.countParams(string);
        String string2 = "dyn" + n;
        this._protocol.dynamicPrepare(protocolContext, string2, string);
        this._dynStmtName = string2;
    }

    SybPreparedStatement(ProtocolContext protocolContext, String string) throws SQLException {
        super(protocolContext);
        string = this.doEscapeProcessing(string);
        this._paramMgr = this.countParams(string);
    }

    SybPreparedStatement(ProtocolContext protocolContext, SybPreparedStatement sybPreparedStatement) throws SQLException {
        super(protocolContext);
        this._query = sybPreparedStatement._query;
        this._paramMgr = new ParamManager(sybPreparedStatement._paramMgr, this);
    }

    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(this._query, this._paramMgr);
    }

    public ResultSet executeQuery(String string) throws SQLException {
        ErrorMessage.raiseError("JZ0S3", "executeQuery(String)");
        return null;
    }

    public int executeUpdate() throws SQLException {
        return super.executeUpdate(this._query, this._paramMgr);
    }

    public int executeUpdate(String string) throws SQLException {
        ErrorMessage.raiseError("JZ0S3", "executeUpdate(String)");
        return 0;
    }

    public void setNull(int n, int n2) throws SQLException {
        this.checkDead();
        this.setParam(n2, n, null);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        Debug.notImplemented(this, "setNull(int, int, String)");
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.checkDead();
        Boolean bl2 = new Boolean(bl);
        this.setParam(-7, n, bl2);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.checkDead();
        Integer n2 = new Integer(by);
        if (n2 < 0) {
            this.setParam(5, n, n2);
        } else {
            this.setParam(-6, n, n2);
        }
    }

    public void setShort(int n, short s) throws SQLException {
        this.checkDead();
        Integer n2 = new Integer(s);
        this.setParam(5, n, n2);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.checkDead();
        Integer n3 = new Integer(n2);
        this.setParam(4, n, n3);
    }

    public void setLong(int n, long l) throws SQLException {
        this.checkDead();
        Long l2 = new Long(l);
        this.setParam(-5, n, l2);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.checkDead();
        Float f2 = new Float(f);
        this.setParam(7, n, f2);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.checkDead();
        Double d2 = new Double(d);
        this.setParam(8, n, d2);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkDead();
        if (bigDecimal == null) {
            this.setNull(n, 2);
        } else {
            this.setParam(2, n, bigDecimal, bigDecimal.scale());
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal, int n2, int n3) throws SQLException {
        this.checkDead();
        if (bigDecimal == null) {
            bigDecimal = new BigDecimal("0");
        }
        SybBigDecimal sybBigDecimal = new SybBigDecimal(bigDecimal, n2, n3);
        this.setParam(2, n, sybBigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        this.checkDead();
        this.setParam(12, n, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkDead();
        int n2 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        if (n2 > 255) {
            this.setParam(-4, n, byArray);
        } else {
            this.setParam(-3, n, byArray);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        this.checkDead();
        if (date == null) {
            this.setParam(91, n, date);
        } else {
            this.setParam(91, n, new DateObject((Object)date, 91));
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        this.checkDead();
        if (time == null) {
            this.setParam(92, n, time);
        } else {
            this.setParam(92, n, new DateObject((Object)time, 92));
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkDead();
        if (timestamp == null) {
            this.setParam(93, n, timestamp);
        } else {
            this.setParam(93, n, new DateObject((Object)timestamp, 93));
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkDead();
        if (inputStream == null) {
            this.setNull(n, -1);
        } else {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new LimiterInputStream(inputStream, n2), "ISO8859_1");
                this.setParam(-1, n, inputStreamReader, n2);
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkDead();
        if (inputStream == null) {
            this.setNull(n, -1);
        } else {
            this.setParam(-1, n, inputStream, n2);
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkDead();
        this.setParam(-4, n, inputStream, n2);
    }

    public void clearParameters() throws SQLException {
        this.checkDead();
        try {
            this._paramMgr.clearParams(true);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.checkDead();
        if (object == null) {
            this.setParam(n2, n, null, n3);
        }
        switch (n2) {
            case -7: {
                this.setParam(n2, n, Convert.objectToBoolean(object), n3);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                this.setParam(n2, n, Convert.objectToInt(object), n3);
                break;
            }
            case -5: {
                this.setParam(n2, n, Convert.objectToLong(object), n3);
                break;
            }
            case 1: 
            case 12: {
                this.setString(n, Convert.objectToString(object));
                break;
            }
            case -1: {
                this.setParam(-1, n, Convert.objectToString(object));
                break;
            }
            case 2: 
            case 3: {
                if (n3 < 0) {
                    ErrorMessage.raiseError("JZ00I");
                }
                this.setParam(n2, n, Convert.objectToBigDecimal(object), n3);
                break;
            }
            case 7: {
                this.setParam(n2, n, Convert.objectToFloat(object), n3);
                break;
            }
            case 6: 
            case 8: {
                this.setParam(n2, n, Convert.objectToDouble(object), n3);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(n, Convert.objectToBytes(object));
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                this.setParam(n2, n, Convert.objectToDateObject(object, n2, null), n3);
                break;
            }
            case 1111: 
            case 2000: {
                if (object instanceof Serializable || object == null) {
                    this.setParam(2000, n, object);
                    break;
                }
            }
            default: {
                ErrorMessage.raiseError("JZ0SE");
            }
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.checkDead();
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.checkDead();
        if (object == null) {
            ErrorMessage.raiseError("JZ0SE");
        }
        if (object instanceof Short) {
            this.setShort(n, (Short)object);
        } else if (object instanceof Byte) {
            this.setByte(n, (Byte)object);
        } else if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof Boolean) {
            this.setParam(-7, n, object);
        } else if (object instanceof Integer) {
            this.setParam(4, n, object);
        } else if (object instanceof Long) {
            this.setParam(-5, n, object);
        } else if (object instanceof Float) {
            this.setParam(7, n, object);
        } else if (object instanceof Double) {
            this.setParam(8, n, object);
        } else if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof Serializable) {
            this.setParam(2000, n, object);
        } else {
            ErrorMessage.raiseError("JZ0SE");
        }
    }

    public void setURL(int n, URL uRL) {
        Debug.notImplemented(this, "setURL(int, URL)");
    }

    public boolean execute() throws SQLException {
        return super.execute(this._query, this._paramMgr);
    }

    public void addBatch() throws SQLException {
        this.checkDead();
        if (this._rpcName != null) {
            this._rpcName = null;
            this._doneinproc = true;
            this._query = "execute " + this._query;
            super.addBatch(this._query);
        } else {
            String string = "execute";
            if (this._query.toLowerCase().startsWith(string)) {
                this._doneinproc = true;
            }
            super.addBatch(this._query);
        }
        if (this._paramCount == 0) {
            this._paramCount = this._paramMgr._params.length;
        }
        if (this._batchParams == null) {
            this._batchParams = new Vector();
        }
        for (int i = 0; i < this._paramCount; ++i) {
            Param param = this._paramMgr._params[i].cloneMe();
            this._batchParams.addElement(param);
        }
    }

    public void addBatch(String string) throws SQLException {
        ErrorMessage.raiseError("JZ0S3", "addBatch(String)");
    }

    public void clearBatch() throws SQLException {
        super.clearBatch();
        this._batchParams = null;
        this._paramCount = 0;
    }

    public int[] executeBatch() throws SQLException {
        this.checkDead();
        if (this._batchCmds == null) {
            return new int[0];
        }
        int[] nArray = new int[this._batchCmds.size()];
        if (this.checkBatch()) {
            int n = 0;
            for (int i = 0; i < this._batchCmds.size(); ++i) {
                ParamManager paramManager = this.countParams((String)this._batchCmds.elementAt(i));
                int n2 = paramManager._params.length;
                for (int j = 0; j < n2; ++j) {
                    Param param = (Param)this._batchParams.elementAt(n);
                    paramManager.setParam(j + 1, param._sqlType, param._inValue, param._scale);
                    ++n;
                }
                try {
                    int[] nArray2 = super.executeBatch(paramManager);
                    nArray[i] = nArray2[0];
                    continue;
                }
                catch (SQLException sQLException) {
                    this.handleBatchException(sQLException, nArray, i);
                }
            }
            this.clearBatch();
            return nArray;
        }
        if (this._dynStmtName != null) {
            return super.executeBatch(null);
        }
        boolean bl = this._context._conn._props.getBoolean(15);
        int n = 0;
        if (!bl) {
            n = this._dbmda == null ? 255 : this._dbmda.getMaxParamsPerBatch();
        }
        if (!bl && this._batchCmdsCount * this._paramCount > n && this._paramCount <= n) {
            int n3;
            int n4 = n / this._paramCount;
            int[] nArray3 = null;
            String string = (String)this._batchCmds.firstElement();
            Vector<String> vector = new Vector<String>();
            for (n3 = 0; n3 < n4; ++n3) {
                vector.add(string);
            }
            this._batchCmds = vector;
            int n5 = 0;
            int n6 = 0;
            int n7 = n4;
            boolean bl2 = false;
            for (n3 = this._batchCmdsCount; n3 > 0; n3 -= n7) {
                int n8;
                if (n3 <= n4) {
                    bl2 = true;
                }
                if (n3 < n4) {
                    vector.clear();
                    for (int i = 0; i < n3; ++i) {
                        vector.add(string);
                    }
                    this._batchCmds = vector;
                    n7 = n3;
                }
                this._batchCmdsCount = n7;
                ParamManager paramManager = this.countParams(this.batchToString());
                for (n8 = 0; n8 < this._paramCount * n7; ++n8) {
                    Param param = (Param)this._batchParams.elementAt(n5);
                    paramManager.setParam(n8 + 1, param._sqlType, param._inValue, param._scale);
                    ++n5;
                }
                try {
                    nArray3 = super.executeBatch(paramManager, bl2);
                }
                catch (SQLException sQLException) {
                    this.handleBatchException(sQLException, nArray, n6);
                }
                for (n8 = 0; n8 < n7; ++n8) {
                    nArray[n6] = nArray3[n8];
                    ++n6;
                }
            }
            return nArray;
        }
        ParamManager paramManager = this.countParams(this.batchToString());
        int n9 = this._batchParams.size();
        for (int i = 0; i < n9; ++i) {
            Param param = (Param)this._batchParams.elementAt(i);
            paramManager.setParam(i + 1, param._sqlType, param._inValue, param._scale);
        }
        return super.executeBatch(paramManager);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkDead();
        this.setParam(-1, n, reader, n2);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        Debug.notSupported(this, "setRef(int, Ref)");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        Debug.notSupported(this, "setBlob(int, Blob)");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        Debug.notSupported(this, "setClob(int, Clob)");
    }

    public void setArray(int n, Array array) throws SQLException {
        Debug.notSupported(this, "setArray(int, Array)");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkDead();
        ResultSetMetaData resultSetMetaData = null;
        if (this._dynStmtName != null) {
            resultSetMetaData = this._protocol.dynamicMetaData(this._context);
        }
        if (resultSetMetaData == null && this._currentRS != null) {
            resultSetMetaData = this._currentRS.getMetaData();
        }
        return resultSetMetaData;
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkDead();
        if (date == null) {
            this.setParam(91, n, date);
        } else {
            this.setParam(91, n, new DateObject(date, calendar, 91));
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.checkDead();
        if (time == null) {
            this.setParam(92, n, time);
        } else {
            this.setParam(92, n, new DateObject(time, calendar, 92));
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkDead();
        if (timestamp == null) {
            this.setParam(93, n, timestamp);
        } else {
            this.setParam(93, n, new DateObject(timestamp, calendar, 93));
        }
    }

    public boolean execute(String string) throws SQLException {
        ErrorMessage.raiseError("JZ0S3", "execute(String)");
        return false;
    }

    private ParamManager countParams(String string) throws SQLException {
        int n = 0;
        int n2 = 0;
        int[] nArray = new int[1000];
        if (this instanceof SybCallableStatement && this._hasReturn) {
            ++n;
        }
        int n3 = string.length();
        block13: for (int i = 0; i < n3; ++i) {
            switch (string.charAt(i)) {
                case '?': {
                    if (n2 != 0) continue block13;
                    nArray[n++] = i;
                    int n4 = nArray.length;
                    if (n < n4) continue block13;
                    int[] nArray2 = new int[n4 += 1000];
                    System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                    nArray = nArray2;
                    continue block13;
                }
                case '\'': {
                    switch (n2) {
                        case 39: {
                            n2 = 0;
                            continue block13;
                        }
                        case 34: {
                            continue block13;
                        }
                    }
                    n2 = 39;
                    continue block13;
                }
                case '\"': {
                    switch (n2) {
                        case 34: {
                            n2 = 0;
                            continue block13;
                        }
                        case 39: {
                            continue block13;
                        }
                    }
                    n2 = 34;
                }
            }
        }
        if (this._batchCmds == null) {
            this._query = string;
        }
        return new ParamManager(n, nArray, this);
    }

    private void setParam(int n, int n2, Object object) throws SQLException {
        this.setParam(n, n2, object, 0);
    }

    private void setParam(int n, int n2, Object object, int n3) throws SQLException {
        this._paramMgr.setParam(n2, n, object, n3);
    }

    public boolean sendQuery(String string, ParamManager paramManager) throws SQLException {
        this.checkDead();
        if (this._dynStmtName != null && !this.checkBatch()) {
            try {
                if (this._batchCmds == null) {
                    this._protocol.dynamicExecute(this._context, this._dynStmtName, paramManager);
                } else {
                    this._protocol.dynamicExecuteBatch(this._context, this._dynStmtName, this.createDynamicExecuteBatchParams());
                }
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
            }
            this._state = 2;
            return false;
        }
        if (this._batchCmds != null) {
            return super.sendQuery(string, paramManager);
        }
        return super.sendQuery(this._query, this._paramMgr);
    }

    public void switchContext(ProtocolContext protocolContext) {
        this._context = protocolContext;
    }

    protected void deallocateDynamic() throws SQLException {
        if (this._dynStmtName != null) {
            this._protocol.dynamicDeallocate(this._context, this._dynStmtName);
        }
    }

    protected Vector createDynamicExecuteBatchParams() throws SQLException {
        Vector<ParamManager> vector = new Vector<ParamManager>();
        int n = 0;
        for (int i = 0; i < this._batchCmds.size(); ++i) {
            ParamManager paramManager = this.countParams((String)this._batchCmds.elementAt(0));
            int n2 = paramManager._params.length;
            for (int j = 0; j < n2; ++j) {
                Param param = (Param)this._batchParams.elementAt(n);
                paramManager.setParam(j + 1, param._sqlType, param._inValue, param._scale);
                ++n;
            }
            vector.add(paramManager);
        }
        return vector;
    }

    protected boolean checkBatch() throws SQLException {
        boolean bl = super.checkBatch();
        boolean bl2 = false;
        if (this._dbmda != null) {
            bl2 = this._dbmda.execParameterizedBatchUpdatesInLoop();
            if (bl2 && this._context._conn._props.getBoolean(15)) {
                bl2 = false;
            }
            bl |= bl2;
        }
        return bl;
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        Debug.notImplemented(this, "getParameterMetaData()");
        return null;
    }

    public String getParameterClassName(int n) throws SQLException {
        Debug.notImplemented(this, "getParameterClassName(int)");
        return null;
    }

    public int getParameterCount() throws SQLException {
        Debug.notImplemented(this, "getParameterCount()");
        return 0;
    }

    public int getParameterMode(int n) throws SQLException {
        Debug.notImplemented(this, "getParameterMode(int)");
        return 0;
    }

    public int getParameterType(int n) throws SQLException {
        Debug.notImplemented(this, "getParameterType(int)");
        return 0;
    }

    public String getParameterTypeName(int n) throws SQLException {
        Debug.notImplemented(this, "getParameterTypeName(int)");
        return null;
    }

    public int getPrecision(int n) throws SQLException {
        Debug.notImplemented(this, "getPrecision(int)");
        return 0;
    }

    public int getScale(int n) throws SQLException {
        Debug.notImplemented(this, "getScale(int)");
        return 0;
    }

    public int isNullable(int n) throws SQLException {
        Debug.notImplemented(this, "isNullable(int)");
        return 0;
    }

    public boolean isSigned(int n) throws SQLException {
        Debug.notImplemented(this, "isSigned(int)");
        return false;
    }
}

