/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.kdom;

import org.kxml.kdom.Element;
import org.kxml.kdom.Node;
import org.kxml.parser.KXML;
import org.kxml.parser.ParseEvent;
import org.kxml.parser.StartTag;
import org.kxml.parser.Tag;

public class TreeParser
extends KXML {
    Position current;
    ParseEvent next;

    public TreeParser(Node node) {
        this.current = new Position(node);
    }

    public TreeParser(Element element, boolean skipRoot) {
        this.current = new Position(element, null);
        if (skipRoot) {
            this.current.index = 0;
            this.current.start = null;
        }
    }

    public ParseEvent read() {
        if (this.next == null) {
            this.peek();
        }
        ParseEvent result = this.next;
        this.next = null;
        return result;
    }

    public ParseEvent peek() {
        if (this.next == null) {
            int i = this.current.index++;
            Node node = this.current.node;
            if (i < 0) {
                this.next = this.current.start;
            } else if (i >= node.getChildCount()) {
                if (this.current.start == null || i > node.getChildCount()) {
                    this.next = new ParseEvent(8, null);
                } else {
                    this.next = new Tag(16, this.current.start, this.current.start.getNamespace(), this.current.start.getName());
                    if (this.current.previous != null) {
                        this.current = this.current.previous;
                    }
                }
            } else {
                int type = node.getType(i);
                if (type == 4) {
                    this.current = new Position(node.getElement(i), this.current);
                    this.next = this.peek();
                } else {
                    this.next = new ParseEvent(type, (String)node.getChild(i));
                }
            }
        }
        return this.next;
    }

    class Position {
        Node node;
        StartTag start;
        int index = -1;
        Position previous;

        Position(Node node) {
            this.node = node;
            this.index = 0;
        }

        Position(Element element, Position prev) {
            this.node = element;
            this.previous = prev;
            this.start = new StartTag(prev == null ? null : prev.start, element.getNamespace(), element.getName(), element.getAttributes(), element.getChildCount() == 0, false);
            this.start.setPrefixMap(element.getPrefixMap());
        }
    }
}

