/*
 * Decompiled with CFR 0.152.
 */
package jun.xml.write;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.util.Stack;
import jun.xml.write.XmlW;
import sun.security.action.GetPropertyAction;

public class XmlWriter {
    private Writer writer;
    private Stack stack;
    private StringBuffer attrs;
    private boolean empty;
    private boolean closed;
    public static String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

    public XmlWriter(Writer writer) {
        this.writer = writer;
        this.closed = true;
        this.stack = new Stack();
    }

    public XmlWriter S(String name) throws Exception {
        return this.writeEntity(name);
    }

    public XmlWriter writeEntity(String name) throws Exception {
        try {
            this.closeOpeningTag();
            this.closed = false;
            this.writer.write("<");
            this.writer.write(name);
            this.stack.add(name);
            this.empty = true;
            return this;
        }
        catch (IOException ioe) {
            throw new Exception(ioe);
        }
    }

    private void closeOpeningTag() throws IOException {
        if (!this.closed) {
            this.writeAttributes();
            this.closed = true;
            this.writer.write(">");
        }
    }

    private void writeAttributes() throws IOException {
        if (this.attrs != null) {
            this.writer.write(this.attrs.toString());
            this.attrs.setLength(0);
            this.empty = false;
        }
    }

    public XmlWriter A(String attr, String value) throws Exception {
        return this.writeAttribute(attr, value);
    }

    public XmlWriter A(String attr, int value) throws Exception {
        return this.writeAttribute(attr, String.valueOf(value));
    }

    public XmlWriter A(String attr, boolean value) throws Exception {
        return this.writeAttribute(attr, String.valueOf(value));
    }

    public XmlWriter writeAttribute(String attr, String value) throws Exception {
        if (this.attrs == null) {
            this.attrs = new StringBuffer();
        }
        this.attrs.append(" ");
        this.attrs.append(attr);
        this.attrs.append("=\"");
        this.attrs.append(XmlW.escapeXml(value));
        this.attrs.append("\"");
        return this;
    }

    public XmlWriter E() throws Exception {
        return this.endEntity();
    }

    public XmlWriter endEntity() throws Exception {
        try {
            if (this.stack.empty()) {
                throw new Exception("Called endEntity too many times. ");
            }
            String name = (String)this.stack.pop();
            if (name != null) {
                if (this.empty) {
                    this.writeAttributes();
                    this.writer.write("/>");
                } else {
                    this.writer.write("</");
                    this.writer.write(name);
                    this.writer.write(">");
                }
                this.writer.write(lineSeparator);
                this.empty = false;
                this.closed = true;
            }
            return this;
        }
        catch (IOException ioe) {
            throw new Exception(ioe);
        }
    }

    public void close() throws Exception {
        if (!this.stack.empty()) {
            throw new Exception("Tags are not all closed. Possibly, " + this.stack.pop() + " is unclosed. ");
        }
    }

    public XmlWriter W(String text) throws Exception {
        return this.writeText(text);
    }

    public XmlWriter writeText(String text) throws Exception {
        try {
            this.closeOpeningTag();
            this.empty = false;
            this.writer.write(XmlW.escapeXml(text));
            return this;
        }
        catch (IOException ioe) {
            throw new Exception(ioe);
        }
    }

    public static void main(String[] args) throws Exception {
        XmlWriter.test1();
        XmlWriter.test2();
    }

    public static void test1() throws Exception {
        StringWriter writer = new StringWriter();
        XmlWriter xmlwriter = new XmlWriter(writer);
        xmlwriter.writeEntity("person").writeAttribute("name", "fred").writeAttribute("age", "12").writeEntity("phone").writeText("4254343").endEntity().writeEntity("bob").endEntity().endEntity();
        xmlwriter.close();
        System.err.println(((Object)writer).toString());
    }

    public static void test2() throws Exception {
        StringWriter writer = new StringWriter();
        XmlWriter xmlwriter = new XmlWriter(writer);
        xmlwriter.writeEntity("person");
        xmlwriter.writeAttribute("name", "fred");
        xmlwriter.writeAttribute("age", "12");
        xmlwriter.writeEntity("phone");
        xmlwriter.writeText("4254343");
        xmlwriter.endEntity();
        xmlwriter.writeEntity("bob");
        xmlwriter.endEntity();
        xmlwriter.endEntity();
        xmlwriter.close();
        System.err.println(((Object)writer).toString());
    }
}

