/*
 * Decompiled with CFR 0.152.
 */
package jun.db.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import jun.db.core.DataAdapter;
import jun.db.core.DataStore;
import jun.db.core.DsSqlInfo;
import jun.db.core.ErrorInfo;
import jun.db.core.Logger;
import jun.db.impl.DataStore_;
import jun.db.impl.ErrorInfo_;
import jun.db.impl.RemoteFactory_;
import jun.db.impl.SingleSqlParse;
import jun.db.util.chardet.nsDetector;
import jun.db.util.chardet.nsICharsetDetectionObserver;
import org.apache.regexp.RE;
import org.nfunk.jep.function.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataStoreFactory {
    private static Object log = null;
    private static HashMap<String, DsSqlInfo> sqlHistory = new HashMap();

    public static void setLogger(Object log) {
        DataStoreFactory.log = log;
    }

    public static Object getLogger() {
        return log;
    }

    public static DataStore newDataStore() {
        DataStore_ ds = new DataStore_();
        return ds;
    }

    public static void addToSQLHistory(String gguid, DsSqlInfo data) {
        sqlHistory.put(gguid, data);
    }

    public static void removeFromSQLHistory(String gguid) {
        sqlHistory.remove(gguid);
    }

    public static HashMap<String, DsSqlInfo> getSQLHistory() {
        return sqlHistory;
    }

    public static DataStore newDataStore(Connection con, String sql) {
        DataStore_ ds = new DataStore_(con, sql);
        return ds;
    }

    public static DataStore newDataStore(Connection con, String sql, String sourceCharset) {
        DataStore_ ds = new DataStore_(con, sql);
        ds.charsetConvert(sourceCharset, "GBK");
        return ds;
    }

    public static DataStore newDataStore(Connection con, String sql, String sourceCharset, String toCharset, int timeout) {
        DataStore_ ds = new DataStore_(con, sql);
        Logger.info(sql);
        ds.setTimeout(timeout);
        ds.charsetConvert(sourceCharset, toCharset);
        if (!sourceCharset.equals("") || !toCharset.equals("")) {
            ds.setCharsetAutoConvert(true);
        }
        return ds;
    }

    public static DataStore newDataStore(String homeURL, String dbPool, String sql, String dbCharset, String charset, int timeout) {
        RemoteFactory_ rf = new RemoteFactory_();
        return rf.newDataStore(homeURL, dbPool, sql, dbCharset, charset, timeout);
    }

    public static ErrorInfo newErrorInfo() {
        ErrorInfo_ err = new ErrorInfo_();
        return err;
    }

    public static String LinkUpWhere(String sqlSource, String whereToLink) {
        return DataStoreFactory.LinkUpWhere(sqlSource, whereToLink, false);
    }

    public static String buildCountSQL(String sqlSource, String whereToLink) {
        return DataStoreFactory.LinkUpWhere(sqlSource, whereToLink, true);
    }

    public static String LinkUpWhere(String sqlSource, String whereToLink, boolean replaceWithCount) {
        String sql;
        if (!replaceWithCount && whereToLink.trim().equals("")) {
            return sqlSource;
        }
        String s = sql = sqlSource;
        String UNION = " UNION ";
        s = String.valueOf(s.toUpperCase()) + UNION;
        ArrayList<String> sqlList = new ArrayList<String>();
        SingleSqlParse sp = new SingleSqlParse();
        int p = s.indexOf(UNION);
        int q = 0;
        int r = 0;
        while (p >= 0) {
            String temp = sql.substring(r, p);
            if (DataStoreFactory.isValidSQL(temp)) {
                sqlList.add(temp);
                r = p + 7;
            }
            q = p + 7;
            p = s.indexOf(UNION, q);
        }
        try {
            StringBuffer sb = new StringBuffer(1024);
            int i = 0;
            while (i < sqlList.size()) {
                sql = sqlList.get(i).toString();
                sp.setSQL(sql);
                sp.Parse();
                String oldWhere = sp.getWhere();
                if (!whereToLink.equals("")) {
                    if (oldWhere.trim().equals("")) {
                        sp.setWhere(whereToLink);
                    } else {
                        String t = "(" + oldWhere + ") and (" + whereToLink + ")";
                        sp.setWhere(t);
                    }
                }
                if (replaceWithCount) {
                    sp.setColumns(" count (*)  ");
                    sp.setOrder("");
                }
                sp.Assemble();
                sql = sp.getSQL();
                if (i > 0) {
                    sb.append("  UNION ");
                }
                sb.append(sql);
                ++i;
            }
            return sb.toString();
        }
        catch (Exception e) {
            Logger.error(e);
            return sqlSource;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean includeInnerParamInFrom(String sqlSource) {
        String sql;
        String s = sql = sqlSource;
        String UNION = " UNION ";
        s = String.valueOf(s.toUpperCase()) + UNION;
        ArrayList<String> sqlList = new ArrayList<String>();
        SingleSqlParse sp = new SingleSqlParse();
        int p = s.indexOf(UNION);
        int q = 0;
        int r = 0;
        while (p >= 0) {
            String temp = sql.substring(r, p);
            if (DataStoreFactory.isValidSQL(temp)) {
                sqlList.add(temp);
                r = p + 7;
            }
            q = p + 7;
            p = s.indexOf(UNION, q);
        }
        try {
            RE re = new RE("\\s*(:\\s*([^\\{]+)\\s*\\{\\s*([^\\}]+)\\s*\\})\\s*");
            StringBuffer sb = new StringBuffer(1024);
            int i = 0;
            while (true) {
                if (i >= sqlList.size()) {
                    return false;
                }
                sql = sqlList.get(i).toString();
                sp.setSQL(sql);
                sp.Parse();
                String from = sp.getTables();
                if (re.match(from)) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Logger.error(e);
            return false;
        }
    }

    static boolean isValidSQL(String sql) {
        int n2;
        int n = 0;
        int p = sql.indexOf("'");
        while (p >= 0) {
            ++n;
            ++p;
            p = sql.indexOf("'", p);
        }
        int k = n % 2;
        if (k != 0) {
            return false;
        }
        String tt = sql;
        tt = tt.replaceAll("''", "");
        String reg = "'([^'])*'";
        tt = tt.replaceAll(reg, "");
        int p1 = tt.length();
        tt = tt.replaceAll("\\(", "");
        int p2 = tt.length();
        int n1 = p1 - p2;
        return n1 == (n2 = p2 - (p1 = (tt = tt.replaceAll("\\)", "")).length()));
    }

    public static String stringCharsetConvert(String source, String sourceCharset, String toCharset) {
        if (source == null) {
            return source;
        }
        if (sourceCharset != null && toCharset != null) {
            if (sourceCharset.equals("")) {
                return source;
            }
            if (toCharset.equals("")) {
                return source;
            }
            try {
                return new String(source.getBytes(sourceCharset), toCharset);
            }
            catch (Exception e) {
                return source;
            }
        }
        return source;
    }

    public static String newGUID() {
        String uuid = new ObjectId().toHexString();
        return uuid;
    }

    public static DataAdapter createDataAdapter(Connection con) {
        return DataStore_.createDataAdapter(con);
    }

    public static boolean isSimplifiedChineseCharset(String file) {
        String charset = DataStoreFactory.charsetDetect(file);
        if (charset.equals("GB18030")) {
            return true;
        }
        if (charset.equals("GB2312")) {
            return true;
        }
        return charset.equals("ASCII");
    }

    public static boolean isUTF8Charset(String file) {
        String charset = DataStoreFactory.charsetDetect(file);
        return charset.equals("UTF-8");
    }

    public static String charsetDetect(String file) {
        String ret = "";
        int lang = 0;
        nsDetector det = new nsDetector(lang);
        class CharsetDetaction
        implements nsICharsetDetectionObserver {
            public String charset = "";

            CharsetDetaction() {
            }

            public void Notify(String charset) {
                this.charset = charset;
            }
        }
        CharsetDetaction cd = new CharsetDetaction();
        det.Init(cd);
        BufferedInputStream imp = null;
        try {
            try {
                int len;
                imp = new BufferedInputStream(new FileInputStream(new File(file)));
                byte[] buf = new byte[1024];
                boolean done = false;
                boolean isAscii = true;
                while ((len = imp.read(buf, 0, buf.length)) != -1) {
                    if (isAscii) {
                        isAscii = det.isAscii(buf, len);
                    }
                    if (isAscii || done) continue;
                    done = det.DoIt(buf, len, false);
                }
                det.DataEnd();
                if (!cd.charset.equals("")) {
                    ret = cd.charset;
                } else if (isAscii) {
                    ret = "ASCII";
                } else {
                    String[] prob = det.getProbableCharsets();
                    if (prob.length > 1) {
                        ret = prob[0];
                    }
                }
            }
            catch (Exception exception) {
                try {
                    if (imp != null) {
                        imp.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (ret.equals("GB18030")) {
                    ret = "GBK";
                }
                if (ret.equals("GB2312")) {
                    ret = "GBK";
                }
                if (!ret.equals("UTF-8") && !ret.equals("ASCII")) {
                    ret = "GBK";
                }
            }
        }
        finally {
            try {
                if (imp != null) {
                    imp.close();
                }
            }
            catch (Exception exception) {}
            if (ret.equals("GB18030")) {
                ret = "GBK";
            }
            if (ret.equals("GB2312")) {
                ret = "GBK";
            }
            if (!ret.equals("UTF-8") && !ret.equals("ASCII")) {
                ret = "GBK";
            }
        }
        return ret;
    }
}

