/*
 * Decompiled with CFR 0.152.
 */
package jun.db.impl;

import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFReader;
import com.linuxense.javadbf.DBFWriter;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.security.AccessController;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jun.csv.CsvReader;
import jun.db.core.ColumnProperty;
import jun.db.core.DataBuffer;
import jun.db.core.DsRow;
import jun.db.core.Logger;
import jun.db.core.ObjectTool;
import jun.db.impl.AggregateDefine;
import jun.db.impl.ColumnProperty_;
import jun.db.impl.DataStoreFactory;
import jun.db.impl.DataStore_;
import jun.db.impl.DsItem;
import jun.db.impl.DsRow_;
import jun.db.impl.OrderByConfig;
import jun.db.impl.ReadXML;
import jun.db.util.Escape;
import jun.db.util.ZDataParser;
import jun.xml.write.XmlWriter;
import org.json.JSONObject;
import org.nfunk.jep.JEP;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import sun.security.action.GetPropertyAction;

class DataBuffer_
implements Comparator,
Serializable,
DataBuffer {
    private ArrayList m_Buffer = null;
    private DataStore_ m_ds = null;
    private int m_ColumnCount = 0;

    public DataBuffer_() {
        this.Init();
    }

    public DataBuffer_(int colCount, DataStore_ ds) {
        this.Init();
        this.m_ColumnCount = colCount;
        this.m_ds = ds;
        this.m_Buffer = new ArrayList();
    }

    private void Init() {
    }

    void InitColumnCount(int c) {
        this.m_ColumnCount = c;
    }

    void clear() {
        if (this.m_Buffer == null) {
            return;
        }
        this.m_Buffer.clear();
    }

    ArrayList GetBuffer() {
        return this.m_Buffer;
    }

    public DsItem getItem(int row, String col) {
        return this.getItem(row, this.m_ds.col2Index(col));
    }

    public DsItem getItem(int row, int col) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        if (col < 0 || col >= this.m_ds.getColumnCount()) {
            return null;
        }
        DsRow_ dr = (DsRow_)this.m_Buffer.get(row);
        DsItem item = dr.GetAt(col);
        return item;
    }

    public int getItemStatus(int row, String col) {
        return this.getItemStatus(row, this.m_ds.col2Index(col));
    }

    public int getItemStatus(int row, int col) {
        DsItem item = this.getItem(row, col);
        if (item != null) {
            return item.m_ItemStatus;
        }
        int rowStatus = this.getRow(row).getRowStatus();
        switch (rowStatus) {
            case 0: 
            case 1: {
                return 0;
            }
            case 2: 
            case 3: {
                return 2;
            }
        }
        return 2;
    }

    public void setItemStatus(int row, String col, int status) {
        this.setItemStatus(row, this.m_ds.col2Index(col), status);
    }

    public void setItemStatus(int row, int col, int status) {
        DsItem item = this.getItem(row, col);
        if (item == null) {
            return;
        }
        item.m_ItemStatus = (byte)status;
    }

    public ColumnProperty getColumnProperty(int col) {
        return (ColumnProperty_)this.m_ds.m_ColumnProperty.get(col);
    }

    public DsRow getRow(int row) {
        if (row < 0) {
            return null;
        }
        if (row >= this.getRowCount()) {
            return null;
        }
        return (DsRow_)this.m_Buffer.get(row);
    }

    void EraseRow(int row) {
        this.m_Buffer.remove(row);
    }

    public Object getValue(int row, int col) {
        return this.getValue(row, col, false);
    }

    public Object getValue(int row, String col) {
        return this.getValue(row, col, false);
    }

    public Object getValue(int row, String col, boolean origina) {
        int colIndex = this.m_ds.col2Index(col);
        if (colIndex < 0) {
            return null;
        }
        return this.getValue(row, colIndex, origina);
    }

    public Object getValue(int row, int col, boolean original) {
        if (row >= this.m_Buffer.size() || row < 0) {
            return null;
        }
        DsRow_ dr = (DsRow_)this.m_Buffer.get(row);
        if (col < 0 || col > dr.m_Items.size()) {
            return null;
        }
        DsItem item = dr.GetAt(col);
        ColumnProperty_ cp = (ColumnProperty_)this.getColumnProperty(col);
        this.m_ds.getEvent().fireBeforeGetValue(row, cp.m_Name);
        if (cp.m_ObjType == 2) {
            return this.GetUserComputerValue(row, col);
        }
        if (cp.m_ObjType == 8) {
            return this.GetAggregateComputerValue(row, col);
        }
        if (item == null) {
            return null;
        }
        Object retValue = null;
        retValue = original ? this.ObjectClone(item.m_OriginalValue) : this.ObjectClone(item.m_CurrentValue);
        return retValue;
    }

    final DsItem NEW_ITEM(DsItem item, DsRow_ pRow, int col) {
        if (item != null) {
            return item;
        }
        item = new DsItem();
        pRow.set(col, item);
        if (pRow.m_RowStatus == 2 || pRow.m_RowStatus == 3) {
            item.m_ItemStatus = (byte)2;
        }
        if (pRow.m_RowStatus == 0 || pRow.m_RowStatus == 1) {
            item.m_ItemStatus = 0;
        }
        return item;
    }

    Object GetUserComputerValue(int row, int col) {
        DsRow_ dr = (DsRow_)this.m_Buffer.get(row);
        DsItem item = dr.GetAt(col);
        ColumnProperty_ pCP = (ColumnProperty_)this.getColumnProperty(col);
        if (item == null) {
            item = this.NEW_ITEM(item, dr, col);
            item.m_ItemStatus = (byte)5;
        }
        if (pCP.m_ObjType != 2) {
            return this.ObjectClone(item.m_CurrentValue);
        }
        if (item.m_ItemStatus == 4 && !pCP.m_IncludeUnsureFunction) {
            return this.ObjectClone(item.m_CurrentValue);
        }
        this.InternalRecalculateComputer(item, pCP.m_Formula, pCP.m_DependMap, row);
        return this.ObjectClone(item.m_CurrentValue);
    }

    void InternalRecalculateComputer(DsItem item, String expression, Hashtable dependMap, int row) {
        item.m_CurrentValue = this.Eval(expression, dependMap, row);
        item.m_ItemStatus = (byte)4;
    }

    Object GetAggregateComputerValue(int row, int col) {
        DsRow_ dr;
        DsItem item;
        ColumnProperty_ pCP = (ColumnProperty_)this.getColumnProperty(col);
        if (pCP.m_ObjType != 8) {
            return this.getValue(row, col);
        }
        int GroupNo = pCP.m_AggregateDefine.m_GroupNo;
        if (GroupNo < 0 || GroupNo > this.m_ds.m_VectorGroups.size() - 1) {
            return null;
        }
        Point range = this.AggregateRange(row, GroupNo);
        if (pCP.m_AggregateDefine.m_AggregateType != 11) {
            row = range.x;
        }
        if ((item = (dr = (DsRow_)this.m_Buffer.get(row)).GetAt(col)) == null) {
            item = this.NEW_ITEM(item, dr, col);
            item.m_ItemStatus = (byte)5;
        }
        if (item.m_ItemStatus == 4) {
            return this.ObjectClone(item.m_CurrentValue);
        }
        Object v = null;
        v = this.Eval(pCP.m_Formula, pCP.m_DependMap, row, pCP.m_AggregateDefine, range);
        item.m_ItemStatus = (byte)4;
        item.m_CurrentValue = v;
        return this.ObjectClone(v);
    }

    Point AggregateRange(int row, int groupNo) {
        Point ret = new Point(0, 0);
        if (groupNo < 0 || groupNo > this.m_ds.m_VectorGroups.size() - 1) {
            return ret;
        }
        ArrayList pV = (ArrayList)this.m_ds.m_VectorGroups.get(groupNo);
        int n = pV.size();
        int i = 0;
        while (i < n) {
            int r = (Integer)pV.get(i);
            if (r > row) {
                ret.x = (Integer)pV.get(i - 1);
                ret.y = r - 1;
                return ret;
            }
            ++i;
        }
        ret.x = (Integer)pV.get(n - 1);
        ret.y = this.getRowCount() - 1;
        return ret;
    }

    Object Eval2(String expression, Hashtable dependMap, int row) {
        return null;
    }

    Object Eval(String expression, Hashtable dependMap, int row) {
        Iterator keyIterator;
        JEP p = new JEP();
        p.addStandardFunctions();
        if (dependMap != null && (keyIterator = dependMap.keySet().iterator()) != null) {
            while (keyIterator.hasNext()) {
                String dependCol = (String)keyIterator.next();
                int colIndex = this.m_ds.col2Index(dependCol);
                Object v = this.getValue(row, colIndex);
                if (v == null) {
                    v = this.m_ds.getColumnProperty(colIndex).getValueInsteadOfNull();
                }
                try {
                    p.addVariableAsObject(dependCol, v);
                }
                catch (Exception e) {
                    String s = e.getMessage();
                    if (s == null) {
                        s = "";
                    }
                    String ers = "DataStore\u89e3\u6790\u8868\u8fbe\u5f0f\u51fa\u9519\uff1a" + expression + "  \u9519\u8bef\u7c7b\u578b\uff1a" + e.getClass().getName() + "  \u9519\u8bef\u4fe1\u606f\uff1a" + s;
                    Logger.error(ers);
                    this.m_ds.getError().parseError(e, this.m_ds.getEvent());
                    return ers;
                }
            }
        }
        try {
            p.addVariableAsObject(JEP.Datastore_internal_thisrow, (Object)new Integer(row + this.m_ds.getAbsolute() - 1));
            p.addVariableAsObject(JEP.Datastore_internal_rowcount, (Object)new Integer(this.getRowCount()));
            p.addVariableAsObject(JEP.Datastore_internal_absolute, (Object)new Integer(this.m_ds.getAbsolute()));
            p.parseExpression(expression);
            return p.getValueAsObject();
        }
        catch (Exception e) {
            String s = e.getMessage();
            if (s == null) {
                s = "";
            }
            String ers = "DataStore\u89e3\u6790\u8868\u8fbe\u5f0f\u51fa\u9519\uff1a" + expression + "  \u9519\u8bef\u7c7b\u578b\uff1a" + e.getClass().getName() + "  \u9519\u8bef\u4fe1\u606f\uff1a" + s;
            Logger.error(ers);
            this.m_ds.getError().parseError(e, this.m_ds.getEvent());
            return ers;
        }
    }

    Object Eval(String expression, Hashtable pDependMap, int row, AggregateDefine pDefine, Point range) {
        int colIndex = this.m_ds.col2Index(expression);
        int GroupNo = pDefine.m_GroupNo;
        if (GroupNo < 0 || GroupNo > this.m_ds.m_VectorGroups.size() - 1) {
            return null;
        }
        switch (pDefine.m_AggregateType) {
            case 0: {
                return this.Aggregate_Sum(expression, pDependMap, range, colIndex);
            }
            case 1: {
                return this.Aggregate_Count(expression, pDependMap, range, colIndex);
            }
            case 2: {
                return this.Aggregate_List(expression, pDependMap, range, colIndex);
            }
            case 3: {
                return this.Aggregate_DistinctSum(expression, pDependMap, range, colIndex);
            }
            case 4: {
                return this.Aggregate_DistinctCount(expression, pDependMap, range, colIndex);
            }
            case 5: {
                return this.Aggregate_DistinctList(expression, pDependMap, range, colIndex);
            }
            case 6: {
                return this.Aggregate_Max(expression, pDependMap, range, colIndex);
            }
            case 7: {
                return this.Aggregate_Min(expression, pDependMap, range, colIndex);
            }
            case 8: {
                return this.Aggregate_Avg(expression, pDependMap, range, colIndex);
            }
            case 9: {
                return this.Aggregate_FirstRow(expression, pDependMap, range, colIndex);
            }
            case 10: {
                return this.Aggregate_LastRow(expression, pDependMap, range, colIndex);
            }
            case 11: {
                return this.Aggregate_Cumulative(expression, pDependMap, range, row, colIndex);
            }
        }
        return null;
    }

    Object Aggregate_Sum(String expression, Hashtable pDependMap, Point range, int colIndex) {
        Object v = null;
        Object v2 = null;
        int i = range.x;
        while (i <= range.y) {
            v2 = colIndex < 0 ? this.Eval(expression, pDependMap, i) : this.getValue(i, colIndex);
            try {
                v = ObjectTool.Add(v, v2);
            }
            catch (Exception e) {
                this.m_ds.getError().parseError(e, this.m_ds.getEvent());
                return null;
            }
            ++i;
        }
        return v;
    }

    Object Aggregate_Cumulative(String expression, Hashtable pDependMap, Point range, int row, int colIndex) {
        Object v = null;
        Object v2 = null;
        v2 = colIndex < 0 ? this.Eval(expression, pDependMap, row) : this.getValue(row, colIndex);
        if (row == range.x) {
            return v2;
        }
        v = this.Aggregate_Cumulative(expression, pDependMap, range, row - 1, colIndex);
        try {
            v = ObjectTool.Add(v, v2);
        }
        catch (Exception e) {
            this.m_ds.getError().parseError(e, this.m_ds.getEvent());
            return null;
        }
        return v;
    }

    Object Aggregate_FirstRow(String expression, Hashtable pDependMap, Point range, int colIndex) {
        return new Integer(range.x);
    }

    Object Aggregate_LastRow(String expression, Hashtable pDependMap, Point range, int colIndex) {
        return new Integer(range.y);
    }

    Object Aggregate_Avg(String expression, Hashtable pDependMap, Point range, int colIndex) {
        Object v = null;
        Object v2 = null;
        int nullCount = 0;
        int i = range.x;
        while (i <= range.y) {
            v2 = colIndex < 0 ? this.Eval(expression, pDependMap, i) : this.getValue(i, colIndex);
            if (v2 == null) {
                ++nullCount;
            }
            try {
                v = ObjectTool.Add(v, v2);
            }
            catch (Exception e) {
                this.m_ds.getError().parseError(e, this.m_ds.getEvent());
                return null;
            }
            ++i;
        }
        if (range.y - range.x + 1 - nullCount == 0) {
            return new Double(0.0);
        }
        try {
            return ObjectTool.Div(v, range.y - range.x + 1 - nullCount);
        }
        catch (Exception e) {
            this.m_ds.getError().parseError(e, this.m_ds.getEvent());
            return null;
        }
    }

    Object Aggregate_Max(String expression, Hashtable pDependMap, Point range, int colIndex) {
        Object v = null;
        Object v2 = null;
        int i = range.x;
        while (i <= range.y) {
            v2 = colIndex < 0 ? this.Eval(expression, pDependMap, i) : this.getValue(i, colIndex);
            if (v2 != null) {
                if (v == null) {
                    v = v2;
                } else if (this.ObjectCompare(v, v2) < 0) {
                    v = v2;
                }
            }
            ++i;
        }
        return v;
    }

    Object Aggregate_Min(String expression, Hashtable pDependMap, Point range, int colIndex) {
        Object v = null;
        Object v2 = null;
        int i = range.x;
        while (i <= range.y) {
            v2 = colIndex < 0 ? this.Eval(expression, pDependMap, i) : this.getValue(i, colIndex);
            if (v2 != null) {
                if (v == null) {
                    v = v2;
                } else if (this.ObjectCompare(v, v2) > 0) {
                    v = v2;
                }
            }
            ++i;
        }
        return v;
    }

    Object Aggregate_Count(String expression, Hashtable pDependMap, Point range, int colIndex) {
        return new Integer(range.y - range.x + 1);
    }

    Object Aggregate_List(String expression, Hashtable pDependMap, Point range, int colIndex) {
        String v = "";
        Object v2 = null;
        int i = range.x;
        while (i <= range.y) {
            v2 = colIndex < 0 ? this.Eval(expression, pDependMap, i) : this.getValue(i, colIndex);
            if (v2 != null) {
                v = v.equals("") ? v2.toString() : String.valueOf(v) + ", " + v2.toString();
            }
            ++i;
        }
        return v;
    }

    Object Aggregate_DistinctList(String expression, Hashtable pDependMap, Point range, int colIndex) {
        String v = "";
        Object v2 = null;
        Hashtable<String, String> distinctMap = new Hashtable<String, String>();
        int i = range.x;
        while (i <= range.y) {
            String key;
            v2 = colIndex < 0 ? this.Eval(expression, pDependMap, i) : this.getValue(i, colIndex);
            if (v2 != null && !distinctMap.containsKey(key = v2.toString())) {
                distinctMap.put(key, "");
                v = v.equals("") ? key : String.valueOf(v) + ", " + key;
            }
            ++i;
        }
        return v;
    }

    Object Aggregate_DistinctSum(String expression, Hashtable pDependMap, Point range, int colIndex) {
        Object v = null;
        Object v2 = null;
        Hashtable<String, String> distinctMap = new Hashtable<String, String>();
        int i = range.x;
        while (i <= range.y) {
            v2 = colIndex < 0 ? this.Eval(expression, pDependMap, i) : this.getValue(i, colIndex);
            if (v2 != null) {
                try {
                    String key = v2.toString();
                    if (!distinctMap.containsKey(key)) {
                        distinctMap.put(key, "");
                        v = ObjectTool.Add(v, v2);
                    }
                }
                catch (Exception e) {
                    this.m_ds.getError().parseError(e, this.m_ds.getEvent());
                    return null;
                }
            }
            ++i;
        }
        return v;
    }

    Object Aggregate_DistinctCount(String expression, Hashtable pDependMap, Point range, int colIndex) {
        Object v = null;
        Object v2 = null;
        Hashtable<String, String> distinctMap = new Hashtable<String, String>();
        int i = range.x;
        while (i <= range.y) {
            v2 = colIndex < 0 ? this.Eval(expression, pDependMap, i) : this.getValue(i, colIndex);
            if (v2 == null) {
                distinctMap.put("490AD7BA-516C-4fcd-BFDB-43277D3B581E", "");
            }
            String key = v2.toString();
            distinctMap.put(key, "");
            ++i;
        }
        return new Integer(distinctMap.size());
    }

    public Object evaluate(String expression, int row) {
        ArrayList dc = new ArrayList();
        this.m_ds.assembleDependColumns(expression, dc);
        ColumnProperty_ pDependCP = null;
        Hashtable DependMap = null;
        String lcaseExpress = expression.toLowerCase();
        if (this.m_ds.m_DepentList2DependCol.containsKey(lcaseExpress)) {
            DependMap = (Hashtable)this.m_ds.m_DepentList2DependCol.get(lcaseExpress);
        } else {
            DependMap = new Hashtable();
            int n = dc.size();
            int i = 0;
            while (i < n) {
                String t2 = (String)dc.get(i);
                if (!t2.equals("")) {
                    int colIndex = this.m_ds.col2Index(t2);
                    if (colIndex < 0) {
                        this.m_ds.m_Error.parseError("\u4e0d\u5b58\u5728\u5217" + t2, this.m_ds.getEvent());
                        return null;
                    }
                    pDependCP = (ColumnProperty_)this.getColumnProperty(colIndex);
                    DependMap.put(pDependCP.m_Name, new Boolean(true));
                }
                ++i;
            }
            this.m_ds.m_DepentList2DependCol.put(lcaseExpress, DependMap);
        }
        return this.Eval(expression, DependMap, row);
    }

    int size() {
        return this.m_Buffer.size();
    }

    public int getRowCount() {
        return this.size();
    }

    public int getColumnCount() {
        return this.m_ColumnCount;
    }

    void push_back(DsRow r) {
        this.m_Buffer.add(r);
    }

    void AppendColumn() {
        ++this.m_ColumnCount;
        int n = this.m_Buffer.size();
        int i = 0;
        while (i < n) {
            ((DsRow_)this.m_Buffer.get((int)i)).m_Items.add(null);
            ++i;
        }
    }

    int InsertRow(int beforeRow, DsRow dr) {
        int rc = this.getRowCount();
        if (beforeRow >= rc) {
            this.push_back(dr);
            return this.getRowCount() - 1;
        }
        this.m_Buffer.add(beforeRow, dr);
        return beforeRow;
    }

    public boolean setValue(int row, int col, Object v) {
        if (row < 0) {
            return false;
        }
        if (row >= this.getRowCount()) {
            return false;
        }
        DsRow_ dr = (DsRow_)this.getRow(row);
        DsItem item = this.getItem(row, col);
        ColumnProperty_ pCP = (ColumnProperty_)this.getColumnProperty(col);
        if (pCP.m_ObjType == 2) {
            return false;
        }
        if (pCP.m_ObjType == 8) {
            return false;
        }
        if (item == null) {
            item = this.NEW_ITEM(item, dr, col);
        }
        if (item.m_CurrentValue == null && v == null) {
            return true;
        }
        Object newValue = null;
        try {
            newValue = this.ChangeType(v, this.m_ds.getDataAdapter().DTN2JTN(pCP.m_DataTypeName, pCP));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Object lastValue = item.m_CurrentValue;
        if (lastValue == null && newValue == null) {
            return true;
        }
        if (item.m_CurrentValue != null && newValue != null && this.ObjectCompare(item.m_CurrentValue, newValue) == 0) {
            return true;
        }
        if (this.m_ds.m_SetValueWithTrigger && !this.m_ds.getEvent().fireItemChangeAccept(row, pCP.m_Name, this.ObjectClone(newValue))) {
            return false;
        }
        item.m_CurrentValue = newValue;
        item.m_isEdited = 1;
        switch (item.m_ItemStatus) {
            case 0: {
                item.m_ItemStatus = 1;
                if (pCP.m_ObjType != 0) break;
                dr.m_RowStatus = 1;
                break;
            }
            case 1: {
                int st;
                ColumnProperty_ tCP;
                if (item.m_CurrentValue == null && item.m_OriginalValue != null || item.m_CurrentValue != null && item.m_OriginalValue == null) break;
                boolean needSetRowState = false;
                if (item.m_CurrentValue == null && item.m_OriginalValue == null) {
                    item.m_ItemStatus = 0;
                    needSetRowState = true;
                }
                if (item.m_CurrentValue != null && item.m_OriginalValue != null && this.ObjectCompare(item.m_CurrentValue, item.m_OriginalValue) == 0) {
                    item.m_ItemStatus = 0;
                    needSetRowState = true;
                }
                if (!needSetRowState) break;
                boolean allIsNotModified = true;
                int ti = 0;
                while (ti < this.getColumnCount()) {
                    tCP = (ColumnProperty_)this.getColumnProperty(ti);
                    if (tCP.m_ObjType == 0 && (st = this.getItemStatus(row, ti)) == 1) {
                        allIsNotModified = false;
                        break;
                    }
                    ++ti;
                }
                if (!allIsNotModified) break;
                dr.m_RowStatus = 0;
                break;
            }
            case 2: {
                item.m_ItemStatus = (byte)3;
                if (pCP.m_ObjType != 0) break;
                dr.m_RowStatus = 3;
                break;
            }
            case 3: {
                int st;
                ColumnProperty_ tCP;
                if (item.m_CurrentValue == null && item.m_OriginalValue != null || item.m_CurrentValue != null && item.m_OriginalValue == null) break;
                boolean needSetRowState = false;
                if (item.m_CurrentValue == null && item.m_OriginalValue == null) {
                    item.m_ItemStatus = (byte)2;
                    needSetRowState = true;
                }
                if (item.m_CurrentValue != null && item.m_OriginalValue != null && this.ObjectCompare(item.m_CurrentValue, item.m_OriginalValue) == 0) {
                    item.m_ItemStatus = (byte)2;
                    needSetRowState = true;
                }
                if (!needSetRowState) break;
                boolean allIsNotModified = true;
                int ti = 0;
                while (ti < this.getColumnCount()) {
                    tCP = (ColumnProperty_)this.getColumnProperty(ti);
                    if (tCP.m_ObjType == 0 && (st = this.getItemStatus(row, ti)) == 3) {
                        allIsNotModified = false;
                        break;
                    }
                    ++ti;
                }
                if (!allIsNotModified) break;
                dr.m_RowStatus = 2;
            }
        }
        if (this.m_ds.m_SetValueWithTrigger) {
            this.m_ds.getEvent().fireItemChanged(row, pCP.m_Name, lastValue, this.ObjectClone(newValue));
        }
        Hashtable ChangedComputer = new Hashtable();
        this.NotifyAffectCellInvalid(row, pCP, ChangedComputer);
        for (String computer : ChangedComputer.keySet()) {
            int fillBackIndex;
            int ci;
            ColumnProperty_ cpCP;
            String fillback;
            if (this.m_ds.m_SetValueWithTrigger) {
                this.m_ds.getEvent().fireComputerChanged((Integer)ChangedComputer.get(computer), computer);
            }
            if ((fillback = (cpCP = (ColumnProperty_)this.getColumnProperty(ci = this.m_ds.col2Index(computer))).getFillBack()).equals("") || (fillBackIndex = this.m_ds.col2Index(fillback)) < 0 || fillBackIndex == col) continue;
            this.setValue(row, fillBackIndex, this.getValue(row, ci));
        }
        ChangedComputer.clear();
        return true;
    }

    void NotifyAffectCellInvalid(int row, ColumnProperty_ pCP, Hashtable ChangedComputerMap) {
        if (pCP.m_AffectMap == null) {
            return;
        }
        Iterator pAffect = pCP.m_AffectMap.keySet().iterator();
        int rc = this.getRowCount();
        while (pAffect.hasNext()) {
            DsItem pItem;
            int i;
            String affectCol = (String)pAffect.next();
            int colIndex = this.m_ds.col2Index(affectCol);
            if (ChangedComputerMap.contains(affectCol)) continue;
            ChangedComputerMap.put(affectCol, new Integer(row));
            ColumnProperty_ affectCP = (ColumnProperty_)this.getColumnProperty(colIndex);
            if (affectCP.m_ObjType == 8) {
                ChangedComputerMap.put(affectCol, new Integer(-1));
                i = 0;
                while (i < rc) {
                    pItem = this.getItem(i, colIndex);
                    if (pItem != null) {
                        pItem.m_ItemStatus = (byte)5;
                    }
                    ++i;
                }
                this.NotifyAffectCellInvalid(-1, affectCP, ChangedComputerMap);
                continue;
            }
            if (row < 0) {
                i = 0;
                while (i < rc) {
                    pItem = this.getItem(i, colIndex);
                    if (pItem != null) {
                        pItem.m_ItemStatus = (byte)5;
                    }
                    ++i;
                }
            } else {
                pItem = this.getItem(row, colIndex);
                if (pItem != null) {
                    pItem.m_ItemStatus = (byte)5;
                }
            }
            this.NotifyAffectCellInvalid(row, affectCP, ChangedComputerMap);
        }
    }

    void notifyAggregateAndUnsureComputerInvalid() {
        int r;
        if (!this.m_ds.isNeedNotifyAggregateAndUnsureComputerInvalid()) {
            return;
        }
        Hashtable<String, Integer> ChangedComputer = new Hashtable<String, Integer>();
        int cc = this.getColumnCount();
        int rc = this.getRowCount();
        int i = 0;
        while (i < cc) {
            ColumnProperty_ pCP = (ColumnProperty_)this.getColumnProperty(i);
            if (pCP.m_ObjType == 8 || pCP.isIncludeUnsureFunction()) {
                r = 0;
                while (r < rc) {
                    DsItem pItem = this.getItem(r, i);
                    if (pItem != null) {
                        pItem.m_ItemStatus = (byte)5;
                    }
                    ++r;
                }
                ChangedComputer.put(pCP.getName(), new Integer(-1));
                this.NotifyAffectCellInvalid(-1, pCP, ChangedComputer);
            }
            ++i;
        }
        for (String computer : ChangedComputer.keySet()) {
            int fillBackIndex;
            int ci;
            ColumnProperty_ cpCP;
            String fillback;
            if (this.m_ds.m_SetValueWithTrigger) {
                this.m_ds.getEvent().fireComputerChanged((Integer)ChangedComputer.get(computer), computer);
            }
            if ((fillback = (cpCP = (ColumnProperty_)this.getColumnProperty(ci = this.m_ds.col2Index(computer))).getFillBack()).equals("") || (fillBackIndex = this.m_ds.col2Index(fillback)) < 0) continue;
            r = 0;
            while (r < rc) {
                this.setValue(r, fillBackIndex, this.getValue(r, ci));
                ++r;
            }
        }
        ChangedComputer.clear();
    }

    private boolean IsOneOfPrimaryKey(String colName) {
        String col = "";
        col = col.concat(colName);
        col = "," + col.trim().toLowerCase() + ",";
        String pk = "";
        return (pk = "," + pk.concat(this.m_ds.m_PrimaryKey).trim().toLowerCase() + ",").indexOf(col) >= 0;
    }

    String GetFormatedTextValue(DsItem pItem, ColumnProperty_ pCP, boolean original) {
        if (pItem == null) {
            return this.m_ds.getDataAdapter().getFormatedTextValue(null, pCP.m_DataType, pCP.Scale);
        }
        return this.m_ds.getDataAdapter().getFormatedTextValue(original ? pItem.m_OriginalValue : pItem.m_CurrentValue, pCP.m_DataType, pCP.Scale);
    }

    String GetFormatedTextValue(DsItem pItem, ColumnProperty_ pCP) {
        return this.GetFormatedTextValue(pItem, pCP, false);
    }

    public String getFormatedValue(int row, String col, boolean original) {
        return this.getFormatedValue(row, this.m_ds.col2Index(col), original);
    }

    public String getFormatedValue(int row, int col, boolean original) {
        DsItem item = this.getItem(row, col);
        if (item == null) {
            return "";
        }
        ColumnProperty_ cp = (ColumnProperty_)this.getColumnProperty(col);
        return this.GetFormatedTextValue(item, cp, original);
    }

    String AsserbleSQLDelete(int row) throws Exception {
        DsRow_ pRow = (DsRow_)this.m_Buffer.get(row);
        int n = this.getColumnCount();
        String sql = "";
        String WhereClause = "";
        String temp = "";
        if (pRow.m_RowStatus == 2 || pRow.m_RowStatus == 3) {
            return "";
        }
        int i = 0;
        while (i < n) {
            ColumnProperty_ pCP = (ColumnProperty_)this.getColumnProperty(i);
            if (this.IsOneOfPrimaryKey(pCP.m_DBName)) {
                DsItem pItem = pRow.GetAt(i);
                temp = pItem == null ? String.valueOf(pCP.m_DBName) + " is NULL" : ((temp = this.GetFormatedTextValue(pItem, pCP, true)).equals("NULL") ? String.valueOf(pCP.m_DBName) + " is NULL" : String.valueOf(pCP.m_DBName) + " = " + temp);
                WhereClause = WhereClause.equals("") ? temp : String.valueOf(WhereClause) + " and " + temp;
            }
            ++i;
        }
        sql = "Delete From  " + this.m_ds.m_UpdateTable;
        if (WhereClause.equals("")) {
            throw new Exception("\u6ca1\u6709\u7528\u4e8e\u6784\u5efawhere\u5b50\u53e5\u7684\u5b57\u6bb5");
        }
        sql = String.valueOf(sql) + "  Where (" + WhereClause + ")";
        return sql;
    }

    private String assemblePrimaryKeyWhere(int row) {
        String WhereClause = "";
        String temp = "";
        DsRow_ pRow = (DsRow_)this.m_Buffer.get(row);
        int n = this.getColumnCount();
        int i = 0;
        while (i < n) {
            ColumnProperty_ pCP = (ColumnProperty_)this.getColumnProperty(i);
            if (this.IsOneOfPrimaryKey(pCP.m_DBName)) {
                DsItem pItem = pRow.GetAt(i);
                if (pItem == null) {
                    temp = String.valueOf(pCP.m_DBName) + " is NULL";
                } else {
                    temp = this.GetFormatedTextValue(pItem, pCP, true);
                    if (temp.equals("NULL")) {
                        temp = this.GetFormatedTextValue(pItem, pCP, false);
                    }
                    temp = temp.equals("NULL") ? String.valueOf(pCP.m_DBName) + " is NULL" : String.valueOf(pCP.m_DBName) + " = " + temp;
                }
                WhereClause = WhereClause.equals("") ? temp : String.valueOf(WhereClause) + " and " + temp;
            }
            ++i;
        }
        return WhereClause;
    }

    ArrayList AsserbleSQLInsert(int row) throws Exception {
        int clobColumnCount;
        DsRow_ pRow = (DsRow_)this.getRow(row);
        int n = this.getColumnCount();
        String ColClause = "";
        String ValueClause = "";
        boolean isOracle = this.m_ds.getDataAdapter().isOracle();
        boolean isPosgtres = this.m_ds.getDataAdapter().isPostgres();
        ArrayList<String> clobColumnList = new ArrayList<String>();
        int i = 0;
        while (i < n) {
            DsItem pItem;
            ColumnProperty_ pCP = (ColumnProperty_)this.getColumnProperty(i);
            if (pCP.m_Updatable) {
                pItem = pRow.GetAt(i);
                if (pItem != null && pItem.m_ItemStatus != 2 && pCP.getObjType() == 0) {
                    String value = this.GetFormatedTextValue(pItem, pCP);
                    if (pCP.m_DataType == 2005 && isOracle && value.length() > 1500) {
                        value = pItem.m_CurrentValue.toString();
                        ZDataParser zdp = new ZDataParser();
                        zdp.put("table", this.m_ds.m_UpdateTable);
                        zdp.put("col", pCP.m_DBName);
                        zdp.put("value", value);
                        clobColumnList.add(zdp.toString());
                        value = "EMPTY_CLOB()";
                    }
                    ColClause = ColClause.equals("") ? pCP.m_DBName : String.valueOf(ColClause) + "," + pCP.m_DBName;
                    ValueClause = ValueClause.equals("") ? value : String.valueOf(ValueClause) + "," + value;
                }
            } else if (pCP.m_DBName.equalsIgnoreCase("id") && (isOracle || isPosgtres)) {
                ColClause = ColClause.equals("") ? pCP.m_DBName : String.valueOf(ColClause) + "," + pCP.m_DBName;
                int newID = this.m_ds.nextSequence((String.valueOf(pCP.m_DBTable) + "." + pCP.m_DBName).toLowerCase());
                this.m_ds.setValue(row, pCP.m_Name, newID);
                pItem = pRow.GetAt(i);
                pItem.m_CurrentValue = new Integer(newID);
                pItem.m_OriginalValue = new Integer(newID);
                ValueClause = ValueClause.equals("") ? String.valueOf(newID) : String.valueOf(ValueClause) + "," + newID;
            }
            ++i;
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (!ColClause.equals("") && !ValueClause.equals("")) {
            String sql = "Insert into " + this.m_ds.m_UpdateTable + " (" + ColClause + ") Values (" + ValueClause + ")";
            ret.add(sql);
        }
        if ((clobColumnCount = clobColumnList.size()) > 0) {
            String WhereClause = this.assemblePrimaryKeyWhere(row);
            if (WhereClause.equals("")) {
                throw new Exception("\u6ca1\u6709\u7528\u4e8e\u6784\u5efawhere\u5b50\u53e5\u7684\u5b57\u6bb5");
            }
            int k = 0;
            while (k < clobColumnList.size()) {
                ZDataParser zdp = new ZDataParser((String)clobColumnList.get(k));
                zdp.put("where", WhereClause);
                ret.add("updateblob " + zdp.toString());
                ++k;
            }
        }
        return ret;
    }

    ArrayList AsserbleSQLUpdate(int row) throws Exception {
        DsRow_ pRow = (DsRow_)this.getRow(row);
        int n = this.getColumnCount();
        String SetClause = "";
        String WhereClause = "";
        ArrayList<String> clobColumnList = new ArrayList<String>();
        boolean isOracle = this.m_ds.getDataAdapter().isOracle();
        int i = 0;
        while (i < n) {
            String temp;
            ColumnProperty_ pCP = (ColumnProperty_)this.getColumnProperty(i);
            DsItem pItem = pRow.GetAt(i);
            if (pCP.m_Updatable && pCP.m_Updatable && pItem != null && pItem.m_ItemStatus == 1) {
                String value = this.GetFormatedTextValue(pItem, pCP);
                if (pCP.m_DataType == 2005 && isOracle && value.length() > 1500) {
                    value = pItem.m_CurrentValue.toString();
                    ZDataParser zdp = new ZDataParser();
                    zdp.put("table", this.m_ds.m_UpdateTable);
                    zdp.put("col", pCP.m_DBName);
                    zdp.put("value", value);
                    clobColumnList.add(zdp.toString());
                    value = "EMPTY_CLOB()";
                }
                temp = String.valueOf(pCP.m_DBName) + " = " + value;
                SetClause = SetClause.equals("") ? temp : String.valueOf(SetClause) + "," + temp;
            }
            if (pCP.m_UpdateWhereClause) {
                temp = pItem == null ? String.valueOf(pCP.m_DBName) + " is NULL" : ((temp = this.GetFormatedTextValue(pItem, pCP, true)).equals("") ? String.valueOf(pCP.m_DBName) + " is NULL" : String.valueOf(pCP.m_DBName) + " = " + temp);
                WhereClause = WhereClause.equals("") ? temp : String.valueOf(WhereClause) + " and " + temp;
            }
            ++i;
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (WhereClause.equals("")) {
            throw new Exception("\u6ca1\u6709\u7528\u4e8e\u6784\u5efawhere\u5b50\u53e5\u7684\u5b57\u6bb5");
        }
        if (!SetClause.equals("")) {
            String sql = "Update " + this.m_ds.m_UpdateTable + " Set " + SetClause;
            if (!WhereClause.equals("")) {
                sql = String.valueOf(sql) + "  Where (" + WhereClause + ")";
            }
            ret.add(sql);
        }
        int k = 0;
        while (k < clobColumnList.size()) {
            ZDataParser zdp = new ZDataParser((String)clobColumnList.get(k));
            zdp.put("where", WhereClause);
            ret.add("updateblob " + zdp.toString());
            ++k;
        }
        return ret;
    }

    Object ChangeType(Object value, String toType) {
        try {
            return ObjectTool.ChangeType(value, toType);
        }
        catch (Exception e) {
            this.m_ds.getError().parseError(e, this.m_ds.getEvent());
            return null;
        }
    }

    public int compare(Object o1, Object o2) {
        DsRow_ pr1 = (DsRow_)o1;
        DsRow_ pr2 = (DsRow_)o2;
        DataStore_ pDs = this.m_ds;
        int n = pDs.m_OrderByConfig.size();
        int i = 0;
        while (i < n) {
            OrderByConfig ob = (OrderByConfig)pDs.m_OrderByConfig.get(i);
            int col = ob.colNo;
            DsItem pDI1 = pr1.GetAt(col);
            DsItem pDI2 = pr2.GetAt(col);
            if (pDI1 != null || pDI2 != null) {
                if (pDI1 == null) {
                    return -1 * (ob.byAsc ? 1 : -1);
                }
                if (pDI2 == null) {
                    return 1 * (ob.byAsc ? 1 : -1);
                }
                Object pv1 = pDI1.m_CurrentValue;
                Object pv2 = pDI2.m_CurrentValue;
                if (pv1 != null || pv2 != null) {
                    if (pv1 == null) {
                        return -1 * (ob.byAsc ? 1 : -1);
                    }
                    if (pv2 == null) {
                        return 1 * (ob.byAsc ? 1 : -1);
                    }
                    if (!pv1.equals(pv2)) {
                        if (ob.byAsc) {
                            return this.ObjectCompare(pv1, pv2);
                        }
                        return this.ObjectCompare(pv1, pv2) * -1;
                    }
                }
            }
            ++i;
        }
        return pr1.m_OriginalOrder < pr2.m_OriginalOrder ? -1 : 1;
    }

    int ObjectCompare(Object v1, Object v2) {
        String t = v1.getClass().getName();
        if (v1 instanceof String) {
            return ((String)v1).compareTo((String)v2);
        }
        if (v1 instanceof Date) {
            Date d1 = (Date)this.ChangeType(v1, "java.util.Date");
            Date d2 = (Date)this.ChangeType(v2, "java.util.Date");
            return d1.compareTo(d2);
        }
        if (v1 instanceof Number) {
            double d2;
            double d1 = ((Number)v1).doubleValue();
            if (d1 == (d2 = ((Number)v2).doubleValue())) {
                return 0;
            }
            return d1 > d2 ? 1 : -1;
        }
        Double d1 = (Double)this.ChangeType(v1, "java.lang.Double");
        Double d2 = (Double)this.ChangeType(v2, "java.lang.Double");
        return d1.compareTo(d2);
    }

    void Sort() {
        Collections.sort(this.m_Buffer, this);
    }

    Object ObjectClone(Object obj) {
        try {
            return ObjectTool.ObjectClone(obj);
        }
        catch (Exception e) {
            this.m_ds.getError().parseError(e, this.m_ds.getEvent());
            return null;
        }
    }

    boolean SaveAsTxt(String file) {
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            return this.SaveAsTxt(w);
        }
        catch (Exception e) {
            this.m_ds.getError().parseError(e, this.m_ds.getEvent());
            return false;
        }
    }

    boolean SaveAsTxt(Writer w) {
        String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        try {
            int rc = this.getRowCount();
            int cc = this.getColumnCount();
            int row = 0;
            while (row < rc) {
                int col = 0;
                while (col < cc) {
                    Object v = this.getValue(row, col);
                    if (v == null) {
                        w.write("\t");
                    } else {
                        try {
                            String s = (String)ObjectTool.ChangeType(v, "java.lang.String");
                            w.write(s);
                            w.write("\t");
                        }
                        catch (Exception e) {
                            w.write("\t");
                        }
                    }
                    ++col;
                }
                w.write(lineSeparator);
                ++row;
            }
            w.close();
        }
        catch (IOException e) {
            this.m_ds.getError().parseError(e, this.m_ds.getEvent());
            return false;
        }
        return true;
    }

    boolean SaveAsDBF(String file) {
        try {
            int rc = this.getRowCount();
            int cc = this.getColumnCount();
            DBFWriter writer = new DBFWriter();
            writer.setCharactersetName("GBK");
            DBFField[] fields = new DBFField[cc];
            ArrayList<String> colNameList = new ArrayList<String>();
            int col = 0;
            while (col < cc) {
                DBFField field;
                ColumnProperty cp = this.m_ds.getColumnProperty(col);
                fields[col] = field = new DBFField();
                String colName = cp.getName();
                if (colName.length() > 10) {
                    int ti = 0;
                    while (ti < 100) {
                        String t;
                        if (ti == 0) {
                            t = colName.substring(0, 10);
                        } else if (ti < 10) {
                            t = colName.substring(0, 9);
                            t = String.valueOf(t) + ti;
                        } else {
                            t = colName.substring(0, 8);
                            t = String.valueOf(t) + ti;
                        }
                        if (!colNameList.contains(t)) {
                            colName = t;
                            break;
                        }
                        ++ti;
                    }
                }
                colNameList.add(colName);
                field.setName(colName);
                switch (cp.getUniformDataType()) {
                    case 1: {
                        field.setDataType((byte)78);
                        field.setFieldLength(10);
                        break;
                    }
                    case 2: {
                        field.setDataType((byte)78);
                        field.setFieldLength(cp.getPrecision());
                        field.setDecimalCount(cp.getScale());
                        break;
                    }
                    case 3: {
                        field.setDataType((byte)67);
                        field.setFieldLength(Math.min(255, cp.getPrecision() * 2));
                        break;
                    }
                    case 4: {
                        field.setDataType((byte)68);
                        break;
                    }
                    default: {
                        field.setDataType((byte)67);
                        field.setFieldLength(255);
                    }
                }
                ++col;
            }
            writer.setFields(fields);
            int row = 0;
            while (row < rc) {
                Object[] rowData = new Object[cc];
                col = 0;
                while (col < cc) {
                    ColumnProperty cp = this.m_ds.getColumnProperty(col);
                    Object v = this.getValue(row, col);
                    switch (cp.getUniformDataType()) {
                        case 1: {
                            v = ObjectTool.ChangeType(v, "java.lang.Double");
                            break;
                        }
                        case 2: {
                            v = ObjectTool.ChangeType(v, "java.lang.Double");
                            break;
                        }
                        case 3: {
                            v = ObjectTool.ChangeType(v, "java.lang.String");
                            if (v != null) break;
                            v = "";
                            break;
                        }
                        case 4: {
                            v = ObjectTool.ChangeType(v, "java.util.Date");
                            break;
                        }
                        default: {
                            v = ObjectTool.ChangeType(v, "java.lang.String");
                        }
                    }
                    rowData[col] = v;
                    ++col;
                }
                writer.addRecord(rowData);
                ++row;
            }
            FileOutputStream fos = new FileOutputStream(file);
            writer.write(fos);
            fos.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            this.m_ds.getError().parseError(e, this.m_ds.getEvent());
            return false;
        }
        return true;
    }

    int ImportTxtFile(String file, int skipRow) {
        boolean ret = false;
        int colCount = this.m_ds.getColumnCount();
        String charsetName = DataStoreFactory.charsetDetect(file);
        try {
            return this.ImportTxt(new InputStreamReader((InputStream)new FileInputStream(file), charsetName), skipRow);
        }
        catch (Exception e) {
            this.m_ds.m_Error.parseError(e, this.m_ds.getEvent());
            return 0;
        }
    }

    int ImportTxt(Reader reader, int skipRow) {
        int ret = 0;
        int colCount = this.m_ds.getColumnCount();
        try {
            String line;
            BufferedReader in = new BufferedReader(reader);
            int i = 0;
            while (i < skipRow) {
                line = in.readLine();
                ++i;
            }
            while ((line = in.readLine()) != null) {
                ++ret;
                String[] strs = line.split("\t", 9999);
                int row = this.m_ds.insertRow(9999999);
                int col = 0;
                col = 0;
                while (col < Math.min(colCount, strs.length)) {
                    String s = strs[col];
                    if (s.length() != 0) {
                        this.setValue(row, col, s);
                    }
                    ++col;
                }
            }
            in.close();
        }
        catch (IOException e) {
            this.m_ds.getError().parseError(e, this.m_ds.getEvent());
            return ret;
        }
        return ret;
    }

    int ImportCSVFile(String file, char delimiter, boolean includeHeader) {
        boolean ret = false;
        int colCount = this.m_ds.getColumnCount();
        String charsetName = DataStoreFactory.charsetDetect(file);
        try {
            return this.ImportCSV(new InputStreamReader((InputStream)new FileInputStream(file), charsetName), delimiter, includeHeader);
        }
        catch (Exception e) {
            this.m_ds.m_Error.parseError(e, this.m_ds.getEvent());
            return 0;
        }
    }

    int ImportCSV(Reader reader_, char delimiter, boolean includeHeader) {
        int ret = 0;
        int colCount = this.m_ds.getColumnCount();
        try {
            CsvReader reader = new CsvReader(reader_, delimiter);
            HashMap<Integer, Integer> label2col = new HashMap<Integer, Integer>();
            int cn = this.m_ds.getColumnCount();
            if (includeHeader) {
                reader.readHeaders();
                String[] headers = reader.getHeaders();
                int i = 0;
                while (i < headers.length) {
                    String t = headers[i];
                    int j = 0;
                    while (j < cn) {
                        if (this.m_ds.getColumnProperty(j).getColumnLabel().equalsIgnoreCase(t) || this.m_ds.getColumnProperty(j).getName().equalsIgnoreCase(t)) {
                            label2col.put(i, j);
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                int j = 0;
                while (j < cn) {
                    label2col.put(j, j);
                    ++j;
                }
            }
            while (reader.readRecord()) {
                String[] values = reader.getValues();
                int row = this.m_ds.insertRow(9999999);
                int i = 0;
                while (i < values.length) {
                    if (label2col.containsKey(i)) {
                        int col = (Integer)label2col.get(i);
                        String s = values[i];
                        s = s.replaceAll("\\s", "");
                        this.m_ds.setValue(row, col, (Object)s);
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            this.m_ds.getError().parseError(e, this.m_ds.getEvent());
            return ret;
        }
        return ret;
    }

    int ImportDBFFile(String file, String colMap) {
        int ret = 0;
        int colCount = this.m_ds.getColumnCount();
        FileInputStream inputStream = null;
        try {
            try {
                Object[] rowObjects;
                inputStream = new FileInputStream(file);
                DBFReader reader = new DBFReader(inputStream);
                int numberOfFields = reader.getFieldCount();
                HashMap<Integer, String> name2index = new HashMap<Integer, String>();
                int i = 0;
                while (i < numberOfFields) {
                    DBFField field = reader.getField(i);
                    name2index.put(i, field.getName().toLowerCase());
                    ++i;
                }
                HashMap<String, Integer> sourceCol2thisIndex = new HashMap<String, Integer>();
                JSONObject js = new JSONObject(colMap);
                Iterator it = js.getMap().keySet().iterator();
                while (it.hasNext()) {
                    String sourceCol = ((String)it.next()).toLowerCase();
                    String mapCol = js.getString(sourceCol).toLowerCase();
                    int colIndex = this.m_ds.col2Index(mapCol);
                    if (colIndex < 0) continue;
                    sourceCol2thisIndex.put(sourceCol, colIndex);
                }
                while ((rowObjects = reader.nextRecord()) != null) {
                    int row = this.m_ds.insertRow(9999999);
                    int i2 = 0;
                    while (i2 < rowObjects.length) {
                        String colName = (String)name2index.get(i2);
                        int toCol = -1;
                        toCol = sourceCol2thisIndex.containsKey(colName) ? ((Integer)sourceCol2thisIndex.get(colName)).intValue() : this.m_ds.col2Index(colName);
                        Object v = rowObjects[i2];
                        if (v instanceof String && this.m_ds.isAutoTrim()) {
                            v = ((String)v).trim();
                        }
                        if (toCol >= 0) {
                            this.m_ds.setValue(row, toCol, v);
                        }
                        ++i2;
                    }
                }
                ((InputStream)inputStream).close();
            }
            catch (Exception e) {
                this.m_ds.getError().parseError(e, this.m_ds.getEvent());
                int n = ret;
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return n;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Exception exception) {}
            }
        }
        return ret;
    }

    int ImportBigTxtFileAndSave(String file, int skipRows, String splitChar, int onceSaveCount) {
        int ret = 0;
        int colCount = this.m_ds.getColumnCount();
        String charsetName = DataStoreFactory.charsetDetect(file);
        if (splitChar.equals("")) {
            splitChar = "\t";
        }
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            while ((line = in.readLine()) != null) {
                if (++ret <= skipRows) continue;
                String[] strs = line.split(splitChar, 9999);
                int row = this.m_ds.insertRow(9999999);
                int col = 0;
                col = 0;
                while (col < Math.min(colCount, strs.length)) {
                    String s = strs[col];
                    if (s.length() != 0) {
                        this.setValue(row, col, s);
                    }
                    ++col;
                }
                if (this.m_ds.getRowCount() != onceSaveCount) continue;
                this.m_ds.update(true);
                this.m_ds.reset();
            }
            if (this.m_ds.getRowCount() > 0) {
                this.m_ds.update(true);
                this.m_ds.reset();
            }
            in.close();
        }
        catch (IOException e) {
            this.m_ds.getError().parseError(e, this.m_ds.getEvent());
            return ret;
        }
        return ret - skipRows;
    }

    boolean SaveAsXML(String file) {
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            return this.SaveAsXML(w);
        }
        catch (Exception e) {
            this.m_ds.getError().parseError(e, this.m_ds.getEvent());
            return false;
        }
    }

    boolean SaveAsXML(Writer w) {
        String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        try {
            XmlWriter xml = new XmlWriter(w);
            w.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            w.write(lineSeparator);
            xml.S("datastore").A("version", "1.0").A("copyright", "Wisesoft");
            xml.S("table").A("sql", this.m_ds.getSelect()).A("updatabletable", this.m_ds.getUpdatableTable()).A("updatablecolumns", this.m_ds.getUpdatableColumns()).A("primarykey", this.m_ds.getPrimaryKey()).A("updatewhereclausecolumns", this.m_ds.getUpdateWhereClauseColumns()).A("rowcount", this.m_ds.getRowCount()).E();
            int rc = this.getRowCount();
            int cc = this.getColumnCount();
            String[] ColName = new String[cc];
            int col = 0;
            while (col < cc) {
                ColName[col] = this.m_ds.getColumnName(col);
                xml.S("column_define").A("name", ColName[col]).A("no", col).A("type", this.getColumnProperty(col).getDataTypeName()).E();
                ++col;
            }
            int row = 0;
            while (row < rc) {
                xml.S("row").A("no", row + 1);
                col = 0;
                while (col < cc) {
                    Object v = this.getValue(row, col);
                    if (v != null) {
                        try {
                            String s = (String)ObjectTool.ChangeType(v, "java.lang.String");
                            if (s.trim().length() > 0) {
                                s = Escape.escape(s);
                            }
                            xml.S("c").A("no", col).W(s).E();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++col;
                }
                xml.E();
                ++row;
            }
            xml.E();
            w.close();
        }
        catch (IOException ioe) {
            this.m_ds.getError().parseError(ioe, this.m_ds.getEvent());
            return false;
        }
        catch (Exception e) {
            this.m_ds.getError().parseError(e, this.m_ds.getEvent());
            return false;
        }
        return true;
    }

    int ImportXMLFile(String file, String charsetName) {
        XMLReader xmlReader = null;
        ReadXML rx = new ReadXML(this.m_ds);
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            spfactory.setValidating(false);
            SAXParser saxParser = spfactory.newSAXParser();
            xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(rx);
            xmlReader.setErrorHandler(rx);
            if (charsetName.equals("")) {
                charsetName = DataStoreFactory.charsetDetect(file);
            }
            InputSource source = new InputSource(new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), charsetName));
            xmlReader.parse(source);
            source = null;
        }
        catch (Exception e) {
            Logger.error("import xml error :" + e.getMessage());
            this.m_ds.getError().parseError(e, this.m_ds.getEvent());
            return 0;
        }
        return rx.RowCount;
    }

    int ImportXMLSource(String xmlSource) {
        XMLReader xmlReader = null;
        ReadXML rx = new ReadXML(this.m_ds);
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            spfactory.setValidating(false);
            SAXParser saxParser = spfactory.newSAXParser();
            xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(rx);
            xmlReader.setErrorHandler(rx);
            StringReader sr = new StringReader(xmlSource);
            InputSource source = new InputSource(sr);
            xmlReader.parse(source);
            source = null;
        }
        catch (Exception e) {
            this.m_ds.getError().parseError(e, this.m_ds.getEvent());
            return 0;
        }
        return rx.RowCount;
    }

    void InsureColumnValueValid(int col) {
        int row;
        int rc;
        ColumnProperty_ pCP = (ColumnProperty_)this.getColumnProperty(col);
        if (pCP.m_ObjType == 2) {
            rc = this.getRowCount();
            row = 0;
            while (row < rc) {
                DsRow_ dr = (DsRow_)this.m_Buffer.get(row);
                DsItem item = dr.GetAt(col);
                if (item == null) {
                    item = this.NEW_ITEM(item, dr, col);
                    item.m_ItemStatus = (byte)5;
                }
                if (item.m_ItemStatus != 4) {
                    this.InternalRecalculateComputer(item, pCP.m_Formula, pCP.m_DependMap, row);
                }
                ++row;
            }
        }
        if (pCP.m_ObjType == 8) {
            int GroupNo = pCP.m_AggregateDefine.m_GroupNo;
            if (GroupNo < 0 || GroupNo > this.m_ds.m_VectorGroups.size() - 1) {
                return;
            }
            rc = this.getRowCount();
            row = 0;
            while (row < rc) {
                DsRow_ dr;
                DsItem item;
                Point range = this.AggregateRange(row, GroupNo);
                if (pCP.m_AggregateDefine.m_AggregateType != 11) {
                    row = range.x;
                }
                if ((item = (dr = (DsRow_)this.m_Buffer.get(row)).GetAt(col)) == null) {
                    item = this.NEW_ITEM(item, dr, col);
                    item.m_ItemStatus = (byte)5;
                }
                if (item.m_ItemStatus != 4) {
                    Object v = null;
                    v = this.Eval(pCP.m_Formula, pCP.m_DependMap, row, pCP.m_AggregateDefine, range);
                    item.m_ItemStatus = (byte)4;
                    item.m_CurrentValue = v;
                }
                ++row;
            }
        }
    }

    public boolean importUpdate() {
        StringBuffer cols = new StringBuffer("insert into " + this.m_ds.getUpdatableTable() + " ( ");
        StringBuffer values = new StringBuffer(" ) values ( ");
        ArrayList<Integer> colNos = new ArrayList<Integer>();
        ArrayList<Integer> colTypes = new ArrayList<Integer>();
        ArrayList<Integer> colScales = new ArrayList<Integer>();
        int n = this.getColumnCount();
        int i = 0;
        while (i < n) {
            ColumnProperty_ pCP = (ColumnProperty_)this.getColumnProperty(i);
            if (pCP.m_Updatable) {
                cols.append(pCP.m_DBName).append(",");
                values.append("?,");
                colNos.add(new Integer(i));
                colTypes.add(new Integer(pCP.m_DataType));
                colScales.add(new Integer(pCP.Scale));
            }
            ++i;
        }
        String t1 = cols.toString();
        String t2 = values.toString();
        if (t1.endsWith(",")) {
            t1 = t1.substring(0, t1.length() - 1);
        }
        if (t2.endsWith(",")) {
            t2 = t2.substring(0, t2.length() - 1);
        }
        String sql = String.valueOf(t1) + t2 + ")";
        Statement ps = null;
        try {
            ps = this.m_ds.getConnection().prepareStatement(sql);
            int rc = this.m_ds.getRowCount();
            i = 0;
            while (i < rc) {
                this.preparedStatementInsert(i, (PreparedStatement)ps, colNos, colTypes, colScales);
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            this.m_ds.getError().parseError(e, this.m_ds.getEvent());
            return false;
        }
        finally {
            try {
                ps.close();
            }
            catch (Exception exception) {}
        }
    }

    private void preparedStatementInsert(int row, PreparedStatement ps, ArrayList cols, ArrayList colTypes, ArrayList colScales) {
        int col = 0;
        try {
            boolean isMSSqlServer = this.m_ds.getDataAdapter().isMSSqlServer();
            Calendar cal = Calendar.getInstance();
            ps.clearParameters();
            DsRow_ pRow = (DsRow_)this.getRow(row);
            int n = cols.size();
            int i = 0;
            while (i < n) {
                col = (Integer)cols.get(i);
                int type = (Integer)colTypes.get(i);
                int scale = (Integer)colScales.get(i);
                Object v = this.getValue(row, col);
                if (isMSSqlServer && v != null && v instanceof Date) {
                    cal.setTime((Date)v);
                    if (cal.get(1) < 1753) {
                        cal.set(1753, 0, 1);
                        Date td = cal.getTime();
                        String vTypeName = v.getClass().getName();
                        v = ObjectTool.ChangeType(td, vTypeName);
                        Logger.info("\u884c=" + row + "\u5217=" + this.m_ds.getColumnName(col) + "\u4e0d\u662f\u5408\u6cd5\u7684\u65e5\u671f\uff0c\u73b0\u5728\u5f3a\u5236\u4f7f\u75281753.01.01\u4ee3\u66ff");
                    }
                }
                if (type == 3 || type == 2) {
                    ps.setObject(i + 1, v, type, scale);
                } else {
                    ps.setObject(i + 1, v, type);
                }
                ++i;
            }
            ps.execute();
        }
        catch (Exception e) {
            String es = "\u884c=" + row + "\u5217=" + this.m_ds.getColumnName(col) + " (0\u8868\u793a\u7b2c1\u884c)\uff1a \u53d1\u751f\u9519\u8bef" + e.getMessage();
            this.m_ds.getError().parseError(es, this.m_ds.getEvent());
        }
    }

    public void setBalloonTip(int row, String col, String type, String info) {
        if (row > this.size() - 1) {
            return;
        }
        if (row < 0) {
            return;
        }
        DsRow rowData = this.getRow(row);
        rowData.setItemBalloonTip(col, type, info);
        this.m_ds.getEvent().fireItemBalloonTipChanged(row, col, type, info);
    }

    public String getBalloonTip(int row, String col, String type) {
        if (row > this.size() - 1) {
            return null;
        }
        if (row < 0) {
            return null;
        }
        DsRow rowData = this.getRow(row);
        return rowData.getItemBalloonTip(col, type);
    }
}

