/*
 * Decompiled with CFR 0.152.
 */
package jun.db.impl;

import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import jun.db.core.ColumnProperty;
import jun.db.core.DataAdapter;
import jun.db.core.DataStore;
import jun.db.core.Logger;
import jun.db.core.ObjectTool;
import jun.db.impl.DataAdapterH2;
import jun.db.impl.DataAdapterHypersonicSQL;
import jun.db.impl.DataAdapterJConnect;
import jun.db.impl.DataAdapterJTDS;
import jun.db.impl.DataAdapterOracle;
import jun.db.impl.DataAdapterPostgres;
import jun.db.impl.DataAdapterSQLServer;
import jun.db.util.ToString;

class DataAdapterDefault
implements DataAdapter {
    protected String m_DateSeparator = ".";
    protected String m_DBProvider = "";
    private DataStore m_DS;
    private HashMap m_DataTypeMap = new HashMap();

    public DataAdapterDefault(DataStore ds) {
        this.m_DS = ds;
        HashMap map = this.getDataTypeMap();
        map.put("timestamp", "datetime");
        map.put("number", "decimal");
        map.put("date", "datetime");
        map.put("number", "numeric");
        map.put("varchar2", "varchar");
        map.put("clob", "text");
        map.put("counter", "int");
        map.put("longchar", "text");
    }

    public HashMap getDataTypeMap() {
        return this.m_DataTypeMap;
    }

    public String getMappedDataType(String type) {
        if (this.m_DataTypeMap.containsKey(type = type.toLowerCase())) {
            return (String)this.m_DataTypeMap.get(type);
        }
        return type;
    }

    public String getDateSeparator() {
        return this.m_DateSeparator;
    }

    public String getDBProvider() {
        return this.m_DBProvider;
    }

    public boolean caseSensitive() {
        return false;
    }

    public static long _getLongFromSql(Connection con, String sql) {
        ResultSet rs = null;
        try {
            rs = con.createStatement().executeQuery(sql);
            if (rs.next()) {
                long ret;
                long l = ret = rs.getLong(1);
                return l;
            }
            return -9999L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -9999L;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getFormatedTextValue(Object v, int dataType, int decimalCount) {
        String bstr = "";
        SimpleDateFormat sdf = null;
        if (v == null) {
            return "NULL";
        }
        switch (dataType) {
            case 0: {
                bstr = "NULL";
                break;
            }
            case -4: 
            case -3: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                String t = bstr = bstr.concat(v.toString());
                String sss = "'";
                String ddd = "''";
                bstr = "'" + t.replaceAll(sss, ddd) + "'";
                break;
            }
            case 91: {
                sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
                bstr = "'" + sdf.format(v) + "'";
                break;
            }
            case 92: {
                sdf = new SimpleDateFormat("HH:mm:ss");
                bstr = "'" + sdf.format(v) + "'";
                break;
            }
            case 93: {
                sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
                bstr = "'" + sdf.format(v) + "'";
                break;
            }
            case 2: 
            case 3: {
                try {
                    BigDecimal bd = (BigDecimal)ObjectTool.ChangeType(v, "java.math.BigDecimal");
                    bstr = ToString.double2String(bd, false, decimalCount);
                }
                catch (Exception e) {
                    bstr = v.toString();
                }
                break;
            }
            default: {
                bstr = v.toString();
            }
        }
        return bstr;
    }

    public static String getClobString(ResultSet rs, int col) {
        Reader reader;
        block4: {
            reader = rs.getCharacterStream(col);
            if (reader != null) break block4;
            return null;
        }
        try {
            StringBuffer sb = new StringBuffer();
            char[] charbuf = new char[4096];
            int i = reader.read(charbuf);
            while (i > 0) {
                sb.append(charbuf, 0, i);
                i = reader.read(charbuf);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "Error:" + e.getMessage();
        }
    }

    public void clobModify(Connection conn, String table, String col, String where, String value, boolean printSQL) throws Exception {
    }

    public String DTN2JTN(String dbTypeName, ColumnProperty CP) throws Exception {
        String dtn = new String(dbTypeName).toLowerCase().trim();
        if (dtn.equals("int")) {
            return "java.lang.Integer";
        }
        if (dtn.equals("int identity")) {
            return "java.lang.Integer";
        }
        if (dtn.equals("integer")) {
            return "java.lang.Integer";
        }
        if (dtn.equals("integer identity")) {
            return "java.lang.Integer";
        }
        if (dtn.equals("numeric identity")) {
            return "java.lang.Integer";
        }
        if (dtn.equals("decimal identity")) {
            return "java.lang.Integer";
        }
        if (dtn.equals("double precision")) {
            return "java.math.BigDecimal";
        }
        if (dtn.equals("decimal")) {
            return "java.math.BigDecimal";
        }
        if (dtn.equals("numeric")) {
            return "java.math.BigDecimal";
        }
        if (dtn.equals("number")) {
            return "java.math.BigDecimal";
        }
        if (dtn.equals("image")) {
            return "[B";
        }
        if (dtn.equals("text")) {
            return "java.lang.String";
        }
        if (dtn.equals("blob")) {
            return "java.lang.String";
        }
        if (dtn.equals("clob")) {
            return "java.lang.String";
        }
        if (dtn.equals("bpchar")) {
            return "java.lang.String";
        }
        if (dtn.equals("varchar")) {
            return "java.lang.String";
        }
        if (dtn.equals("varchar2")) {
            return "java.lang.String";
        }
        if (dtn.equals("char")) {
            return "java.lang.String";
        }
        if (dtn.equals("smalldatetime")) {
            return "java.sql.Timestamp";
        }
        if (dtn.equals("datetime")) {
            return "java.sql.Timestamp";
        }
        if (dtn.equals("date")) {
            return "java.sql.Timestamp";
        }
        if (dtn.equals("time")) {
            return "java.sql.Timestamp";
        }
        if (dtn.equals("timestamp")) {
            return "java.sql.Timestamp";
        }
        if (dtn.equals("smallint")) {
            return "java.lang.Integer";
        }
        if (dtn.equals("tinyint")) {
            return "java.lang.Integer";
        }
        if (dtn.equals("real")) {
            return "java.lang.Float";
        }
        if (dtn.equals("float")) {
            return "java.lang.Double";
        }
        if (dtn.equals("bit")) {
            return "java.lang.Boolean";
        }
        if (dtn.equals("money")) {
            return "java.math.BigDecimal";
        }
        if (dtn.equals("smallmoney")) {
            return "java.math.BigDecimal";
        }
        if (dtn.equals("bigint")) {
            return "java.lang.Long";
        }
        if (dtn.equals("binary")) {
            return "[B";
        }
        if (dtn.equals("varbinary")) {
            return "[B";
        }
        if (dtn.equals("nvarchar")) {
            return "java.lang.String";
        }
        if (dtn.equals("longvarchar")) {
            return "java.lang.String";
        }
        if (dtn.equals("nchar")) {
            return "java.lang.String";
        }
        if (dtn.equals("ntext")) {
            return "java.lang.String";
        }
        if (dtn.equals("uniqueidentifier")) {
            return "java.lang.String";
        }
        if (dtn.equals("sql_variant")) {
            return "java.lang.String";
        }
        if (dtn.equals("nvarchar")) {
            return "java.lang.String";
        }
        if (dtn.equals("sysname")) {
            return "java.lang.String";
        }
        if (dtn.equals("univarchar")) {
            return "java.lang.String";
        }
        if (dtn.equals("unichar")) {
            return "java.lang.Character";
        }
        String ddtn = CP.getColumnClassName();
        dtn.equalsIgnoreCase(ddtn);
        String error = String.valueOf(this.getClass().getName()) + ".DTN2JTN \u51fd\u6570\u6ca1\u6709\u5904\u7406\u7c7b\u578b" + dbTypeName + "  , \u76f4\u63a5\u4f7f\u7528\u5b83\u7684\u7f3a\u7701\u7c7b\u578b\u6620\u5c04\uff1a" + ddtn;
        return ddtn;
    }

    public String assembleColumnType(String DataTypeName, long Precision, int Scale, String redefine) throws Exception {
        String ldtn = DataTypeName.toLowerCase().trim();
        if (!redefine.trim().equals("")) {
            return redefine;
        }
        if (ldtn.indexOf("bigint") == 0) {
            return "bigint";
        }
        if (ldtn.indexOf("binary") == 0) {
            return "binary";
        }
        if (ldtn.indexOf("bit") == 0) {
            return "bit";
        }
        if (ldtn.indexOf("char") == 0) {
            return "char(" + String.valueOf(Precision) + ")";
        }
        if (ldtn.equals("date")) {
            return "date";
        }
        if (ldtn.indexOf("datetime") == 0) {
            return "datetime";
        }
        if (ldtn.indexOf("decimal") == 0) {
            return "decimal(" + String.valueOf(Precision) + "," + String.valueOf(Scale) + ")";
        }
        if (ldtn.indexOf("number") == 0) {
            return "number(" + String.valueOf(Precision) + "," + String.valueOf(Scale) + ")";
        }
        if (ldtn.indexOf("float") == 0) {
            return "float";
        }
        if (ldtn.indexOf("image") == 0) {
            return "image";
        }
        if (ldtn.indexOf("int") == 0) {
            return "int";
        }
        if (ldtn.indexOf("money") == 0) {
            return "money";
        }
        if (ldtn.indexOf("nchar") == 0) {
            return "nchar(" + String.valueOf(Precision) + ")";
        }
        if (ldtn.indexOf("ntext") == 0) {
            return "ntext";
        }
        if (ldtn.indexOf("numeric") == 0) {
            return "numeric(" + String.valueOf(Precision) + "," + String.valueOf(Scale) + ")";
        }
        if (ldtn.indexOf("nvarchar") == 0) {
            return "nvarchar(" + String.valueOf(Precision) + ")";
        }
        if (ldtn.indexOf("real") == 0) {
            return "real";
        }
        if (ldtn.indexOf("smalldatetime") == 0) {
            return "smalldatetime";
        }
        if (ldtn.indexOf("smallint") == 0) {
            return "smallint";
        }
        if (ldtn.indexOf("smallmoney") == 0) {
            return "smallmoney";
        }
        if (ldtn.indexOf("sql_variant") == 0) {
            return "sql_variant";
        }
        if (ldtn.indexOf("sysname") == 0) {
            return "sysname";
        }
        if (ldtn.indexOf("text") == 0) {
            return "text";
        }
        if (ldtn.indexOf("timestamp") == 0) {
            return "timestamp";
        }
        if (ldtn.indexOf("tinyint") == 0) {
            return "tinyint";
        }
        if (ldtn.indexOf("uniqueidentifier") == 0) {
            return "uniqueidentifier";
        }
        if (ldtn.indexOf("varbinary") == 0) {
            return "varbinary";
        }
        if (ldtn.equals("varchar")) {
            return "varchar(" + String.valueOf(Precision) + ")";
        }
        if (ldtn.equals("varchar2")) {
            return "varchar2(" + String.valueOf(Precision) + ")";
        }
        if (ldtn.indexOf("blob") == 0) {
            return "blob";
        }
        if (ldtn.indexOf("clob") == 0) {
            return "clob";
        }
        if (ldtn.indexOf("longraw") == 0) {
            return "longraw";
        }
        String error = String.valueOf(this.getClass().getName()) + ".AssembleColumnType \u51fd\u6570\u6ca1\u6709\u5904\u7406\u7c7b\u578b" + DataTypeName + ",\u5982\u679c\u8fd9\u4e0d\u662f\u7528\u6237\u81ea\u5b9a\u4e49\u6570\u636e\u7c7b\u578b\uff0c\u8bf7\u5728\u51fd\u6570\u4e2d\u5904\u7406\u5b83";
        return DataTypeName;
    }

    public Object getDataFromResultSet(ResultSet rs, int col, int dt) throws Exception {
        Object v = rs.getObject(col);
        if (v == null) {
            return v;
        }
        if (v.getClass().getName().equals("com.sybase.jdbc3.tds.SybTimestamp")) {
            return new Date(((java.util.Date)v).getTime());
        }
        return v;
    }

    public void InitNegativeSequence(Connection con, String name, String value) {
        Statement st = null;
        try {
            st = con.createStatement();
            DataAdapterDefault.SafeExecuteSQL(st, "create table datastore_sequence_negative (name varchar(255) not null,value\tint\tnot null,\tprimary key (name))");
            DataAdapterDefault.SafeExecuteSQL(st, "insert into datastore_sequence_negative   values ( '" + name + "' , 0)");
            DataAdapterDefault.SafeExecuteSQL(st, "update datastore_sequence_negative   set value= isnull ((" + value + ") ,0)   where name= '" + name + "'    and   value> isnull ((" + value + ") ,0) ");
            DataAdapterDefault.SafeExecuteSQL(st, "Create Procedure  DataStoreGetNextNSequence( @p_name  varchar(255) ,@ret   int output)  \nAS  \nBEGIN  \n        BEGIN TRAN DataStoreGetNextNSequence   \n        update datastore_sequence_negative  set value = value - 1 where name=@p_name   \n        if @@ROWCOUNT = 0  insert into datastore_sequence_negative  values( @p_name ,-1)   \n        select @ret = value from datastore_sequence_negative  where name = @p_name   \n        COMMIT TRAN DataStoreGetNextNSequence    \nEND ");
            DataAdapterDefault.SafeExecuteSQL(st, " exec sp_procxmode  DataStoreGetNextNSequence , anymode");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void InitSequence(Connection con, String name, String value) {
        Statement st = null;
        try {
            try {
                st = con.createStatement();
                DataAdapterDefault.SafeExecuteSQL(st, "create table datastore_sequence (name varchar(255) not null,value\tint\tnot null,\tprimary key (name))");
                DataAdapterDefault.SafeExecuteSQL(st, "insert into datastore_sequence   values ( '" + name + "' , 0)");
                DataAdapterDefault.SafeExecuteSQL(st, "update datastore_sequence   set value= isnull ((" + value + ") ,0)   where name= '" + name + "'    and   value< isnull ((" + value + ") ,0) ");
                DataAdapterDefault.SafeExecuteSQL(st, "Create Procedure  DataStoreGetNextSequence( @p_name  varchar(255) ,@ret   int output)  \nAS  \nBEGIN  \n        BEGIN TRAN DataStoreGetNextSequence   \n        update datastore_sequence  set value = value + 1 where name=@p_name   \n        if @@ROWCOUNT = 0  insert into datastore_sequence  values( @p_name ,1)   \n        select @ret = value from datastore_sequence  where name = @p_name   \n         COMMIT TRAN DataStoreGetNextSequence    \nEND ");
                DataAdapterDefault.SafeExecuteSQL(st, " exec sp_procxmode  DataStoreGetNextSequence , anymode");
                st.close();
                st = null;
            }
            catch (Exception exception) {
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public int NextNegativeSequence(Connection con, String name) {
        Statement proc = null;
        try {
            String sql = "  execute  DataStoreGetNextNSequence ?,?    ";
            String drv = con.getMetaData().getDriverName();
            if (drv.equals("SQLServer")) {
                sql = "  execute  DataStoreGetNextNSequence ?,?    ";
            }
            if (drv.startsWith("jTDS")) {
                sql = "  execute  DataStoreGetNextNSequence ?,?    ";
            }
            if (drv.startsWith("jConnect")) {
                sql = " { call  DataStoreGetNextNSequence ?,?  }  ";
            }
            proc = con.prepareCall(sql);
            proc.setString(1, name);
            proc.registerOutParameter(2, 4);
            proc.execute();
            int ret = proc.getInt(2);
            proc.close();
            if (ret == 0) {
                this.InitNegativeSequence(con, name, "");
                int n = this.NextNegativeSequence(con, name);
                return n;
            }
            int n = ret;
            return n;
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return -1;
        }
        finally {
            try {
                if (proc != null) {
                    proc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public int NextSequence(Connection con, String name) {
        Statement proc = null;
        try {
            String sql = "  execute  DataStoreGetNextSequence ?,?    ";
            String drv = con.getMetaData().getDriverName();
            if (drv.equals("SQLServer")) {
                sql = "  execute  DataStoreGetNextSequence ?,?    ";
            }
            if (drv.startsWith("jTDS")) {
                sql = "  execute  DataStoreGetNextSequence ?,?    ";
            }
            if (drv.startsWith("jConnect")) {
                sql = " { call  DataStoreGetNextSequence ?,?  }  ";
            }
            proc = con.prepareCall(sql);
            proc.setString(1, name);
            proc.registerOutParameter(2, 4);
            proc.execute();
            int ret = proc.getInt(2);
            proc.close();
            proc = null;
            if (ret == 0) {
                this.InitSequence(con, name, "");
                int n = this.NextSequence(con, name);
                return n;
            }
            int n = ret;
            return n;
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
            return -1;
        }
        finally {
            try {
                if (proc != null) {
                    proc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void SafeExecuteSQL(Statement state, String sql) {
        try {
            state.execute(sql);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toLocalSyntax(String sql) {
        return sql;
    }

    public boolean isH2() {
        return this instanceof DataAdapterH2;
    }

    public boolean isHSQL() {
        return this instanceof DataAdapterHypersonicSQL;
    }

    public boolean isMSSqlServer() {
        return this instanceof DataAdapterSQLServer || this instanceof DataAdapterJTDS;
    }

    public boolean isOracle() {
        return this instanceof DataAdapterOracle;
    }

    public boolean isPostgres() {
        return this instanceof DataAdapterPostgres;
    }

    public boolean isSybase() {
        return this instanceof DataAdapterJConnect;
    }
}

