/*
 * Decompiled with CFR 0.152.
 */
package jun.dock.impl;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.JComponent;
import jun.dock.core.DockBar;
import jun.dock.core.DockBarTabButton;
import jun.dock.core.DockFramework;
import jun.dock.impl.DockBarFrame_;
import jun.dock.impl.DockBarTabButtonGrip;
import jun.dock.impl.DockBarTab_;
import jun.dock.impl.DockContainer_;
import jun.dock.impl.TransparentFrame_;
import jun.dock.impl.UTIL;

public class DockBarTabButton_
extends JComponent
implements ComponentListener,
MouseListener,
MouseMotionListener,
Serializable,
DockBarTabButton {
    public DockBarTab_ m_Parent;
    public DockBar m_DockBar;
    private DockBarTabButtonGrip m_Grip;
    private DockFramework m_DockFramework = null;
    private TransparentFrame_ m_TransFrame = null;
    private Point m_MouseDownPoint = new Point(0, 0);
    private Point m_RootPoint = new Point(0, 0);
    private boolean m_IsDraging = false;

    DockBarTabButton_(DockBarTab_ p, DockBar db) {
        this.setLayout(null);
        this.m_Parent = p;
        this.m_DockBar = db;
        this.m_Parent.add(this);
        this.m_DockBar.setTabButton(this);
        this.m_Grip = new DockBarTabButtonGrip(this);
        this.add(this.m_Grip);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        this.m_Parent.getDockBarFrame().activeDockBar(this.m_DockBar);
    }

    private Rectangle CalculateTransFrameRectangle(MouseEvent e) {
        Rectangle rc = ((DockBarFrame_)this.m_Parent.getDockBarFrame()).getBounds();
        this.m_RootPoint = e.getPoint();
        UTIL.MapToDockFrameworkPoint(this, this.m_RootPoint);
        rc.x = this.m_RootPoint.x - this.m_MouseDownPoint.x;
        rc.y = this.m_RootPoint.y - this.m_MouseDownPoint.y;
        return rc;
    }

    public void mousePressed(MouseEvent e) {
        this.m_MouseDownPoint = e.getPoint();
        this.m_MouseDownPoint.x += this.getX() + this.getParent().getX();
        this.m_MouseDownPoint.y += this.getY() + this.getParent().getY();
        this.m_DockFramework = this.m_Parent.getDockBarFrame().getTitleBar().getDockFramework();
        this.m_TransFrame = (TransparentFrame_)this.m_DockFramework.getTransFrame();
    }

    public void mouseReleased(MouseEvent e) {
        DockContainer_ toWhich = null;
        boolean dockAhead = true;
        if (this.m_IsDraging && this.m_DockFramework != null && this.m_DockFramework.getTransFrame() != null) {
            ((TransparentFrame_)this.m_DockFramework.getTransFrame()).setVisible(false);
            toWhich = (DockContainer_)this.m_TransFrame.getDockToWhich();
            if (toWhich != null) {
                DockContainer_ toWhichParentDC = (DockContainer_)toWhich.getParentContainer();
                int sd = 0;
                switch (this.m_TransFrame.getDockToWhere()) {
                    case 1: {
                        dockAhead = true;
                        sd = 2;
                        break;
                    }
                    case 2: {
                        dockAhead = false;
                        sd = 2;
                        break;
                    }
                    case 4: {
                        dockAhead = true;
                        sd = 1;
                        break;
                    }
                    case 8: {
                        dockAhead = false;
                        sd = 1;
                    }
                }
                if (this.m_TransFrame.getDockToWhere() == 1 || this.m_TransFrame.getDockToWhere() == 2 || this.m_TransFrame.getDockToWhere() == 4 || this.m_TransFrame.getDockToWhere() == 8) {
                    this.m_Parent.getDockBarFrame().removeBar(this.m_DockBar);
                    DockContainer_ ndc = new DockContainer_(this.m_DockBar);
                    if (toWhich.isRoot()) {
                        toWhich.Split(sd, null, ndc, dockAhead);
                    } else if (toWhichParentDC.getSplitDirection() == sd) {
                        toWhichParentDC.Split(sd, toWhich, ndc, dockAhead);
                    } else {
                        toWhich.Split(sd, null, ndc, dockAhead);
                    }
                }
                if (this.m_TransFrame.getDockToWhere() == 16) {
                    this.m_Parent.getDockBarFrame().removeBar(this.m_DockBar);
                    toWhich.getDockBarFrame().addBar(this.m_DockBar);
                }
            }
        }
        this.m_IsDraging = false;
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.m_DockBar.equals(this.m_Parent.getDockBarFrame().getActiveDockBar())) {
            this.DrawCaption((Graphics2D)this.getGraphics(), new Color(0, 128, 0), this.getBounds());
        }
    }

    public void mouseExited(MouseEvent e) {
        if (!this.m_DockBar.equals(this.m_Parent.getDockBarFrame().getActiveDockBar())) {
            this.DrawCaption((Graphics2D)this.getGraphics(), Color.BLACK, this.getBounds());
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.m_IsDraging = true;
        Rectangle rc = this.CalculateTransFrameRectangle(e);
        Rectangle thisRC = ((DockContainer_)((DockBarFrame_)this.m_Parent.getDockBarFrame()).getParent()).getAbsoluteBounds();
        DockContainer_ dc = (DockContainer_)this.m_DockFramework.getDockContainerAtPoint(this.m_RootPoint);
        Rectangle dcRC = null;
        int level = 0;
        dcRC = dc == null ? new Rectangle(0, 0, 0, 0) : dc.getAbsoluteBounds();
        Rectangle rcLeft = UTIL.LeftPartOfRectangle(dcRC);
        Rectangle rcTop = UTIL.TopPartOfRectangle(dcRC);
        Rectangle rcRight = UTIL.RightPartOfRectangle(dcRC);
        Rectangle rcBottom = UTIL.BottomPartOfRectangle(dcRC);
        Rectangle rcMiddle = UTIL.MiddlePartOfRectangle(dcRC);
        int pos = 0;
        if (rcLeft.contains(this.m_RootPoint)) {
            pos = 1;
        }
        if (rcRight.contains(this.m_RootPoint)) {
            pos = 2;
        }
        if (rcTop.contains(this.m_RootPoint)) {
            pos = 4;
        }
        if (rcBottom.contains(this.m_RootPoint)) {
            pos = 8;
        }
        if (rcMiddle.contains(this.m_RootPoint)) {
            pos = 16;
        }
        this.m_TransFrame.setDockToWhich(dc);
        this.m_TransFrame.setDockToWhere(pos);
        if (dc != null) {
            switch (pos) {
                case 1: {
                    level = dc.sameLeftAscendCount() + 1;
                    level -= (int)(Math.floor((float)(this.m_RootPoint.x - rcLeft.x) / ((float)rcLeft.width + 1.0f) * (float)level) + 1.0);
                    dc = (DockContainer_)dc.ascend(level);
                    dcRC = dc.getAbsoluteBounds();
                    rcLeft = UTIL.LeftPartOfRectangle(dcRC);
                    this.m_TransFrame.setDockToWhich(dc);
                    rc = rcLeft;
                    this.m_TransFrame.setStyle(2);
                    break;
                }
                case 2: {
                    level = dc.sameRightAscendCount() + 1;
                    level -= (int)(Math.floor((float)(rcRight.x + rcRight.width - this.m_RootPoint.x) / ((float)rcRight.width + 1.0f) * (float)level) + 1.0);
                    dc = (DockContainer_)dc.ascend(level);
                    dcRC = dc.getAbsoluteBounds();
                    rcRight = UTIL.RightPartOfRectangle(dcRC);
                    this.m_TransFrame.setDockToWhich(dc);
                    rc = rcRight;
                    this.m_TransFrame.setStyle(2);
                    break;
                }
                case 4: {
                    level = dc.sameTopAscendCount() + 1;
                    level -= (int)(Math.floor((float)(this.m_RootPoint.y - rcTop.y) / ((float)rcTop.height + 1.0f) * (float)level) + 1.0);
                    dc = (DockContainer_)dc.ascend(level);
                    dcRC = dc.getAbsoluteBounds();
                    rcTop = UTIL.TopPartOfRectangle(dcRC);
                    this.m_TransFrame.setDockToWhich(dc);
                    rc = rcTop;
                    rc.x = dcRC.x;
                    rc.width = dcRC.width;
                    this.m_TransFrame.setStyle(2);
                    break;
                }
                case 8: {
                    level = dc.sameBottomAscendCount() + 1;
                    level -= (int)(Math.floor((float)(rcBottom.y + rcBottom.height - this.m_RootPoint.y) / ((float)rcBottom.height + 1.0f) * (float)level) + 1.0);
                    dc = (DockContainer_)dc.ascend(level);
                    dcRC = dc.getAbsoluteBounds();
                    rcBottom = UTIL.BottomPartOfRectangle(dcRC);
                    this.m_TransFrame.setDockToWhich(dc);
                    rc = rcBottom;
                    rc.x = dcRC.x;
                    rc.width = dcRC.width;
                    this.m_TransFrame.setStyle(2);
                    break;
                }
                case 16: {
                    rc = dcRC;
                    this.m_TransFrame.setStyle(3);
                    break;
                }
                case 0: {
                    this.m_TransFrame.setStyle(2);
                }
            }
        }
        this.m_TransFrame.setBounds(rc);
        this.m_TransFrame.setVisible(true);
    }

    public int getIndex() {
        int ti = this.m_Parent.getDockBarFrame().getDockBarList().indexOf(this.m_DockBar);
        return ti;
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void paint(Graphics g) {
        Rectangle rc = this.getBounds();
        int ci = this.m_Parent.getDockBarFrame().getActiveDockBarIndex();
        int ti = this.m_Parent.getDockBarFrame().getDockBarList().indexOf(this.m_DockBar);
        int w = rc.width - 1;
        boolean x = false;
        g.setColor(DockFramework.BackGroundColor);
        g.fillRect(0, ti == ci ? 0 : 1, rc.width, rc.height);
        if (ti == ci) {
            g.setColor(DockFramework.BorderLineColor);
            g.drawLine(0, 0, 0, 18);
            g.drawLine(0, 18, 2, 20);
            g.drawLine(2, 20, w - 3, 20);
            g.drawLine(w - 3, 20, w - 1, 18);
            g.drawLine(w - 1, 18, w - 1, 0);
            g.drawLine(w - 1, 0, w, 0);
            g.setColor(new Color(228, 226, 222));
            g.drawLine(3, 21, w - 3, 21);
            g.drawLine(w - 3, 21, w, 19);
            g.drawLine(w, 19, w, 1);
            int r = 0;
            while (r < 20) {
                int red = Math.min(255, DockFramework.BackGroundColor.getRed() + r * 2);
                int green = Math.min(255, DockFramework.BackGroundColor.getGreen() + r * 2);
                int blue = Math.min(255, DockFramework.BackGroundColor.getBlue() + r * 2);
                g.setColor(new Color(red, green, blue));
                if (r < 18) {
                    g.drawLine(1, r, w - 2, r);
                }
                if (r == 18) {
                    g.drawLine(2, r, w - 3, r);
                }
                if (r == 19) {
                    g.drawLine(3, r, w - 4, r);
                }
                ++r;
            }
            this.DrawCaption((Graphics2D)g, Color.BLACK, rc, 7);
        } else {
            g.setColor(DockFramework.BorderLineColor);
            if (ti - 1 != ci) {
                if (ti > 0) {
                    g.setColor(new Color(255, 255, 255));
                }
                g.drawLine(0, 3, 0, 16);
            }
            g.setColor(DockFramework.BorderLineColor);
            if (ti + 1 != ci) {
                g.drawLine(w, 3, w, 16);
            }
            this.DrawCaption((Graphics2D)g, Color.BLACK, rc);
        }
        super.paint(g);
    }

    public void setActive(boolean b) {
        if (b) {
            this.m_Grip.setBounds(4, 4, 6, 18);
        } else {
            this.m_Grip.setBounds(0, 0, 0, 0);
        }
    }

    private void DrawCaption(Graphics2D g, Color c, Rectangle rc) {
        this.DrawCaption(g, c, rc, 0);
    }

    private void DrawCaption(Graphics2D g, Color c, Rectangle rc, int delta) {
        Rectangle trc = new Rectangle(rc);
        trc.x = 5 + delta;
        trc.width -= 10 + delta;
        trc.height = 17;
        UTIL.DrawString(g, trc, this.m_DockBar.getBarTitle(), 0, Color.BLACK, c, "\u5b8b\u4f53", 12, false, false, false, 2, 2);
    }
}

