/*
 * Decompiled with CFR 0.152.
 */
package jun.dock.impl;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import jun.dock.core.DockFramework;
import jun.dock.impl.DockBarTabButton_;
import jun.dock.impl.DockBarTab_;
import jun.dock.impl.TransparentFrame_;
import jun.dock.impl.UTIL;

class DockBarTabButtonGrip
extends JComponent
implements ComponentListener,
MouseListener,
MouseMotionListener,
Serializable {
    private boolean m_IsDraging = false;
    int newIndex;
    private DockFramework m_DockFramework = null;
    private TransparentFrame_ m_TransFrame = null;
    private Point m_MouseDownPoint = new Point(0, 0);
    private Point m_RootPoint = new Point(0, 0);
    private DockBarTabButton_ m_pButton;

    DockBarTabButtonGrip(DockBarTabButton_ pb) {
        this.setOpaque(false);
        this.setCursor(UTIL.GetCursor(this, "EXCHANGE.gif", new Point(1, 1)));
        this.m_pButton = pb;
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paint(Graphics g) {
        int x = 0;
        int y = 0;
        g.setColor(DockFramework.BorderLineColor);
        Rectangle rc = this.getBounds();
        int i = 0;
        while (i < 5) {
            g.drawLine(x, y + i * 3, x, y + i * 3);
            g.drawLine(x + 4, y + i * 3, x + 4, y + i * 3);
            ++i;
        }
        g.setColor(Color.WHITE);
        i = 0;
        while (i < 5) {
            g.drawLine(x + 1, y + i * 3 + 1, x + 1, y + i * 3 + 1);
            g.drawLine(x + 1 + 4, y + i * 3 + 1, x + 1 + 4, y + i * 3 + 1);
            ++i;
        }
        super.paint(g);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.m_MouseDownPoint = e.getPoint();
        this.m_DockFramework = this.m_pButton.m_Parent.getDockBarFrame().getTitleBar().getDockFramework();
        this.m_TransFrame = (TransparentFrame_)this.m_DockFramework.getTransFrame();
    }

    public void mouseReleased(MouseEvent e) {
        if (this.m_IsDraging) {
            if (this.newIndex >= 0) {
                this.m_pButton.m_Parent.getDockBarFrame().setDockBarIndex(this.m_pButton.m_DockBar, this.newIndex);
            }
            if (this.m_TransFrame != null) {
                this.m_TransFrame.setVisible(false);
            }
        }
        this.m_IsDraging = false;
    }

    public void mouseDragged(MouseEvent e) {
        this.m_IsDraging = true;
        Point p = new Point(e.getX(), e.getY());
        p = this.MapToTabCoordinate(p);
        ArrayList widthList = this.m_pButton.m_Parent.getItemWidthList();
        int h = this.m_pButton.m_Parent.getHeight();
        this.newIndex = -1;
        Point p1 = null;
        Point p2 = null;
        if (p.y >= 0 && p.y <= h) {
            int w = 0;
            int wi = 0;
            int thisIndex = this.m_pButton.getIndex();
            int i = 0;
            while (i < widthList.size()) {
                wi = (Integer)widthList.get(i);
                if ((w += wi) > p.x) {
                    if (i == thisIndex) break;
                    this.newIndex = i;
                    if (thisIndex > i) {
                        if (w - wi / 2 < p.x) {
                            p1 = new Point(w - wi / 2, 4);
                            p2 = new Point(w, h);
                            ++this.newIndex;
                        } else {
                            p1 = new Point(w - wi, 4);
                            p2 = new Point(w - wi / 2, h);
                        }
                    }
                    if (thisIndex >= i) break;
                    if (w - wi / 2 > p.x) {
                        p1 = new Point(w - wi, 4);
                        p2 = new Point(w - wi / 2, h);
                        --this.newIndex;
                        break;
                    }
                    p1 = new Point(w - wi / 2, 4);
                    p2 = new Point(w, h);
                    break;
                }
                ++i;
            }
            if (p1 != null) {
                System.out.println(p1.x);
            }
            if (this.newIndex != thisIndex && this.newIndex >= 0 && p1 != null && p2 != null) {
                UTIL.MapToDockFrameworkPoint((DockBarTab_)this.m_pButton.m_Parent.getDockBarFrame().getTab(), p1);
                UTIL.MapToDockFrameworkPoint((DockBarTab_)this.m_pButton.m_Parent.getDockBarFrame().getTab(), p2);
                Rectangle rc = new Rectangle(p1.x, p1.y, p2.x - p1.x, p2.y - p1.y);
                this.m_TransFrame.setStyle(4);
                this.m_TransFrame.setBounds(rc);
                this.m_TransFrame.setVisible(true);
            }
        }
    }

    private Point MapToTabCoordinate(Point p) {
        return new Point(p.x + this.getX() + this.getParent().getX(), p.y + this.getY() + this.getParent().getY());
    }

    public void mouseMoved(MouseEvent e) {
    }
}

