/*
 * Decompiled with CFR 0.152.
 */
package jun.dock.core;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JLayeredPane;
import jun.dock.core.DockBar;
import jun.dock.core.DockContainer;
import jun.dock.core.TransparentFrame;
import jun.dock.impl.DockBar_;
import jun.dock.impl.DockContainer_;
import jun.dock.impl.TransparentFrame_;
import org.kxml.io.AbstractXmlWriter;
import org.kxml.io.XmlWriter;
import org.kxml.kdom.Document;
import org.kxml.kdom.Element;
import org.kxml.parser.KXML;
import org.kxml.parser.XmlParser;

public class DockFramework
extends JLayeredPane
implements ComponentListener,
Serializable {
    public static Color BackGroundColor = new Color(212, 208, 200);
    public static Color BorderLineColor = new Color(0x808080);
    private DockContainer_ MasterDockContainer = null;
    private TransparentFrame_ m_TransFrame = null;

    public DockFramework() {
        this.setLayout(null);
        this.setBounds(0, 0, 100, 100);
        this.addComponentListener(this);
    }

    public DockContainer newDockContainer(String name) {
        if (this.findDockContainerWhichContainAppointedDockFrame(name) != null) {
            return null;
        }
        DockContainer_ ret = new DockContainer_(name);
        if (this.MasterDockContainer == null) {
            this.MasterDockContainer = ret;
            this.add(ret);
        }
        return ret;
    }

    public DockContainer findDockContainerWhichContainAppointedDockFrame(String name) {
        return this.DirectContainAppointedDockFrame(this.MasterDockContainer, name);
    }

    private DockContainer DirectContainAppointedDockFrame(DockContainer dc, String name) {
        if (dc == null) {
            return null;
        }
        if (dc.getDockBarFrame() != null) {
            if (dc.getDockBarFrame().findDockBar(name) != null) {
                return dc;
            }
            if (dc.getDockBarFrame().findHideDockBar(name) != null) {
                return dc;
            }
        } else {
            DockContainer ret;
            DockContainer subDc;
            int i = 0;
            while (i < dc.getContainerList().size()) {
                subDc = (DockContainer)dc.getContainerList().get(i);
                ret = this.DirectContainAppointedDockFrame(subDc, name);
                if (ret != null) {
                    return ret;
                }
                ++i;
            }
            i = 0;
            while (i < dc.getHideContainerList().size()) {
                subDc = (DockContainer)dc.getHideContainerList().get(i);
                ret = this.DirectContainAppointedDockFrame(subDc, name);
                if (ret != null) {
                    return ret;
                }
                ++i;
            }
        }
        return null;
    }

    public DockBar findDockBar(String name) {
        return this.FindDockBar(this.MasterDockContainer, name);
    }

    private DockBar FindDockBar(DockContainer dc, String name) {
        DockBar ret = null;
        if (dc == null) {
            return null;
        }
        if (dc.getDockBarFrame() != null) {
            ret = dc.getDockBarFrame().findDockBar(name);
            if (ret != null) {
                return ret;
            }
            ret = dc.getDockBarFrame().findHideDockBar(name);
            if (ret != null) {
                return ret;
            }
        } else {
            DockContainer subDc;
            int i = 0;
            while (i < dc.getContainerList().size()) {
                subDc = (DockContainer)dc.getContainerList().get(i);
                ret = this.FindDockBar(subDc, name);
                if (ret != null) {
                    return ret;
                }
                ++i;
            }
            i = 0;
            while (i < dc.getHideContainerList().size()) {
                subDc = (DockContainer)dc.getHideContainerList().get(i);
                ret = this.FindDockBar(subDc, name);
                if (ret != null) {
                    return ret;
                }
                ++i;
            }
        }
        return null;
    }

    public void paint(Graphics g) {
        Rectangle rc = this.getBounds();
        g.setColor(BackGroundColor);
        g.fillRect(0, 0, rc.width, rc.height);
        super.paint(g);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        if (this.MasterDockContainer != null) {
            this.MasterDockContainer.setBounds(this.getBounds());
            this.MasterDockContainer.doLayout();
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    public DockContainer getDockContainerAtPoint(Point p) {
        return this.MasterDockContainer.getDockContainerAtPoint(p);
    }

    public String saveToString() {
        Document doc = new Document();
        Element e = new Element();
        e.setName("WiseRoot");
        this.MasterDockContainer.saveToXML(e);
        e.setValue("aa", "123");
        doc.addChild(4, (Object)e);
        StringWriter sw = new StringWriter();
        XmlWriter xw = new XmlWriter((Writer)sw);
        try {
            doc.write((AbstractXmlWriter)xw);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println(sw.toString());
        return sw.toString();
    }

    public void loadFromString(String s) {
        try {
            XmlParser parser = new XmlParser((Reader)new InputStreamReader(new ByteArrayInputStream(s.getBytes())));
            Document document = new Document();
            document.parse((KXML)parser);
            Element e = document.getElement("WiseRoot");
            if (this.MasterDockContainer != null) {
                this.remove(this.MasterDockContainer);
            }
            this.MasterDockContainer = (DockContainer_)DockContainer_.CreateFromXML(e);
            this.add(this.MasterDockContainer);
            this.SetVisibleFromXML(e);
            this.componentResized(null);
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void SetVisibleFromXML(Element e) {
        DockBar dockBar = null;
        if (!e.getValueDefault("BarFrame", "null").trim().toLowerCase().equals("null")) {
            Element ef = e.getElement("BarFrame");
            int bc = Integer.valueOf(ef.getValueDefault("DockBarCount", "0"));
            int i = 0;
            while (i < bc) {
                String dbName;
                Element edb = ef.getElement("DockBar_" + String.valueOf(i));
                if (edb.getValueDefault("Visible", "1").equals("0")) {
                    dbName = edb.getValueDefault("Name", "");
                    dockBar = this.findDockBar(dbName);
                    if (dockBar != null) {
                        dockBar.hideMe();
                    }
                    dockBar.setIndexBeforeHide(Integer.valueOf(edb.getValueDefault("IndexBeforeHide", "0")));
                }
                if (edb.getValue("Active").equals("1") && (dockBar = this.findDockBar(dbName = edb.getValueDefault("Name", ""))) != null) {
                    dockBar.activeMe();
                }
                ++i;
            }
        }
        int scc = Integer.valueOf(e.getValue("SubContainerCount"));
        int i = 0;
        while (i < scc) {
            Element ec = e.getElement("SubContainer_" + String.valueOf(i));
            this.SetVisibleFromXML(ec);
            ++i;
        }
    }

    public static DockBar newDockBar(String name) {
        return new DockBar_(name);
    }

    public TransparentFrame getTransFrame() {
        if (this.m_TransFrame == null) {
            this.m_TransFrame = new TransparentFrame_();
            this.m_TransFrame.setVisible(false);
            this.add(this.m_TransFrame);
            this.setLayer(this.m_TransFrame, JLayeredPane.DRAG_LAYER);
        }
        return this.m_TransFrame;
    }
}

