/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.util.Log;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class ArrayObjectDescription
extends AbstractObjectDescription {
    public ArrayObjectDescription(Class c) {
        super(c);
        if (!c.isArray()) {
            throw new IllegalArgumentException("Need an array class");
        }
    }

    public Object createObject() {
        try {
            Integer size = (Integer)this.getParameter("size");
            if (size == null) {
                ArrayList<Object> l = new ArrayList<Object>();
                int counter = 0;
                while (this.getParameterDefinition(String.valueOf(counter)) != null) {
                    Object value = this.getParameter(String.valueOf(counter));
                    if (value == null) break;
                    l.add(value);
                    ++counter;
                }
                Object o = Array.newInstance(this.getObjectClass().getComponentType(), l.size());
                int i = 0;
                while (i < l.size()) {
                    Array.set(o, i, l.get(i));
                    ++i;
                }
                return o;
            }
            Object o = Array.newInstance(this.getObjectClass().getComponentType(), (int)size);
            int i = 0;
            while (i < size) {
                Array.set(o, i, this.getParameter(String.valueOf(i)));
                ++i;
            }
            return o;
        }
        catch (Exception ie) {
            Log.warn("Unable to instantiate Object", ie);
            return null;
        }
    }

    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (o == null) {
            throw new ObjectFactoryException("Given object is null.");
        }
        if (!o.getClass().isArray()) {
            throw new ObjectFactoryException("Given object is no array");
        }
        if (!this.getObjectClass().isAssignableFrom(o.getClass())) {
            throw new ObjectFactoryException("Given object is incompatible with base class");
        }
        int size = Array.getLength(o);
        this.setParameter("size", new Integer(size));
        int i = 0;
        while (i < size) {
            this.setParameter(String.valueOf(i), Array.get(o, i));
            ++i;
        }
    }

    private int parseParameterName(String name) {
        try {
            return Integer.parseInt(name);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public Class getParameterDefinition(String name) {
        if (name.equals("size")) {
            return Integer.TYPE;
        }
        int par = this.parseParameterName(name);
        if (par < 0) {
            return null;
        }
        return this.getObjectClass().getComponentType();
    }

    public Iterator getParameterNames() {
        Integer size = (Integer)this.getParameter("size");
        if (size == null) {
            return this.getDefinedParameterNames();
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add("size");
        int i = 0;
        while (i < size) {
            l.add(String.valueOf(i));
            ++i;
        }
        return l.iterator();
    }

    public ObjectDescription getInstance() {
        return new ArrayObjectDescription(this.getObjectClass());
    }
}

