/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.visitors;

import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.RemarkNode;
import org.htmlparser.StringNode;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.tags.ImageTag;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.tags.Tag;
import org.htmlparser.visitors.NodeVisitor;

public class UrlModifyingVisitor
extends NodeVisitor {
    private String linkPrefix;
    private StringBuffer modifiedResult;
    private Parser parser;

    public UrlModifyingVisitor(Parser parser, String linkPrefix) {
        super(true, true);
        this.parser = parser;
        this.linkPrefix = linkPrefix;
        this.modifiedResult = new StringBuffer();
    }

    public void visitLinkTag(LinkTag linkTag) {
        linkTag.setLink(String.valueOf(this.linkPrefix) + linkTag.getLink());
    }

    public void visitImageTag(ImageTag imageTag) {
        imageTag.setImageURL(String.valueOf(this.linkPrefix) + imageTag.getImageURL());
    }

    public void visitRemarkNode(RemarkNode remarkNode) {
        this.modifiedResult.append(remarkNode.toHtml());
    }

    public void visitStringNode(StringNode stringNode) {
        this.modifiedResult.append(stringNode.toHtml());
    }

    public void visitTag(Tag tag) {
        if (!(tag.getParent() != null || tag instanceof CompositeTag && ((CompositeTag)tag).getEndTag() != null)) {
            this.modifiedResult.append(tag.toHtml());
        }
    }

    public void visitEndTag(Tag tag) {
        Node parent = tag.getParent();
        if (parent == null) {
            this.modifiedResult.append(tag.toHtml());
        } else if (parent.getParent() == null) {
            this.modifiedResult.append(parent.toHtml());
        }
    }

    public String getModifiedResult() {
        return this.modifiedResult.toString();
    }
}

