/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.util;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.util.SimpleNodeIterator;

public class NodeList
implements Serializable {
    private static final int INITIAL_CAPACITY = 10;
    private Node[] nodeData = this.newNodeArrayFor(this.capacity);
    private int size = 0;
    private int capacity = 10;
    private int capacityIncrement = this.capacity * 2;
    private int numberOfAdjustments = 0;

    public NodeList() {
    }

    public NodeList(Node node) {
        this();
        this.add(node);
    }

    public void add(Node node) {
        if (this.size == this.capacity) {
            this.adjustVectorCapacity();
        }
        this.nodeData[this.size++] = node;
    }

    public void add(NodeList list) {
        int i = 0;
        while (i < list.size) {
            this.add(list.nodeData[i]);
            ++i;
        }
    }

    public void prepend(Node node) {
        if (this.size == this.capacity) {
            this.adjustVectorCapacity();
        }
        System.arraycopy(this.nodeData, 0, this.nodeData, 1, this.size);
        ++this.size;
        this.nodeData[0] = node;
    }

    private void adjustVectorCapacity() {
        this.capacity += this.capacityIncrement;
        this.capacityIncrement *= 2;
        Node[] oldData = this.nodeData;
        this.nodeData = this.newNodeArrayFor(this.capacity);
        System.arraycopy(oldData, 0, this.nodeData, 0, this.size);
        ++this.numberOfAdjustments;
    }

    private Node[] newNodeArrayFor(int capacity) {
        return new Node[capacity];
    }

    public int size() {
        return this.size;
    }

    public Node elementAt(int i) {
        return this.nodeData[i];
    }

    public int getNumberOfAdjustments() {
        return this.numberOfAdjustments;
    }

    public SimpleNodeIterator elements() {
        return new SimpleNodeIterator(){
            int count = 0;

            public boolean hasMoreNodes() {
                return this.count < NodeList.this.size;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Node nextNode() {
                NodeList nodeList = NodeList.this;
                synchronized (nodeList) {
                    if (this.count < NodeList.this.size) {
                        return NodeList.this.nodeData[this.count++];
                    }
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    public Node[] toNodeArray() {
        Node[] nodeArray = this.newNodeArrayFor(this.size);
        System.arraycopy(this.nodeData, 0, nodeArray, 0, this.size);
        return nodeArray;
    }

    public void copyToNodeArray(Node[] array) {
        System.arraycopy(this.nodeData, 0, array, 0, this.size);
    }

    public String asString() {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < this.size) {
            buff.append(this.nodeData[i].toPlainTextString());
            ++i;
        }
        return buff.toString();
    }

    public String asHtml() {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < this.size) {
            buff.append(this.nodeData[i].toHtml());
            ++i;
        }
        return buff.toString();
    }

    public Node remove(int index) {
        Node ret = this.nodeData[index];
        System.arraycopy(this.nodeData, index + 1, this.nodeData, index, this.size - index - 1);
        this.nodeData[this.size - 1] = null;
        --this.size;
        return ret;
    }

    public void removeAll() {
        this.size = 0;
        this.capacity = 10;
        this.nodeData = this.newNodeArrayFor(this.capacity);
        this.capacityIncrement = this.capacity * 2;
        this.numberOfAdjustments = 0;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < this.size) {
            text.append(this.nodeData[i].toPlainTextString());
            ++i;
        }
        return text.toString();
    }

    public NodeList extractAllNodesThatMatch(NodeFilter filter) {
        return this.extractAllNodesThatMatch(filter, false);
    }

    public NodeList extractAllNodesThatMatch(NodeFilter filter, boolean recursive) {
        NodeList ret = new NodeList();
        int i = 0;
        while (i < this.size) {
            NodeList children;
            Node node = this.nodeData[i];
            if (filter.accept(node)) {
                ret.add(node);
            }
            if (recursive && (children = node.getChildren()) != null) {
                ret.add(children.extractAllNodesThatMatch(filter, recursive));
            }
            ++i;
        }
        return ret;
    }

    public void keepAllNodesThatMatch(NodeFilter filter) {
        this.keepAllNodesThatMatch(filter, false);
    }

    public void keepAllNodesThatMatch(NodeFilter filter, boolean recursive) {
        int i = 0;
        while (i < this.size) {
            NodeList children;
            Node node = this.nodeData[i];
            if (!filter.accept(node)) {
                this.remove(i);
                continue;
            }
            if (recursive && (children = node.getChildren()) != null) {
                children.keepAllNodesThatMatch(filter, recursive);
            }
            ++i;
        }
    }

    public NodeList searchFor(Class classType) {
        return this.searchFor(classType, false);
    }

    public NodeList searchFor(Class classType, boolean recursive) {
        return this.extractAllNodesThatMatch(new NodeClassFilter(classType), recursive);
    }
}

