/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.tags;

import org.htmlparser.Node;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.util.ParserUtils;
import org.htmlparser.util.SimpleNodeIterator;
import org.htmlparser.visitors.NodeVisitor;

public class LinkTag
extends CompositeTag {
    private static final String[] mIds = new String[]{"A"};
    private static final String[] mEnders = new String[]{"A", "P", "DIV", "TD", "TR", "FORM", "LI"};
    private static final String[] mEndTagEnders = new String[]{"P", "DIV", "TD", "TR", "FORM", "LI", "BODY", "HTML"};
    protected String mLink;
    private boolean mailLink;
    private boolean javascriptLink;

    public String[] getIds() {
        return mIds;
    }

    public String[] getEnders() {
        return mEnders;
    }

    public String[] getEndTagEnders() {
        return mEndTagEnders;
    }

    public String getAccessKey() {
        return this.getAttribute("ACCESSKEY");
    }

    public String getLink() {
        if (this.mLink == null) {
            int javascript;
            this.mailLink = false;
            this.javascriptLink = false;
            this.mLink = this.extractLink();
            int mailto = this.mLink.indexOf("mailto");
            if (mailto == 0) {
                mailto = this.mLink.indexOf(":");
                this.mLink = this.mLink.substring(mailto + 1);
                this.mailLink = true;
            }
            if ((javascript = this.mLink.indexOf("javascript:")) == 0) {
                this.mLink = this.mLink.substring(11);
                this.javascriptLink = true;
            }
        }
        return this.mLink;
    }

    public String getLinkText() {
        String ret = this.getChildren() != null ? this.getChildren().toString() : "";
        return ret;
    }

    public boolean isMailLink() {
        this.getLink();
        return this.mailLink;
    }

    public boolean isJavascriptLink() {
        this.getLink();
        return this.javascriptLink;
    }

    public boolean isFTPLink() {
        return this.getLink().indexOf("ftp://") == 0;
    }

    public boolean isIRCLink() {
        return this.getLink().indexOf("irc://") == 0;
    }

    public boolean isHTTPLink() {
        return !this.isFTPLink() && !this.isHTTPSLink() && !this.isJavascriptLink() && !this.isMailLink() && !this.isIRCLink();
    }

    public boolean isHTTPSLink() {
        return this.getLink().indexOf("https://") == 0;
    }

    public boolean isHTTPLikeLink() {
        return this.isHTTPLink() || this.isHTTPSLink();
    }

    public void setMailLink(boolean newMailLink) {
        this.mailLink = newMailLink;
    }

    public void setJavascriptLink(boolean newJavascriptLink) {
        this.javascriptLink = newJavascriptLink;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Link to : " + this.getLink() + "; titled : " + this.getLinkText() + "; begins at : " + this.getStartPosition() + "; ends at : " + this.getEndPosition() + ", AccessKey=");
        if (this.getAccessKey() == null) {
            sb.append("null\n");
        } else {
            sb.append(String.valueOf(this.getAccessKey()) + "\n");
        }
        if (this.getChildren() != null) {
            sb.append("  LinkData\n");
            sb.append("  --------\n");
            int i = 0;
            SimpleNodeIterator e = this.children();
            while (e.hasMoreNodes()) {
                Node node = e.nextNode();
                sb.append("   " + i++ + " ");
                sb.append(String.valueOf(node.toString()) + "\n");
            }
        }
        sb.append("  *** END of LinkData ***\n");
        return sb.toString();
    }

    public void setLink(String link) {
        this.mLink = link;
        this.setAttribute("HREF", link);
    }

    public SimpleNodeIterator linkData() {
        return this.children();
    }

    public void accept(NodeVisitor visitor) {
        visitor.visitLinkTag(this);
        super.accept(visitor);
    }

    public String extractLink() {
        String relativeLink = this.getAttribute("HREF");
        if (relativeLink != null) {
            relativeLink = ParserUtils.removeChars(relativeLink, '\n');
            relativeLink = ParserUtils.removeChars(relativeLink, '\r');
        }
        return this.getPage().getLinkProcessor().extract(relativeLink, this.getPage().getUrl());
    }
}

