/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.tags;

import java.util.Locale;
import java.util.Vector;
import org.htmlparser.lexer.nodes.Attribute;
import org.htmlparser.tags.Tag;
import org.htmlparser.util.ParserUtils;
import org.htmlparser.visitors.NodeVisitor;

public class ImageTag
extends Tag {
    private static final String[] mIds = new String[]{"IMG"};
    protected String imageURL = null;

    public String[] getIds() {
        return mIds;
    }

    public String extractImageLocn() {
        String ret = "";
        int state = 0;
        Vector attributes = this.getAttributesEx();
        int size = attributes.size();
        int i = 0;
        while (i < size && state < 3) {
            Attribute attribute = (Attribute)attributes.elementAt(i);
            String string = attribute.getName();
            String data = attribute.getValue();
            switch (state) {
                case 0: {
                    if (string == null) break;
                    String name = string.toUpperCase(Locale.ENGLISH);
                    if (name.equals("SRC")) {
                        state = 1;
                        if (data == null) break;
                        if ("".equals(data)) {
                            state = 2;
                            break;
                        }
                        ret = data;
                        i = size;
                        break;
                    }
                    if (!name.startsWith("SRC")) break;
                    ret = string.substring(3);
                    state = 0;
                    break;
                }
                case 1: {
                    if (string == null || !string.startsWith("=")) break;
                    state = 2;
                    if (1 < string.length()) {
                        ret = string.substring(1);
                        state = 0;
                        break;
                    }
                    if (data == null) break;
                    ret = string.substring(1);
                    state = 0;
                    break;
                }
                case 2: {
                    if (string == null) break;
                    if (data == null) {
                        ret = string;
                    }
                    state = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("we're not supposed to in state " + state);
                }
            }
            ++i;
        }
        ret = ParserUtils.removeChars(ret, '\n');
        ret = ParserUtils.removeChars(ret, '\r');
        return ret;
    }

    public String getImageURL() {
        if (this.imageURL == null && this.getPage() != null) {
            this.imageURL = this.getPage().getLinkProcessor().extract(this.extractImageLocn(), this.getPage().getUrl());
        }
        return this.imageURL;
    }

    public void setImageURL(String url) {
        this.imageURL = url;
        this.setAttribute("SRC", this.imageURL);
    }

    public void accept(NodeVisitor visitor) {
        visitor.visitImageTag(this);
        super.accept(visitor);
    }
}

