/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.tags;

import org.htmlparser.tags.CompositeTag;
import org.htmlparser.tags.InputTag;
import org.htmlparser.tags.TextareaTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.SimpleNodeIterator;

public class FormTag
extends CompositeTag {
    public static final String POST = "POST";
    public static final String GET = "GET";
    protected String mFormLocation = null;
    private static final String[] mIds = new String[]{"FORM"};
    private static final String[] mEndTagEnders = new String[]{"HTML", "BODY", "TABLE"};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public String[] getIds() {
        return mIds;
    }

    public String[] getEnders() {
        return mIds;
    }

    public String[] getEndTagEnders() {
        return mEndTagEnders;
    }

    public NodeList getFormInputs() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.htmlparser.tags.InputTag");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.searchFor(clazz, true);
    }

    public NodeList getFormTextareas() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.htmlparser.tags.TextareaTag");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.searchFor(clazz, true);
    }

    public String getFormLocation() {
        if (this.mFormLocation == null) {
            this.mFormLocation = this.extractFormLocn(this.getPage().getUrl());
        }
        return this.mFormLocation;
    }

    public void setFormLocation(String url) {
        this.mFormLocation = url;
        this.setAttribute("ACTION", url);
    }

    public String getFormMethod() {
        String ret = this.getAttribute("METHOD");
        if (ret == null) {
            ret = GET;
        }
        return ret;
    }

    public InputTag getInputTag(String name) {
        InputTag inputTag = null;
        boolean found = false;
        SimpleNodeIterator e = this.getFormInputs().elements();
        while (e.hasMoreNodes() && !found) {
            inputTag = (InputTag)e.nextNode();
            String inputTagName = inputTag.getAttribute("NAME");
            if (inputTagName == null || !inputTagName.equalsIgnoreCase(name)) continue;
            found = true;
        }
        if (found) {
            return inputTag;
        }
        return null;
    }

    public String getFormName() {
        return this.getAttribute("NAME");
    }

    public TextareaTag getTextAreaTag(String name) {
        TextareaTag textareaTag = null;
        boolean found = false;
        SimpleNodeIterator e = this.getFormTextareas().elements();
        while (e.hasMoreNodes() && !found) {
            textareaTag = (TextareaTag)e.nextNode();
            String textAreaName = textareaTag.getAttribute("NAME");
            if (textAreaName == null || !textAreaName.equals(name)) continue;
            found = true;
        }
        if (found) {
            return textareaTag;
        }
        return null;
    }

    public String toString() {
        return "FORM TAG : Form at " + this.getFormLocation() + "; begins at : " + this.getStartPosition() + "; ends at : " + this.getEndPosition();
    }

    public String extractFormLocn(String url) {
        String formURL = this.getAttribute("ACTION");
        if (formURL == null) {
            return "";
        }
        return this.getPage().getLinkProcessor().extract(formURL, url);
    }
}

