/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import java.util.Vector;
import org.htmlparser.Node;
import org.htmlparser.PrototypicalNodeFactory;
import org.htmlparser.RemarkNode;
import org.htmlparser.StringNode;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.nodes.NodeFactory;
import org.htmlparser.scanners.CompositeTagScanner;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.tags.Tag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class StyleScanner
extends CompositeTagScanner {
    public Tag scan(Tag tag, Lexer lexer, NodeList stack) throws ParserException {
        CompositeTag ret;
        boolean done = false;
        StringNode last = null;
        Tag end = null;
        NodeFactory factory = lexer.getNodeFactory();
        lexer.setNodeFactory(new PrototypicalNodeFactory(true));
        try {
            int position;
            do {
                position = lexer.getPosition();
                Node node = lexer.nextNode(true);
                if (node == null) break;
                if (node instanceof Tag) {
                    if (((Tag)node).isEndTag() && ((Tag)node).getTagName().equals(tag.getIds()[0])) {
                        end = (Tag)node;
                        done = true;
                        continue;
                    }
                    if (this.isTagToBeEndedFor(tag, (Tag)node)) {
                        lexer.setPosition(position);
                        done = true;
                        continue;
                    }
                    if (last != null) {
                        last.setEndPosition(node.elementEnd());
                        continue;
                    }
                    last = (StringNode)factory.createStringNode(lexer.getPage(), node.elementBegin(), node.elementEnd());
                    continue;
                }
                if (node instanceof RemarkNode) {
                    if (last != null) {
                        last.setEndPosition(node.getEndPosition());
                        continue;
                    }
                    last = (StringNode)factory.createStringNode(lexer.getPage(), node.elementBegin(), node.elementEnd());
                    continue;
                }
                if (last != null) {
                    last.setEndPosition(node.getEndPosition());
                    continue;
                }
                last = (StringNode)node;
            } while (!done);
            if (last == null) {
                last = (StringNode)factory.createStringNode(lexer.getPage(), position, position);
            }
            if (end == null) {
                end = new Tag(lexer.getPage(), tag.getEndPosition(), tag.getEndPosition(), new Vector());
            }
            ret = (CompositeTag)tag;
            ret.setEndTag(end);
            ret.setChildren(new NodeList(last));
            last.setParent(ret);
            end.setParent(ret);
            ret.doSemanticAction();
        }
        finally {
            lexer.setNodeFactory(factory);
        }
        return ret;
    }
}

