/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.scanners;

import java.util.Vector;
import org.htmlparser.Node;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.lexer.nodes.Attribute;
import org.htmlparser.scanners.TagScanner;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.tags.Tag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class CompositeTagScanner
extends TagScanner {
    private static final boolean mUseJVMStack = false;
    private static final boolean mLeaveEnds = false;

    public Tag scan(Tag tag, Lexer lexer, NodeList stack) throws ParserException {
        CompositeTag ret = (CompositeTag)tag;
        if (ret.isEmptyXmlTag()) {
            ret.setEndTag(ret);
        } else {
            Node node;
            do {
                int depth;
                TagScanner scanner;
                if ((node = lexer.nextNode(false)) != null) {
                    if (node instanceof Tag) {
                        Tag next = (Tag)node;
                        String name = next.getTagName();
                        if (next.isEndTag() && name.equals(ret.getTagName())) {
                            ret.setEndTag(next);
                            node = null;
                        } else if (this.isTagToBeEndedFor(ret, next)) {
                            lexer.setPosition(next.getStartPosition());
                            node = null;
                        } else if (!next.isEndTag()) {
                            scanner = next.getThisScanner();
                            if (scanner != null) {
                                if (scanner == this && next instanceof CompositeTag) {
                                    CompositeTag ondeck = (CompositeTag)next;
                                    if (ondeck.isEmptyXmlTag()) {
                                        ondeck.setEndTag(ondeck);
                                        this.finishTag(ondeck, lexer);
                                        this.addChild(ret, ondeck);
                                    } else {
                                        stack.add(ret);
                                        ret = ondeck;
                                    }
                                } else {
                                    node = scanner.scan(next, lexer, stack);
                                    this.addChild(ret, node);
                                }
                            } else {
                                this.addChild(ret, next);
                            }
                        } else {
                            Vector<Attribute> attributes = new Vector<Attribute>();
                            attributes.addElement(new Attribute(name, null));
                            Tag opener = (Tag)lexer.getNodeFactory().createTagNode(next.getPage(), next.getStartPosition(), next.getEndPosition(), attributes);
                            scanner = opener.getThisScanner();
                            if (scanner != null && scanner == this) {
                                int index = -1;
                                int i = stack.size() - 1;
                                while (-1 == index && i >= 0) {
                                    CompositeTag boffo = (CompositeTag)stack.elementAt(i);
                                    if (name.equals(boffo.getTagName())) {
                                        index = i;
                                    } else if (this.isTagToBeEndedFor(boffo, next)) {
                                        index = i;
                                    }
                                    --i;
                                }
                                if (-1 != index) {
                                    this.finishTag(ret, lexer);
                                    this.addChild((CompositeTag)stack.elementAt(stack.size() - 1), ret);
                                    i = stack.size() - 1;
                                    while (i > index) {
                                        CompositeTag fred = (CompositeTag)stack.remove(i);
                                        this.finishTag(fred, lexer);
                                        this.addChild((CompositeTag)stack.elementAt(i - 1), fred);
                                        --i;
                                    }
                                    ret = (CompositeTag)stack.remove(index);
                                    node = null;
                                } else {
                                    this.addChild(ret, next);
                                }
                            } else {
                                this.addChild(ret, next);
                            }
                        }
                    } else {
                        this.addChild(ret, node);
                    }
                }
                if (node != null || (depth = stack.size()) == 0) continue;
                node = stack.elementAt(depth - 1);
                if (node instanceof CompositeTag) {
                    CompositeTag precursor = (CompositeTag)node;
                    scanner = precursor.getThisScanner();
                    if (scanner == this) {
                        stack.remove(depth - 1);
                        this.finishTag(ret, lexer);
                        this.addChild(precursor, ret);
                        ret = precursor;
                        continue;
                    }
                    node = null;
                    continue;
                }
                node = null;
            } while (node != null);
        }
        this.finishTag(ret, lexer);
        return ret;
    }

    protected void addChild(Tag parent, Node child) {
        if (parent.getChildren() == null) {
            parent.setChildren(new NodeList());
        }
        child.setParent(parent);
        parent.getChildren().add(child);
    }

    protected void finishTag(CompositeTag tag, Lexer lexer) throws ParserException {
        if (tag.getEndTag() == null) {
            tag.setEndTag(this.createVirtualEndTag(tag, lexer.getPage(), lexer.getCursor().getPosition()));
        }
        tag.getEndTag().setParent(tag);
        tag.doSemanticAction();
    }

    protected Tag createVirtualEndTag(Tag tag, Page page, int position) {
        String name = "/" + tag.getRawTagName();
        Vector<Attribute> attributes = new Vector<Attribute>();
        attributes.addElement(new Attribute(name, null));
        Tag ret = new Tag(page, position, position, attributes);
        return ret;
    }

    public final boolean isTagToBeEndedFor(Tag current, Tag tag) {
        boolean ret = false;
        String name = tag.getTagName();
        String[] ends = tag.isEndTag() ? current.getEndTagEnders() : current.getEnders();
        int i = 0;
        while (i < ends.length) {
            if (name.equalsIgnoreCase(ends[i])) {
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }
}

