/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexerapplications.thumbelina;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.border.BevelBorder;
import org.htmlparser.lexerapplications.thumbelina.Picture;
import org.htmlparser.lexerapplications.thumbelina.Thumbelina;
import org.htmlparser.lexerapplications.thumbelina.TileSet;

public class PicturePanel
extends JPanel
implements MouseListener,
Scrollable,
ComponentListener,
HierarchyListener {
    protected static final int UNIT_INCREMENT = 10;
    protected static final int BLOCK_INCREMENT = 100;
    protected Thumbelina mThumbelina;
    protected TileSet mMosaic;
    protected Dimension mPreferredSize;

    public PicturePanel(Thumbelina thumbelina) {
        this.mThumbelina = thumbelina;
        this.mMosaic = new TileSet();
        this.mPreferredSize = null;
        this.setBorder(new BevelBorder(1));
        this.addMouseListener(this);
        this.addHierarchyListener(this);
    }

    public void reset() {
        this.mMosaic = new TileSet();
        this.repaint();
    }

    public void bringToTop(Picture picture) {
        picture.reset();
        this.mMosaic.bringToTop(picture);
        this.repaint(picture.x, picture.y, picture.width, picture.height);
        this.mThumbelina.mUrlText.setText(picture.getURL().toExternalForm());
    }

    public Picture find(String url) {
        Picture ret = null;
        Enumeration enumeration = this.mMosaic.getPictures();
        while (ret == null && enumeration.hasMoreElements()) {
            Picture picture = (Picture)enumeration.nextElement();
            if (!url.equals(picture.getURL().toExternalForm())) continue;
            ret = picture;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(Picture picture, boolean add) {
        Container parent = this.getParent();
        boolean dolayout = false;
        TileSet tileSet = this.mMosaic;
        synchronized (tileSet) {
            if (parent instanceof JViewport) {
                Dimension before = this.getPreferredSize();
                this.mMosaic.add(picture);
                Dimension after = this.calculatePreferredSize();
                if (after.width > before.width) {
                    dolayout = true;
                } else {
                    after.width = before.width;
                }
                if (after.height > before.height) {
                    dolayout = true;
                } else {
                    after.height = before.height;
                }
                if (dolayout) {
                    this.mPreferredSize = after;
                }
            } else {
                this.mMosaic.add(picture);
            }
        }
        if (dolayout) {
            this.revalidate();
        }
        this.repaint(picture.x, picture.y, picture.width, picture.height);
        if (add) {
            this.mThumbelina.addHistory(picture.getURL().toExternalForm());
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void adjustClipForInsets(Graphics graphics) {
        Dimension dim = this.getSize();
        Insets insets = this.getInsets();
        Rectangle clip = graphics.getClipBounds();
        if (clip.x < insets.left) {
            clip.x = insets.left;
        }
        if (clip.y < insets.top) {
            clip.y = insets.top;
        }
        if (clip.x + clip.width > dim.width - insets.right) {
            clip.width = dim.width - insets.right - clip.x;
        }
        if (clip.y + clip.height > dim.height - insets.bottom) {
            clip.height = dim.height - insets.bottom - clip.y;
        }
        graphics.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        this.adjustClipForInsets(graphics);
        Rectangle clip = graphics.getClipBounds();
        TileSet tileSet = this.mMosaic;
        synchronized (tileSet) {
            if (this.mMosaic.getSize() == 0) {
                super.paint(graphics);
            } else {
                super.paint(graphics);
                Enumeration enumeration = this.mMosaic.getPictures();
                HashSet<Image> set = new HashSet<Image>();
                while (enumeration.hasMoreElements()) {
                    Image image;
                    Picture picture = (Picture)enumeration.nextElement();
                    if (clip != null && !clip.intersects(picture) || set.contains(image = picture.getImage())) continue;
                    Point origin = picture.getOrigin();
                    int width = image.getWidth(this);
                    int height = image.getHeight(this);
                    graphics.drawImage(picture.getImage(), origin.x, origin.y, origin.x + width, origin.y + height, 0, 0, width, height, this);
                    set.add(image);
                }
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.mPreferredSize == null) {
            this.setPreferredSize(this.calculatePreferredSize());
        } else if (this.mPreferredSize.width == 0 || this.mPreferredSize.height == 0) {
            this.setPreferredSize(this.calculatePreferredSize());
        }
        return this.mPreferredSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.mPreferredSize = dimension;
    }

    protected Dimension calculatePreferredSize() {
        Dimension ret;
        Enumeration enumeration = this.mMosaic.getPictures();
        int x = 0;
        int y = 0;
        Picture picture = null;
        while (enumeration.hasMoreElements()) {
            picture = (Picture)enumeration.nextElement();
            if (picture.x + picture.width > x) {
                x = picture.x + picture.width;
            }
            if (picture.y + picture.height <= y) continue;
            y = picture.y + picture.height;
        }
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            ret = parent.getSize();
            Insets insets = ((JViewport)parent).getInsets();
            ret.width -= insets.left + insets.right;
            ret.height -= insets.top + insets.bottom;
            if (ret.width != 0 || ret.height != 0) {
                ret.width -= 2;
            }
            if (ret.width < x) {
                ret.width = x;
            }
            if (ret.height < y) {
                ret.height = y;
            }
        } else {
            Insets insets = this.getInsets();
            ret = new Dimension(x += insets.left + insets.right, y += insets.top + insets.bottom);
        }
        return ret;
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        Picture picture;
        if (!event.isMetaDown() && (picture = this.mMosaic.pictureAt(event.getX(), event.getY())) != null) {
            this.bringToTop(picture);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 100;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void componentResized(ComponentEvent event) {
        this.setPreferredSize(null);
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentShown(ComponentEvent event) {
    }

    public void componentHidden(ComponentEvent event) {
    }

    public void hierarchyChanged(HierarchyEvent event) {
        if (0L != (event.getChangeFlags() & 1L)) {
            Component dad = event.getChanged();
            Container parent = this.getParent();
            if (parent != null && parent.getParent() == dad) {
                dad.addComponentListener(this);
            }
        }
    }
}

