/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexerapplications.thumbelina;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URL;

public class Picture
extends Rectangle {
    public static final Point ORIGIN = new Point(0, 0);
    protected URL mURL;
    protected Image mImage;
    protected Point mOrigin;

    public Picture() {
        this.setURL(null);
        this.setImage(null);
        this.setOrigin(ORIGIN);
    }

    public Picture(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setURL(null);
        this.setImage(null);
        this.setOrigin(new Point(x, y));
    }

    public Picture(Rectangle r) {
        super(r);
        this.setURL(null);
        this.setImage(null);
        this.setOrigin(new Point(r.x, r.y));
    }

    public Picture(Picture picture) {
        super(picture);
        this.setURL(picture.getURL());
        this.setImage(picture.getImage());
        this.setOrigin(picture.getOrigin());
    }

    public URL getURL() {
        return this.mURL;
    }

    public void setURL(URL url) {
        this.mURL = url;
    }

    public Image getImage() {
        return this.mImage;
    }

    public void setImage(Image image) {
        this.mImage = image;
        if (image != null) {
            this.width = image.getWidth(null);
            this.height = image.getHeight(null);
        }
    }

    public Point getOrigin() {
        return this.mOrigin;
    }

    public void setOrigin(Point origin) {
        this.mOrigin = origin;
    }

    public boolean same(Picture picture) {
        return this.mImage == picture.mImage;
    }

    public void reset() {
        this.setBounds(this.mOrigin.x, this.mOrigin.y, this.mImage.getWidth(null), this.mImage.getHeight(null));
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.getURL().toString());
        ret.append("[x=");
        ret.append(Integer.toString(this.x));
        ret.append(",y=");
        ret.append(Integer.toString(this.y));
        ret.append(",width=");
        ret.append(Integer.toString(this.width));
        ret.append(",height=");
        ret.append(Integer.toString(this.height));
        ret.append("]");
        return ret.toString();
    }
}

