/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexerapplications.tabby;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.htmlparser.lexer.Cursor;
import org.htmlparser.lexer.Page;

public class Tabby {
    private static final int DEFAULT_TABSTOP = 4;
    protected Filter mFilter = null;
    protected int mTabsize = 4;

    public Tabby() {
    }

    public Tabby(String filter) {
        this();
        this.mFilter = new Filter(filter);
    }

    public Tabby(String filter, int tabsize) throws IllegalArgumentException {
        this(filter);
        if (tabsize <= 0) {
            throw new IllegalArgumentException("tab size cannot be negative");
        }
        this.mTabsize = tabsize;
    }

    protected void process(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles(this.mFilter);
            int i = 0;
            while (i < files.length) {
                this.process(files[i]);
                ++i;
            }
        } else {
            this.edit(file);
        }
    }

    protected void edit(File file) {
        try {
            boolean modified;
            FileInputStream in = new FileInputStream(file);
            StringBuffer buffer = new StringBuffer(in.available());
            try {
                char ch;
                Page page = new Page(in, null);
                Cursor cursor = new Cursor(page, 0);
                int position = 0;
                modified = false;
                int expected = 0;
                int last = -1;
                while ((ch = page.getCharacter(cursor)) != '\u0000') {
                    if (++expected != cursor.getPosition()) {
                        modified = true;
                        expected = cursor.getPosition();
                    }
                    if ('\t' == ch) {
                        do {
                            buffer.append(' ');
                        } while (++position % this.mTabsize != 0);
                        modified = true;
                        continue;
                    }
                    if ('\n' == ch) {
                        if (last + 1 != position) {
                            last = buffer.length() - (position - last - 1);
                            buffer.setLength(last);
                            modified = true;
                        }
                        buffer.append(ch);
                        position = 0;
                        last = -1;
                        continue;
                    }
                    buffer.append(ch);
                    if (!Character.isWhitespace(ch)) {
                        last = position;
                    }
                    ++position;
                }
            }
            finally {
                in.close();
            }
            if (modified) {
                System.out.println(file.getAbsolutePath());
                FileOutputStream out = new FileOutputStream(file);
                out.write(buffer.toString().getBytes("GBK"));
                out.close();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("usage: Tabby (<directory>|<file>) [file-match regexp] [tabsize]");
        } else {
            Tabby tabby = 2 < args.length ? new Tabby(args[1], Integer.parseInt(args[2])) : (1 < args.length ? new Tabby(args[1]) : new Tabby());
            File file = new File(args[0]);
            tabby.process(file);
        }
    }

    class Filter
    implements FileFilter {
        protected Pattern mExpression;

        public Filter(String expression) throws PatternSyntaxException {
            if (expression == null) {
                throw new IllegalArgumentException("filter expression cannot be null");
            }
            this.mExpression = Pattern.compile(expression);
        }

        public boolean accept(File pathname) {
            boolean ret;
            if (pathname.isDirectory()) {
                ret = true;
            } else {
                Matcher matcher = this.mExpression.matcher(pathname.getAbsolutePath());
                ret = matcher.matches();
            }
            return ret;
        }
    }
}

