/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.htmlparser.lexer.Stream;

public class Source
extends Reader
implements Serializable {
    public static int BUFFER_SIZE = 16384;
    public static final int EOF = -1;
    protected transient InputStream mStream;
    protected String mEncoding;
    protected transient InputStreamReader mReader;
    public char[] mBuffer;
    public int mLevel;
    public int mOffset;
    protected int mMark;

    public Source(InputStream stream) throws UnsupportedEncodingException {
        this(stream, null, BUFFER_SIZE);
    }

    public Source(InputStream stream, String charset) throws UnsupportedEncodingException {
        this(stream, charset, BUFFER_SIZE);
    }

    public Source(InputStream stream, String charset, int buffer_size) throws UnsupportedEncodingException {
        if (stream == null) {
            stream = new Stream(null);
        }
        this.mStream = stream;
        if (charset == null) {
            this.mReader = new InputStreamReader(stream);
            this.mEncoding = this.mReader.getEncoding();
        } else {
            this.mEncoding = charset;
            this.mReader = new InputStreamReader(stream, charset);
        }
        this.mBuffer = new char[buffer_size];
        this.mLevel = 0;
        this.mOffset = 0;
        this.mMark = -1;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.mStream != null) {
            int offset = this.mOffset;
            char[] buffer = new char[4096];
            while (-1 != this.read(buffer)) {
            }
            this.mOffset = offset;
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.mBuffer != null) {
            this.mStream = new ByteArrayInputStream(new byte[0]);
        }
    }

    public InputStream getStream() {
        return this.mStream;
    }

    public String getEncoding() {
        return this.mEncoding;
    }

    protected void fill(int min) throws IOException {
        if (this.mReader != null) {
            char[] buffer;
            int read;
            int size = this.mBuffer.length - this.mLevel;
            if (size < min) {
                size = this.mBuffer.length * 2;
                read = this.mLevel + min;
                if (size < read) {
                    size = read;
                } else {
                    min = size - this.mLevel;
                }
                buffer = new char[size];
            } else {
                buffer = this.mBuffer;
                min = size;
            }
            read = this.mReader.read(buffer, this.mLevel, min);
            if (-1 == read) {
                this.mReader.close();
                this.mReader = null;
            } else {
                if (this.mBuffer != buffer) {
                    System.arraycopy(this.mBuffer, 0, buffer, 0, this.mLevel);
                    this.mBuffer = buffer;
                }
                this.mLevel += read;
            }
        }
    }

    public void close() throws IOException {
    }

    public int read() throws IOException {
        int ret;
        if (this.mLevel - this.mOffset < 1) {
            if (this.mStream == null) {
                throw new IOException("reader is closed");
            }
            this.fill(1);
            ret = this.mOffset >= this.mLevel ? -1 : this.mBuffer[this.mOffset++];
        } else {
            ret = this.mBuffer[this.mOffset++];
        }
        return ret;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int ret;
        if (this.mStream == null) {
            throw new IOException("reader is closed");
        }
        if (cbuf == null || off < 0 || len < 0) {
            throw new IOException("illegal argument read (" + (cbuf == null ? "null" : "cbuf") + ", " + off + ", " + len + ")");
        }
        if (this.mLevel - this.mOffset < len) {
            this.fill(len - (this.mLevel - this.mOffset));
        }
        if (this.mOffset >= this.mLevel) {
            ret = -1;
        } else {
            ret = Math.min(this.mLevel - this.mOffset, len);
            System.arraycopy(this.mBuffer, this.mOffset, cbuf, off, ret);
            this.mOffset += ret;
        }
        return ret;
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public void reset() {
        if (this.mStream == null) {
            throw new IllegalStateException("source is closed");
        }
        this.mOffset = -1 != this.mMark ? this.mMark : 0;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) throws IOException {
        if (this.mStream == null) {
            throw new IOException("reader is closed");
        }
        this.mMark = this.mOffset;
    }

    public boolean ready() throws IOException {
        if (this.mStream == null) {
            throw new IOException("reader is closed");
        }
        return this.mOffset < this.mLevel;
    }

    public long skip(long n) throws IOException {
        long ret;
        if (this.mStream == null) {
            throw new IOException("reader is closed");
        }
        if ((long)(this.mLevel - this.mOffset) < n) {
            this.fill((int)(n - (long)(this.mLevel - this.mOffset)));
        }
        if (this.mOffset >= this.mLevel) {
            ret = -1L;
        } else {
            ret = Math.min((long)(this.mLevel - this.mOffset), n);
            this.mOffset = (int)((long)this.mOffset + ret);
        }
        return ret;
    }

    public void unread() throws IOException {
        if (this.mOffset > 0) {
            --this.mOffset;
        } else {
            throw new IOException("can't unread no characters");
        }
    }

    public void destroy() throws IOException {
        this.mStream = null;
        if (this.mReader != null) {
            this.mReader.close();
        }
        this.mReader = null;
        this.mBuffer = null;
        this.mLevel = 0;
        this.mOffset = 0;
        this.mMark = -1;
    }

    public int offset() {
        return this.mOffset;
    }

    public int available() {
        return this.mLevel - this.mOffset;
    }
}

