/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.filters;

import java.util.Locale;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.lexer.nodes.StringNode;

public class StringFilter
implements NodeFilter {
    protected String mPattern;
    protected boolean mCaseSensitive;
    protected Locale mLocale;

    public StringFilter(String pattern) {
        this(pattern, false);
    }

    public StringFilter(String pattern, boolean case_sensitive) {
        this(pattern, case_sensitive, null);
    }

    public StringFilter(String pattern, boolean case_sensitive, Locale locale) {
        this.mCaseSensitive = case_sensitive;
        if (this.mCaseSensitive) {
            this.mPattern = pattern;
        } else {
            this.mLocale = locale == null ? Locale.ENGLISH : locale;
            this.mPattern = pattern.toUpperCase(this.mLocale);
        }
    }

    public boolean accept(Node node) {
        boolean ret = false;
        if (node instanceof StringNode) {
            String string = ((StringNode)node).getText();
            if (!this.mCaseSensitive) {
                string = string.toUpperCase(this.mLocale);
            }
            ret = -1 != string.indexOf(this.mPattern);
        }
        return ret;
    }
}

