/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.beans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.util.EncodingChangeException;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.ObjectFindingVisitor;

public class LinkBean
implements Serializable {
    public static final String PROP_LINKS_PROPERTY = "Links";
    public static final String PROP_URL_PROPERTY = "URL";
    protected PropertyChangeSupport mPropertySupport = new PropertyChangeSupport(this);
    protected URL[] mLinks = null;
    protected Parser mParser = new Parser();
    static /* synthetic */ Class class$0;

    protected URL[] extractLinks(String url) throws ParserException {
        Parser parser = new Parser(url);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.htmlparser.tags.LinkTag");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ObjectFindingVisitor visitor = new ObjectFindingVisitor(clazz);
        try {
            parser.visitAllNodesWith(visitor);
        }
        catch (EncodingChangeException ece) {
            parser.reset();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.htmlparser.tags.LinkTag");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            visitor = new ObjectFindingVisitor(clazz2);
            parser.visitAllNodesWith(visitor);
        }
        Node[] nodes = visitor.getTags();
        Vector<URL> vector = new Vector<URL>();
        int i = 0;
        while (i < nodes.length) {
            try {
                LinkTag link = (LinkTag)nodes[i];
                vector.add(new URL(link.getLink()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            ++i;
        }
        Object[] ret = new URL[vector.size()];
        vector.copyInto(ret);
        return ret;
    }

    protected boolean equivalent(URL[] array1, URL[] array2) {
        boolean ret = false;
        if (array1 == null && array2 == null) {
            ret = true;
        } else if (array1 != null && array2 != null && array1.length == array2.length) {
            ret = true;
            int i = 0;
            while (i < array1.length && ret) {
                if (array1[i] != array2[i]) {
                    ret = false;
                }
                ++i;
            }
        }
        return ret;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertySupport.removePropertyChangeListener(listener);
    }

    private void setLinks() {
        String url = this.getURL();
        if (url != null) {
            try {
                URL[] urls = this.extractLinks(this.getURL());
                if (!this.equivalent(this.mLinks, urls)) {
                    URL[] oldValue = this.mLinks;
                    this.mLinks = urls;
                    this.mPropertySupport.firePropertyChange(PROP_LINKS_PROPERTY, oldValue, this.mLinks);
                }
            }
            catch (ParserException hpe) {
                this.mLinks = null;
            }
        }
    }

    public URL[] getLinks() {
        if (this.mLinks == null) {
            try {
                this.mLinks = this.extractLinks(this.getURL());
                this.mPropertySupport.firePropertyChange(PROP_LINKS_PROPERTY, null, this.mLinks);
            }
            catch (ParserException hpe) {
                this.mLinks = null;
            }
        }
        return this.mLinks;
    }

    public String getURL() {
        return this.mParser.getURL();
    }

    public void setURL(String url) {
        String old = this.getURL();
        if (old == null && url != null || old != null && !old.equals(url)) {
            try {
                this.mParser.setURL(url);
                this.mPropertySupport.firePropertyChange(PROP_URL_PROPERTY, old, this.getURL());
                this.setLinks();
            }
            catch (ParserException parserException) {
                // empty catch block
            }
        }
    }

    public URLConnection getConnection() {
        return this.mParser.getConnection();
    }

    public void setConnection(URLConnection connection) {
        try {
            this.mParser.setConnection(connection);
            this.setLinks();
        }
        catch (ParserException parserException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            System.out.println("Usage: java -classpath htmlparser.jar org.htmlparser.beans.LinkBean <http://whatever_url>");
        } else {
            LinkBean lb = new LinkBean();
            lb.setURL(args[0]);
            URL[] urls = lb.getLinks();
            int i = 0;
            while (i < urls.length) {
                System.out.println(urls[i]);
                ++i;
            }
        }
    }
}

