/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser;

import java.io.Serializable;
import org.htmlparser.Node;
import org.htmlparser.PrototypicalNodeFactory;
import org.htmlparser.lexer.Page;
import org.htmlparser.nodeDecorators.DecodingNode;
import org.htmlparser.nodeDecorators.EscapeCharacterRemovingNode;
import org.htmlparser.nodeDecorators.NonBreakingSpaceConvertingNode;

public class StringNodeFactory
extends PrototypicalNodeFactory
implements Serializable {
    protected boolean mDecode = false;
    protected boolean mRemoveEscapes = false;
    protected boolean mConvertNonBreakingSpaces = false;

    public Node createStringNode(Page page, int start, int end) {
        Node ret = super.createStringNode(page, start, end);
        if (this.getDecode()) {
            ret = new DecodingNode(ret);
        }
        if (this.getRemoveEscapes()) {
            ret = new EscapeCharacterRemovingNode(ret);
        }
        if (this.getConvertNonBreakingSpaces()) {
            ret = new NonBreakingSpaceConvertingNode(ret);
        }
        return ret;
    }

    public void setDecode(boolean decode) {
        this.mDecode = decode;
    }

    public boolean getDecode() {
        return this.mDecode;
    }

    public void setRemoveEscapes(boolean remove) {
        this.mRemoveEscapes = remove;
    }

    public boolean getRemoveEscapes() {
        return this.mRemoveEscapes;
    }

    public void setConvertNonBreakingSpaces(boolean convert) {
        this.mConvertNonBreakingSpaces = convert;
    }

    public boolean getConvertNonBreakingSpaces() {
        return this.mConvertNonBreakingSpaces;
    }
}

