/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.log.FileHeader;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.DeletedDupLNLogEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.CheckpointStart;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINDelta;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INDeleteInfo;
import com.sleepycat.je.tree.INDupDeleteInfo;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.txn.TxnAbort;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.txn.TxnPrepare;
import com.sleepycat.je.utilint.Tracer;
import java.util.HashSet;
import java.util.Set;

public class LogEntryType {
    private static final int MAX_TYPE_NUM = 27;
    private static LogEntryType[] LOG_TYPES = new LogEntryType[27];
    public static final LogEntryType LOG_LN_TRANSACTIONAL = new LogEntryType(1, 0, "LN_TX", new LNLogEntry(LN.class), true, true, true);
    public static final LogEntryType LOG_LN = new LogEntryType(2, 0, "LN", new LNLogEntry(LN.class), false, true, false);
    public static final LogEntryType LOG_MAPLN_TRANSACTIONAL = new LogEntryType(3, 2, "MapLN_TX", new LNLogEntry(MapLN.class), true, true, true);
    public static final LogEntryType LOG_MAPLN = new LogEntryType(4, 2, "MapLN", new LNLogEntry(MapLN.class), false, true, false);
    public static final LogEntryType LOG_NAMELN_TRANSACTIONAL = new LogEntryType(5, 0, "NameLN_TX", new LNLogEntry(NameLN.class), true, true, true);
    public static final LogEntryType LOG_NAMELN = new LogEntryType(6, 0, "NameLN", new LNLogEntry(NameLN.class), false, true, false);
    public static final LogEntryType LOG_DEL_DUPLN_TRANSACTIONAL = new LogEntryType(7, 0, "DelDupLN_TX", new DeletedDupLNLogEntry(), true, true, true);
    public static final LogEntryType LOG_DEL_DUPLN = new LogEntryType(8, 0, "DelDupLN", new DeletedDupLNLogEntry(), false, true, false);
    public static final LogEntryType LOG_DUPCOUNTLN_TRANSACTIONAL = new LogEntryType(9, 0, "DupCountLN_TX", new LNLogEntry(DupCountLN.class), true, true, true);
    public static final LogEntryType LOG_DUPCOUNTLN = new LogEntryType(10, 0, "DupCountLN", new LNLogEntry(DupCountLN.class), false, true, false);
    public static final LogEntryType LOG_FILESUMMARYLN = new LogEntryType(11, 3, "FileSummaryLN", new LNLogEntry(FileSummaryLN.class), false, false, false);
    public static final LogEntryType LOG_IN = new LogEntryType(12, 2, "IN", new INLogEntry(IN.class), false, true, false);
    public static final LogEntryType LOG_BIN = new LogEntryType(13, 2, "BIN", new INLogEntry(BIN.class), false, true, false);
    public static final LogEntryType LOG_DIN = new LogEntryType(14, 2, "DIN", new INLogEntry(DIN.class), false, true, false);
    public static final LogEntryType LOG_DBIN = new LogEntryType(15, 2, "DBIN", new INLogEntry(DBIN.class), false, true, false);
    public static final LogEntryType[] IN_TYPES = new LogEntryType[]{LOG_IN, LOG_BIN, LOG_DIN, LOG_DBIN};
    private static final int MAX_NODE_TYPE_NUM = 15;
    public static final LogEntryType LOG_ROOT = new LogEntryType(16, 1, "Root", new SingleItemEntry(DbTree.class), false, true, false);
    public static final LogEntryType LOG_TXN_COMMIT = new LogEntryType(17, 0, "Commit", new SingleItemEntry(TxnCommit.class), true, true, true);
    public static final LogEntryType LOG_TXN_ABORT = new LogEntryType(18, 0, "Abort", new SingleItemEntry(TxnAbort.class), true, true, true);
    public static final LogEntryType LOG_CKPT_START = new LogEntryType(19, 0, "CkptStart", new SingleItemEntry(CheckpointStart.class), false, true, false);
    public static final LogEntryType LOG_CKPT_END = new LogEntryType(20, 0, "CkptEnd", new SingleItemEntry(CheckpointEnd.class), false, true, false);
    public static final LogEntryType LOG_IN_DELETE_INFO = new LogEntryType(21, 0, "INDelete", new SingleItemEntry(INDeleteInfo.class), false, true, false);
    public static final LogEntryType LOG_BIN_DELTA = new LogEntryType(22, 0, "BINDelta", new BINDeltaLogEntry(BINDelta.class), false, true, false);
    public static final LogEntryType LOG_DUP_BIN_DELTA = new LogEntryType(23, 0, "DupBINDelta", new BINDeltaLogEntry(BINDelta.class), false, true, false);
    public static final LogEntryType LOG_TRACE = new LogEntryType(24, 0, "Trace", new SingleItemEntry(Tracer.class), false, true, false);
    public static final LogEntryType LOG_FILE_HEADER = new LogEntryType(25, 0, "FileHeader", new SingleItemEntry(FileHeader.class), false, true, false);
    public static final LogEntryType LOG_IN_DUPDELETE_INFO = new LogEntryType(26, 0, "INDupDelete", new SingleItemEntry(INDupDeleteInfo.class), false, true, false);
    public static final LogEntryType LOG_TXN_PREPARE = new LogEntryType(27, 0, "Prepare", new SingleItemEntry(TxnPrepare.class), true, true, false);
    private static final byte PROVISIONAL_MASK = -128;
    private static final byte IGNORE_PROVISIONAL = 127;
    private static final byte REPLICATED_MASK = 64;
    private static final byte IGNORE_REPLICATED = -65;
    private byte typeNum;
    private byte version;
    private String displayName;
    private LogEntry logEntry;
    private boolean isTransactional;
    private boolean marshallOutsideLatch;
    private boolean isTypeReplicated;

    public static boolean isNodeType(byte typeNum, byte version) {
        return typeNum <= 15;
    }

    LogEntryType(byte typeNum, byte version) {
        this.typeNum = typeNum;
        this.version = version;
    }

    private LogEntryType(byte typeNum, byte version, String displayName, LogEntry logEntry, boolean isTransactional, boolean marshallOutsideLatch, boolean isTypeReplicated) {
        this.typeNum = typeNum;
        this.version = version;
        this.displayName = displayName;
        this.logEntry = logEntry;
        this.isTransactional = isTransactional;
        this.marshallOutsideLatch = marshallOutsideLatch;
        this.isTypeReplicated = isTypeReplicated;
        logEntry.setLogType(this);
        LogEntryType.LOG_TYPES[typeNum - 1] = this;
    }

    public boolean isNodeType() {
        return this.typeNum <= 15;
    }

    public static LogEntryType findType(byte typeNum, byte version) {
        if (typeNum <= 0 || typeNum > 27) {
            return null;
        }
        return LOG_TYPES[typeNum - 1];
    }

    public static Set getAllTypes() {
        HashSet<LogEntryType> ret = new HashSet<LogEntryType>();
        for (int i = 0; i < 27; ++i) {
            ret.add(LOG_TYPES[i]);
        }
        return ret;
    }

    public LogEntry getSharedLogEntry() {
        return this.logEntry;
    }

    LogEntry getNewLogEntry() throws DatabaseException {
        try {
            return (LogEntry)this.logEntry.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new DatabaseException(e);
        }
    }

    public static byte getVersionValue(byte version) {
        byte value = (byte)(version & 0x7F);
        value = (byte)(value & 0xFFFFFFBF);
        return value;
    }

    static byte setEntryProvisional(byte version) {
        return (byte)(version | 0xFFFFFF80);
    }

    static boolean isEntryProvisional(byte version) {
        return (version & 0xFFFFFF80) != 0;
    }

    static byte setEntryReplicated(byte version) {
        return (byte)(version | 0x40);
    }

    public static boolean isEntryReplicated(byte version) {
        return (version & 0x40) != 0;
    }

    byte getTypeNum() {
        return this.typeNum;
    }

    byte getVersion() {
        return this.version;
    }

    static boolean isValidType(byte typeNum) {
        return typeNum > 0 && typeNum <= 27;
    }

    public String toString() {
        return this.displayName + "/" + this.version;
    }

    boolean equalsType(byte typeNum, byte version) {
        return this.typeNum == typeNum;
    }

    public boolean equalsType(byte typeNum) {
        return this.typeNum == typeNum;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LogEntryType)) {
            return false;
        }
        return this.typeNum == ((LogEntryType)obj).typeNum;
    }

    public int hashCode() {
        return this.typeNum;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public boolean marshallOutsideLatch() {
        return this.marshallOutsideLatch;
    }

    public boolean isTypeReplicated() {
        return this.isTypeReplicated;
    }
}

