/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogSource;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

class FileSource
implements LogSource {
    private RandomAccessFile file;
    private int readBufferSize;
    private FileManager fileManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    FileSource(RandomAccessFile file, int readBufferSize, FileManager fileManager) {
        this.file = file;
        this.readBufferSize = readBufferSize;
        this.fileManager = fileManager;
    }

    public void release() throws DatabaseException {
    }

    public ByteBuffer getBytes(long fileOffset) throws IOException {
        ByteBuffer destBuf = ByteBuffer.allocate(this.readBufferSize);
        this.fileManager.readFromFile(this.file, destBuf, fileOffset);
        if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
            throw new AssertionError();
        }
        destBuf.flip();
        return destBuf;
    }

    public ByteBuffer getBytes(long fileOffset, int numBytes) throws IOException {
        ByteBuffer destBuf = ByteBuffer.allocate(numBytes);
        this.fileManager.readFromFile(this.file, destBuf, fileOffset);
        if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
            throw new AssertionError();
        }
        destBuf.flip();
        if (!$assertionsDisabled && destBuf.remaining() < numBytes) {
            throw new AssertionError((Object)("remaining=" + destBuf.remaining() + " numBytes=" + numBytes));
        }
        return destBuf;
    }

    static {
        $assertionsDisabled = !FileSource.class.desiredAssertionStatus();
    }
}

