/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function.VBScript;

import java.util.Date;
import java.util.Stack;
import jun.db.core.ObjectTool;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class Comparative
extends PostfixMathCommand {
    int id;
    double tolerance;

    public Comparative(int id_in) {
        this.id = id_in;
        this.numberOfParameters = 2;
        this.tolerance = 1.0E-6;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        if (param1 instanceof Number && param2 instanceof Number) {
            boolean r;
            double x = ((Number)param1).doubleValue();
            double y = ((Number)param2).doubleValue();
            switch (this.id) {
                case 0: {
                    r = x < y;
                    break;
                }
                case 1: {
                    r = x > y;
                    break;
                }
                case 2: {
                    r = x <= y;
                    break;
                }
                case 3: {
                    r = x >= y;
                    break;
                }
                case 4: {
                    r = x != y;
                    break;
                }
                case 5: {
                    r = x == y;
                    break;
                }
                default: {
                    throw new ParseException("Unknown relational operator");
                }
            }
            inStack.push(new Double((double)r));
        } else if (param1 instanceof String && param2 instanceof String) {
            boolean r;
            String x = (String)param1;
            String y = (String)param2;
            switch (this.id) {
                case 0: {
                    r = x.compareTo(y) < 0;
                    break;
                }
                case 1: {
                    r = x.compareTo(y) > 0;
                    break;
                }
                case 2: {
                    r = x.compareTo(y) <= 0;
                    break;
                }
                case 3: {
                    r = x.compareTo(y) >= 0;
                    break;
                }
                case 4: {
                    r = !x.equals(y);
                    break;
                }
                case 5: {
                    r = x.equals(y);
                    break;
                }
                default: {
                    throw new ParseException("Relational operator type error");
                }
            }
            inStack.push(new Double((double)r));
        } else if (param1 instanceof Date && param2 instanceof Date) {
            Date x = null;
            Date y = null;
            try {
                x = (Date)ObjectTool.ChangeType(param1, (String)"java.util.Date");
                y = (Date)ObjectTool.ChangeType(param2, (String)"java.util.Date");
                if (x == null) {
                    x = new Date(0L);
                }
                if (y == null) {
                    y = new Date(0L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (this.id) {
                case 0: {
                    boolean r = x.compareTo(y) < 0;
                    break;
                }
                case 1: {
                    boolean r = x.compareTo(y) > 0;
                    break;
                }
                case 2: {
                    boolean r = x.compareTo(y) <= 0;
                    break;
                }
                case 3: {
                    boolean r = x.compareTo(y) >= 0;
                    break;
                }
                case 4: {
                    boolean r = !x.equals(y);
                    break;
                }
                case 5: {
                    boolean r = x.equals(y);
                    break;
                }
                default: {
                    throw new ParseException("Relational operator type error");
                }
            }
            throw new ParseException("Invalid parameter type");
        }
    }
}

