/*
 * Decompiled with CFR 0.152.
 */
package jun.xml.write;

public final class XmlW {
    public static String replaceString(String text, String repl, String with) {
        return XmlW.replaceString(text, repl, with, -1);
    }

    public static String replaceString(String text, String repl, String with, int max) {
        if (text == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buffer.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max == 0) break;
        }
        buffer.append(text.substring(start));
        return buffer.toString();
    }

    public static String escapeXml(String str) {
        str = XmlW.replaceString(str, "&", "&amp;");
        str = XmlW.replaceString(str, "<", "&lt;");
        str = XmlW.replaceString(str, ">", "&gt;");
        str = XmlW.replaceString(str, "\"", "&quot;");
        str = XmlW.replaceString(str, "'", "&apos;");
        return str;
    }

    public static String unescapeXml(String str) {
        str = XmlW.replaceString(str, "&amp;", "&");
        str = XmlW.replaceString(str, "&lt;", "<");
        str = XmlW.replaceString(str, "&gt;", ">");
        str = XmlW.replaceString(str, "&quot;", "\"");
        str = XmlW.replaceString(str, "&apos;", "'");
        return str;
    }

    /*
     * Unable to fully structure code
     */
    public static String removeXml(String str) {
        sz = str.length();
        buffer = new StringBuffer(sz);
        inString = false;
        inTag = false;
        i = 0;
        while (i < sz) {
            block4: {
                ch = str.charAt(i);
                if (ch != '<') break block4;
                inTag = true;
                ** GOTO lbl-1000
            }
            if (ch == '>') {
                inTag = false;
            } else if (!inTag) {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static int countMatches(String str, String sub) {
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static String getContent(String tag, String text) {
        int idx = XmlW.getIndexOpeningTag(tag, text);
        if (idx == -1) {
            return "";
        }
        text = text.substring(idx);
        int end = XmlW.getIndexClosingTag(tag, text);
        idx = text.indexOf(62);
        if (idx == -1) {
            return "";
        }
        return text.substring(idx + 1, end);
    }

    public static int getIndexOpeningTag(String tag, String text) {
        return XmlW.getIndexOpeningTag(tag, text, 0);
    }

    private static int getIndexOpeningTag(String tag, String text, int start) {
        int idx = text.indexOf("<" + tag, start);
        if (idx == -1) {
            return -1;
        }
        char next = text.charAt(idx + 1 + tag.length());
        if (next == '>' || Character.isWhitespace(next)) {
            return idx;
        }
        return XmlW.getIndexOpeningTag(tag, text, idx + 1);
    }

    public static int getIndexClosingTag(String tag, String text) {
        return XmlW.getIndexClosingTag(tag, text, 0);
    }

    public static int getIndexClosingTag(String tag, String text, int start) {
        String open = "<" + tag;
        String close = "</" + tag + ">";
        int closeSz = close.length();
        int nextCloseIdx = text.indexOf(close, start);
        if (nextCloseIdx == -1) {
            return -1;
        }
        int count = XmlW.countMatches(text.substring(start, nextCloseIdx), open);
        if (count == 0) {
            return -1;
        }
        int expected = 1;
        while (count != expected) {
            if ((nextCloseIdx = text.indexOf(close, nextCloseIdx + closeSz)) == -1) {
                return -1;
            }
            count = XmlW.countMatches(text.substring(start, nextCloseIdx), open);
            ++expected;
        }
        return nextCloseIdx;
    }

    public static String getAttribute(String attribute, String text) {
        return XmlW.getAttribute(attribute, text, 0);
    }

    public static String getAttribute(String attribute, String text, int idx) {
        int close = text.indexOf(">", idx);
        int attrIdx = text.indexOf(String.valueOf(attribute) + "=\"", idx);
        if (attrIdx == -1) {
            return null;
        }
        if (attrIdx > close) {
            return null;
        }
        int attrStartIdx = attrIdx + attribute.length() + 2;
        int attrCloseIdx = text.indexOf("\"", attrStartIdx);
        if (attrCloseIdx > close) {
            return null;
        }
        return XmlW.unescapeXml(text.substring(attrStartIdx, attrCloseIdx));
    }
}

