/*
 * Decompiled with CFR 0.152.
 */
package jun.db.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import jun.db.core.ObjectTool;

public class ToString {
    public static String GetPattern(int DecimalCount, char DecimalSeparator, boolean ShowComma, char GroupingSeparator) {
        String pattern;
        if (DecimalCount == 0) {
            pattern = "###,###,###,###,###,###,##0";
        } else {
            String t = "00000000000000000000";
            t = t.substring(0, DecimalCount);
            pattern = "###,###,###,###,###,###,##0." + t;
        }
        if (DecimalSeparator != '.') {
            pattern = pattern.replaceAll(".", String.valueOf(DecimalSeparator));
        }
        if (!ShowComma) {
            pattern = pattern.replaceAll(",", "");
        }
        if (ShowComma && GroupingSeparator != ',') {
            pattern = pattern.replaceAll(",", String.valueOf(GroupingSeparator));
        }
        return pattern;
    }

    static double Round(double num, int i) {
        return ObjectTool.Round(num, i);
    }

    public static String double2String(double dblValue, boolean showComma, int decimalCount) {
        String pattern = ToString.GetPattern(decimalCount, '.', showComma, ',');
        int n = pattern.length();
        int p = pattern.indexOf(".");
        if (p < 0) {
            p = n;
        }
        int DecimalCount = n - p;
        DecimalFormat df = new DecimalFormat(pattern);
        df.setGroupingSize(3);
        return df.format(ToString.Round(dblValue, DecimalCount));
    }

    public static String double2String(BigDecimal bd, boolean showComma, int decimalCount) {
        double dblValue = bd.doubleValue();
        String pattern = ToString.GetPattern(decimalCount, '.', showComma, ',');
        int n = pattern.length();
        int p = pattern.indexOf(".");
        if (p < 0) {
            p = n;
        }
        int DecimalCount = n - p;
        DecimalFormat df = new DecimalFormat(pattern);
        df.setGroupingSize(3);
        String bstr = df.format(ToString.Round(dblValue, DecimalCount));
        if (bstr.length() > 17 && decimalCount == 0) {
            bstr = bd.toString();
        }
        if (decimalCount == 0 && (p = bstr.indexOf(".")) >= 0) {
            bstr = bstr.substring(0, p);
        }
        return bstr;
    }

    public static String convertDateMask(String mask) {
        return mask.replaceAll("YYYY", "yyyy").replaceAll("YY", "yy").replaceAll("DD", "dd").replaceAll("hh", "HH");
    }

    public static String date2String(Date d, String mask) {
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        try {
            dateFormat.applyPattern(mask);
            dateFormat.setLenient(false);
            return dateFormat.format(d);
        }
        catch (Exception e) {
            String s = mask;
            s = s.replaceAll("y", " ").replaceAll("m", " ").replaceAll("d", " ").replaceAll("h", " ").replaceAll("s", " ").replaceAll("Y", " ").replaceAll("M", " ").replaceAll("D", " ").replaceAll("H", " ").replaceAll("S", " ");
            return s;
        }
    }
}

