/*
 * Decompiled with CFR 0.152.
 */
package jun.db.util;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class IdGen {
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private long twepoch = 1288834974657L;
    private long workerIdBits = 5L;
    private long datacenterIdBits = 5L;
    private long maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.workerIdBits;
    private long maxDatacenterId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.datacenterIdBits;
    private long sequenceBits;
    private long workerIdShift = this.sequenceBits = 12L;
    private long datacenterIdShift = this.sequenceBits + this.workerIdBits;
    private long timestampLeftShift = this.sequenceBits + this.workerIdBits + this.datacenterIdBits;
    private long sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.sequenceBits;
    private long lastTimestamp = -1L;

    public static IdGen get() {
        return IdGenHolder.instance;
    }

    public IdGen() {
        this(0L, 0L);
    }

    public IdGen(long workerId, long datacenterId) {
        if (workerId > this.maxWorkerId || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", this.maxWorkerId));
        }
        if (datacenterId > this.maxDatacenterId || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", this.maxDatacenterId));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << (int)this.timestampLeftShift | this.datacenterId << (int)this.datacenterIdShift | this.workerId << (int)this.workerIdShift | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    public static void main(String[] arg) {
        long avg = 0L;
        int k = 0;
        while (k < 10) {
            ArrayList<1> partitions = new ArrayList<1>();
            IdGen idGen = IdGen.get();
            int i = 0;
            while (i < 1400) {
                partitions.add(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long ll = IdGen.this.nextId();
                        System.out.println(ll);
                        return ll;
                    }
                });
                ++i;
            }
            ExecutorService executorPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            try {
                long s = System.currentTimeMillis();
                executorPool.invokeAll(partitions, 10000L, TimeUnit.SECONDS);
                long s_avg = System.currentTimeMillis() - s;
                avg += s_avg;
                System.out.println("\u5b8c\u6210\u65f6\u95f4\u9700\u8981: " + (double)s_avg / 1000.0 + "\u79d2");
                executorPool.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++k;
        }
        System.out.println("\u5e73\u5747\u5b8c\u6210\u65f6\u95f4\u9700\u8981: " + (double)(avg / 10L) / 1000.0 + "\u79d2");
    }

    private static class IdGenHolder {
        private static final IdGen instance = new IdGen();

        private IdGenHolder() {
        }
    }
}

