/*
 * Decompiled with CFR 0.152.
 */
package jun.db.util;

public class Base32Coder {
    private static final char[] ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7'};
    private static final byte[] DECODE_TABLE = new byte[128];

    static {
        int i = 0;
        while (i < DECODE_TABLE.length) {
            Base32Coder.DECODE_TABLE[i] = -1;
            ++i;
        }
        i = 0;
        while (i < ALPHABET.length) {
            Base32Coder.DECODE_TABLE[Base32Coder.ALPHABET[i]] = (byte)i;
            if (i < 24) {
                Base32Coder.DECODE_TABLE[Character.toLowerCase((char)Base32Coder.ALPHABET[i])] = (byte)i;
            }
            ++i;
        }
    }

    public static String encode(String s) {
        return Base32Coder.encode(s, "UTF-8");
    }

    public static String encode(String s, String charset) {
        try {
            return Base32Coder.encode(s.getBytes(charset));
        }
        catch (Exception e) {
            return Base32Coder.encode(s.getBytes());
        }
    }

    public static String encode(byte[] data) {
        char[] chars = new char[data.length * 8 / 5 + (data.length % 5 != 0 ? 1 : 0)];
        int i = 0;
        int j = 0;
        int index = 0;
        while (i < chars.length) {
            if (index > 3) {
                int b = data[j] & 255 >> index;
                index = (index + 5) % 8;
                b <<= index;
                if (j < data.length - 1) {
                    b |= (data[j + 1] & 0xFF) >> 8 - index;
                }
                chars[i] = ALPHABET[b];
                ++j;
            } else {
                chars[i] = ALPHABET[data[j] >> 8 - (index + 5) & 0x1F];
                if ((index = (index + 5) % 8) == 0) {
                    ++j;
                }
            }
            ++i;
        }
        return new String(chars);
    }

    public static byte[] decode(String s) {
        char[] stringData = s.toCharArray();
        byte[] data = new byte[stringData.length * 5 / 8];
        int i = 0;
        int j = 0;
        int index = 0;
        while (i < stringData.length) {
            byte val = 0;
            try {
                val = DECODE_TABLE[stringData[i]];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (index <= 3) {
                if ((index = (index + 5) % 8) == 0) {
                    int n = j++;
                    data[n] = (byte)(data[n] | val);
                } else {
                    int n = j;
                    data[n] = (byte)(data[n] | val << 8 - index);
                }
            } else {
                index = (index + 5) % 8;
                int n = j++;
                data[n] = (byte)(data[n] | val >> index);
                if (j < data.length) {
                    int n2 = j;
                    data[n2] = (byte)(data[n2] | val << 8 - index);
                }
            }
            ++i;
        }
        return data;
    }

    public static void main(String[] args) {
        try {
            String s = "\u5e02\u739b\u7459";
            String t = Base32Coder.encode(s);
            String t2 = new String(Base32Coder.decode(t));
            System.out.println(s);
            System.out.println(t);
            System.out.println(t2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

