/*
 * Decompiled with CFR 0.152.
 */
package jun.db.rpc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import jun.db.core.DataAdapter;
import jun.db.core.DataStore;
import jun.db.core.Logger;
import jun.db.impl.DataStoreFactory;
import jun.db.impl.Sequence;
import jun.db.rpc.DBF;
import jun.db.rpc.RPCParameter;
import jun.db.rpc.RemoteCaller;
import jun.db.util.TimeMark;
import jun.db.util.ZDataParser;

public class DataStoreRemoteFactory
extends RemoteCaller {
    public RPCParameter updateRemote(RPCParameter param) {
        RPCParameter ret;
        block14: {
            ret = new RPCParameter();
            DBF dbf = DBF.getInstance();
            Connection con = null;
            String sql = "";
            try {
                try {
                    String dbpool = param.get("dbpool", "");
                    boolean executeBatch = !dbpool.equals("") && !dbpool.equals("default") && !dbpool.equals("wisestudio_oa");
                    con = dbf.getConnection(dbpool);
                    Statement cmd = con.createStatement();
                    ArrayList sqlList = (ArrayList)param.get("sqllist");
                    boolean printSQL = param.get("printSQL", false);
                    boolean includeUpdateBlob = false;
                    int h = 0;
                    while (h < sqlList.size()) {
                        sql = (String)sqlList.get(h);
                        if (sql.startsWith("updateblob")) {
                            includeUpdateBlob = true;
                        } else if (executeBatch) {
                            cmd.addBatch(sql);
                        } else {
                            if (printSQL) {
                                Logger.info(sql);
                            }
                            cmd.execute(sql);
                        }
                        ++h;
                    }
                    cmd.executeBatch();
                    if (includeUpdateBlob) {
                        DataAdapter da = DataStoreFactory.createDataAdapter(con);
                        int h2 = 0;
                        while (h2 < sqlList.size()) {
                            sql = (String)sqlList.get(h2);
                            if (sql.startsWith("updateblob")) {
                                ZDataParser zdp = new ZDataParser(sql.substring(10));
                                String table = zdp.get("table", "");
                                String col = zdp.get("col", "");
                                String where = zdp.get("where", "");
                                String value = zdp.get("value", "");
                                da.clobModify(con, table, col, where, value, printSQL);
                            }
                            ++h2;
                        }
                    }
                    ret.setSuccess(true);
                }
                catch (Exception e) {
                    ret.setSuccess(false);
                    ret.setErrorText("\u8bed\u53e5\u662f:" + sql + "\n\u9519\u8bef\u662f\uff1a" + e.getMessage());
                    dbf.ReleaseConnection(con);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                dbf.ReleaseConnection(con);
                throw throwable;
            }
            dbf.ReleaseConnection(con);
        }
        return ret;
    }

    public RPCParameter executeRemote(RPCParameter param) {
        RPCParameter ret;
        block12: {
            ret = new RPCParameter();
            DBF dbf = DBF.getInstance();
            Connection con = null;
            Statement cmd = null;
            try {
                try {
                    String dbpool = param.get("dbpool", "");
                    con = dbf.getConnection(dbpool);
                    cmd = con.createStatement();
                    String sql = param.get("sql", "");
                    int timeout = param.get("timeout", 0);
                    sql = con.nativeSQL(sql);
                    if (timeout > 0) {
                        cmd.setQueryTimeout(timeout);
                    }
                    cmd.execute(sql);
                    cmd.close();
                    ret.setSuccess(true);
                }
                catch (Exception e) {
                    ret.setSuccess(false);
                    ret.setErrorText(e.getMessage());
                    try {
                        cmd.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    dbf.ReleaseConnection(con);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    cmd.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                dbf.ReleaseConnection(con);
                throw throwable;
            }
            try {
                cmd.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            dbf.ReleaseConnection(con);
        }
        return ret;
    }

    public RPCParameter nextSequenceRemote(RPCParameter param) {
        RPCParameter ret;
        block5: {
            ret = new RPCParameter();
            DBF dbf = DBF.getInstance();
            Connection con = null;
            Object cmd = null;
            try {
                try {
                    String dbpool = param.get("dbpool", "");
                    con = dbf.getConnection(dbpool);
                    String name = param.get("name", "");
                    ret.put("sequence", Sequence.NextSequence(con, name));
                    ret.setSuccess(true);
                }
                catch (Exception e) {
                    ret.setSuccess(false);
                    ret.put("sequence", -1);
                    ret.setErrorText(e.getMessage());
                    dbf.ReleaseConnection(con);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                dbf.ReleaseConnection(con);
                throw throwable;
            }
            dbf.ReleaseConnection(con);
        }
        return ret;
    }

    public RPCParameter retrieveRemote(RPCParameter param) {
        RPCParameter ret;
        block6: {
            ret = new RPCParameter();
            DBF dbf = DBF.getInstance();
            Connection con = null;
            try {
                try {
                    String dbpool = param.get("dbpool", "");
                    TimeMark tm = new TimeMark(false);
                    if (dbpool.equals("jdbc/jxtf")) {
                        tm = new TimeMark(true);
                    }
                    String where = param.get("where", "");
                    int onceRetrieveCount = param.get("onceretrievecount", 0);
                    int absolute = param.get("absolute", 0);
                    int timeout = param.get("timeout", 0);
                    con = dbf.getConnection(dbpool);
                    DataStore ds = (DataStore)param.get("datastore");
                    String replaceSelect = param.get("replaceSelect", "");
                    ds.setConnection(con);
                    ds.setTimeout(timeout);
                    ds.setRemoteFactoryURL("");
                    ds.replaceSelect(replaceSelect);
                    tm.stamp(" select=   " + replaceSelect + " \nwhere: " + where + " \ntimeout: " + timeout + " \ndbCharset:" + ds.getDBCharset() + " clientCharset:" + ds.getCharset() + " autoconvert:" + ds.isCharsetAutoConvert());
                    ds.setOnceRetrieveCount(onceRetrieveCount);
                    ds.setAbsolute(absolute);
                    ds.retrieve(where);
                    tm.stamp("\u68c0\u7d22\u5b8c\u6210");
                    ret.put("data", ds.getData());
                    ret.put("SelectLastRetrieved", ds.getSelectLastRetrieved());
                    ret.setSuccess(true);
                }
                catch (Exception e) {
                    ret.setSuccess(false);
                    Logger.error(e.getMessage());
                    ret.setErrorText(e.getMessage());
                    dbf.ReleaseConnection(con);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                dbf.ReleaseConnection(con);
                throw throwable;
            }
            dbf.ReleaseConnection(con);
        }
        return ret;
    }

    public RPCParameter retrieveProcedureRemote(RPCParameter param) {
        RPCParameter ret;
        block6: {
            ret = new RPCParameter();
            DBF dbf = DBF.getInstance();
            Connection con = null;
            try {
                try {
                    String dbpool = param.get("dbpool", "");
                    ArrayList pp = (ArrayList)param.get("param");
                    int onceRetrieveCount = param.get("onceretrievecount", 0);
                    int absolute = param.get("absolute", 0);
                    int timeout = param.get("timeout", 0);
                    con = dbf.getConnection(dbpool);
                    DataStore ds = (DataStore)param.get("datastore");
                    ds.setConnection(con);
                    ds.setTimeout(timeout);
                    ds.setRemoteFactoryURL("");
                    String replaceSelect = param.get("replaceSelect", "");
                    ds.replaceSelect(replaceSelect);
                    ds.setOnceRetrieveCount(onceRetrieveCount);
                    ds.setAbsolute(absolute);
                    ds.retrieveProcedure(pp);
                    ds.close();
                    ret.put("data", ds.getData());
                    if (param.get("recreate", 0) == 1) {
                        ret.put("columninfo", ds.getColumnInfo());
                    }
                    ret.setSuccess(true);
                }
                catch (Exception e) {
                    ret.setSuccess(false);
                    Logger.error(e.getMessage());
                    ret.setErrorText(e.getMessage());
                    dbf.ReleaseConnection(con);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                dbf.ReleaseConnection(con);
                throw throwable;
            }
            dbf.ReleaseConnection(con);
        }
        return ret;
    }

    public RPCParameter createDataStore(RPCParameter param) {
        RPCParameter ret;
        block6: {
            ret = new RPCParameter();
            DBF dbf = DBF.getInstance();
            Connection con = null;
            try {
                try {
                    String dbpool = param.get("dbpool", "");
                    String sql = param.get("select", "");
                    String homeURL = param.get("homeurl", "");
                    int timeout = param.get("timeout", 0);
                    String dbCharset = DBF.getConnectionDatabaseCharset(dbpool);
                    String charset = DBF.getConnectionClientCharset(dbpool);
                    con = dbf.getConnection(dbpool);
                    if (timeout == -999999) {
                        timeout = DBF.getConnectMaximumActiveTime(dbpool);
                    }
                    DataStore ds = DataStoreFactory.newDataStore(con, sql, dbCharset, charset, timeout);
                    ds.setRemoteFactoryURL(homeURL);
                    ds.setDBPoolName(dbpool);
                    ret.put("datastore", ds);
                    ret.setSuccess(true);
                }
                catch (Exception e) {
                    ret.setSuccess(false);
                    Logger.error(e.getMessage());
                    ret.setErrorText(e.getMessage());
                    dbf.ReleaseConnection(con);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                dbf.ReleaseConnection(con);
                throw throwable;
            }
            dbf.ReleaseConnection(con);
        }
        return ret;
    }

    public RPCParameter getDBRowCountRemote(RPCParameter param) {
        RPCParameter ret;
        block6: {
            ret = new RPCParameter();
            DBF dbf = DBF.getInstance();
            Connection con = null;
            try {
                try {
                    String dbpool = param.get("dbpool", "");
                    String select = param.get("select", "");
                    String where = param.get("where", "");
                    int timeout = param.get("timeout", 0);
                    boolean charsetAutoConvert = param.get("CharsetAutoConvert", false);
                    String dbCharset = DBF.getConnectionDatabaseCharset(dbpool);
                    String charset = DBF.getConnectionClientCharset(dbpool);
                    con = dbf.getConnection(dbpool);
                    select = DataStoreFactory.LinkUpWhere(select, where);
                    DataStore ds = DataStoreFactory.newDataStore(con, select);
                    String sql = ds.parseInnerParameter(select, false);
                    sql = ds.getDataAdapter().toLocalSyntax(sql);
                    if (charsetAutoConvert) {
                        sql = DataStoreFactory.stringCharsetConvert(sql, charset, dbCharset);
                    }
                    ret.put("count", DataStoreRemoteFactory.getRowCount(sql, con, timeout));
                    ret.setSuccess(true);
                }
                catch (Exception e) {
                    ret.setSuccess(false);
                    Logger.error(e.getMessage());
                    ret.setErrorText(e.getMessage());
                    dbf.ReleaseConnection(con);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                dbf.ReleaseConnection(con);
                throw throwable;
            }
            dbf.ReleaseConnection(con);
        }
        return ret;
    }

    /*
     * Loose catch block
     */
    public static boolean SafeExecute(Connection con, String sql) {
        Statement cmd = null;
        cmd = con.createStatement();
        cmd.execute(sql.toString());
        cmd.close();
        try {
            cmd.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
        catch (Exception e) {
            try {
                cmd.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
            catch (Throwable throwable) {
                try {
                    cmd.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static int getRowCount(String select, Connection con, int timeout) throws Exception {
        String sql = select.trim();
        if (!sql.toLowerCase().startsWith("select ")) {
            throw new Exception(" getRowCount \u5bf9\u5b58\u50a8\u8fc7\u7a0b\u4e0d\u652f\u6301\u3002");
        }
        int ret = 0;
        ResultSet rs = null;
        Statement cmd = null;
        try {
            try {
                String dbSql = "select count(*) from ( " + sql + ")   table19741211";
                cmd = con.createStatement();
                if (timeout > 0) {
                    cmd.setQueryTimeout(timeout);
                }
                rs = cmd.executeQuery(dbSql);
                rs.next();
                Object v = rs.getObject(1);
                if (v != null && v instanceof Number) {
                    ret = ((Number)v).intValue();
                }
            }
            catch (Exception e) {
                SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMddHHmmssSSS");
                String viewName = "v" + SDF.format(new Date()) + new Random().nextInt(10000);
                try {
                    try {
                        cmd.execute(" create  view  " + viewName + " as " + sql);
                        String dbSql = "select count(*) from    " + viewName;
                        rs = cmd.executeQuery(dbSql);
                        rs.next();
                        Object v = rs.getObject(1);
                        if (v != null && v instanceof Number) {
                            ret = ((Number)v).intValue();
                        }
                    }
                    catch (Exception e2) {
                        try {
                            String dbSql = sql;
                            rs = cmd.executeQuery(dbSql);
                            int rc = 0;
                            while (rs.next()) {
                                ++rc;
                            }
                            ret = rc;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    try {
                        cmd.execute("drop view " + viewName);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (cmd != null) {
                    cmd.close();
                }
                rs = null;
                cmd = null;
            }
            catch (Exception exception) {}
        }
        return ret;
    }
}

